/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGVALUE_H
#define _SC_CONFIGVALUE_H

// sc
#include "util/String.h"

// sys
#include <vector>


class ConfigValue
{
public:
  ConfigValue( const sc::String& key, const sc::String& value );
  ConfigValue( const sc::String& key, unsigned long value );
  ConfigValue( const sc::String& key, long value );
  ConfigValue( const sc::String& key, bool value );
  ConfigValue( const ConfigValue& );

  const sc::String& getKey() const;

  const sc::String& getStringValue() const;
  unsigned long getOptionValue() const;
  long getNumericValue() const;
  bool getBoolValue() const;

  void setStringValue( const sc::String& );
  void setOptionValue( unsigned long );
  void setNumericValue( long );
  void setBoolValue( bool );

  bool isNull();

private:
  sc::String _key;
  sc::String _value;
};


typedef std::vector<ConfigValue> ConfigValues;


#endif // _SC_CONFIGVALUE_H
