% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis_base.R
\name{getTestActions}
\alias{getTestActions}
\title{Get Test Actions}
\usage{
getTestActions(stageResults, ...)
}
\arguments{
\item{stageResults}{The results at given stage, obtained from \code{\link{getStageResults}}.}

\item{...}{Only available for backward compatibility.}
}
\value{
Returns a \code{\link[base]{character}} vector of length \code{kMax} 
Returns a \code{\link[base]{numeric}} vector of length \code{kMax}containing the test actions of each stage.
}
\description{
Returns test actions.
}
\details{
Returns the test actions of the specified design and stage results at the specified stage.
}
\examples{
design <- getDesignInverseNormal(kMax = 2)
data <- getDataset(
    n      = c( 20,  30),
    means  = c( 50,  51),
    stDevs = c(130, 140)
)
getTestActions(getStageResults(design, dataInput = data))

}
\seealso{
Other analysis functions: 
\code{\link{getAnalysisResults}()},
\code{\link{getClosedCombinationTestResults}()},
\code{\link{getClosedConditionalDunnettTestResults}()},
\code{\link{getConditionalPower}()},
\code{\link{getConditionalRejectionProbabilities}()},
\code{\link{getFinalConfidenceInterval}()},
\code{\link{getFinalPValue}()},
\code{\link{getRepeatedConfidenceIntervals}()},
\code{\link{getRepeatedPValues}()},
\code{\link{getStageResults}()}
}
\concept{analysis functions}
