// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type AssignSecondaryIpsRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* networkInterface ID  */
    NetworkInterfaceId string `json:"networkInterfaceId"`

    /* secondary ip被其他接口占用时，是否抢占。false：非抢占重分配，true：抢占重分配，默认抢占重分配。默认值：true (Optional) */
    Force *bool `json:"force"`

    /* 指定分配的secondaryIp地址 (Optional) */
    SecondaryIps []string `json:"secondaryIps"`

    /* 指定自动分配的secondaryIp个数 (Optional) */
    SecondaryIpCount *int `json:"secondaryIpCount"`
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAssignSecondaryIpsRequest(
    regionId string,
    networkInterfaceId string,
) *AssignSecondaryIpsRequest {

	return &AssignSecondaryIpsRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:assignSecondaryIps",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param networkInterfaceId: networkInterface ID (Required)
 * param force: secondary ip被其他接口占用时，是否抢占。false：非抢占重分配，true：抢占重分配，默认抢占重分配。默认值：true (Optional)
 * param secondaryIps: 指定分配的secondaryIp地址 (Optional)
 * param secondaryIpCount: 指定自动分配的secondaryIp个数 (Optional)
 */
func NewAssignSecondaryIpsRequestWithAllParams(
    regionId string,
    networkInterfaceId string,
    force *bool,
    secondaryIps []string,
    secondaryIpCount *int,
) *AssignSecondaryIpsRequest {

    return &AssignSecondaryIpsRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:assignSecondaryIps",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        NetworkInterfaceId: networkInterfaceId,
        Force: force,
        SecondaryIps: secondaryIps,
        SecondaryIpCount: secondaryIpCount,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAssignSecondaryIpsRequestWithoutParam() *AssignSecondaryIpsRequest {

    return &AssignSecondaryIpsRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/networkInterfaces/{networkInterfaceId}:assignSecondaryIps",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *AssignSecondaryIpsRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param networkInterfaceId: networkInterface ID(Required) */
func (r *AssignSecondaryIpsRequest) SetNetworkInterfaceId(networkInterfaceId string) {
    r.NetworkInterfaceId = networkInterfaceId
}

/* param force: secondary ip被其他接口占用时，是否抢占。false：非抢占重分配，true：抢占重分配，默认抢占重分配。默认值：true(Optional) */
func (r *AssignSecondaryIpsRequest) SetForce(force bool) {
    r.Force = &force
}

/* param secondaryIps: 指定分配的secondaryIp地址(Optional) */
func (r *AssignSecondaryIpsRequest) SetSecondaryIps(secondaryIps []string) {
    r.SecondaryIps = secondaryIps
}

/* param secondaryIpCount: 指定自动分配的secondaryIp个数(Optional) */
func (r *AssignSecondaryIpsRequest) SetSecondaryIpCount(secondaryIpCount int) {
    r.SecondaryIpCount = &secondaryIpCount
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AssignSecondaryIpsRequest) GetRegionId() string {
    return r.RegionId
}

type AssignSecondaryIpsResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AssignSecondaryIpsResult `json:"result"`
}

type AssignSecondaryIpsResult struct {
}