/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef LANES_H
#define LANES_H

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluevector.h>

class Lanes {
public:
	Lanes() {};
	~Lanes() {};
	bool isEmpty() { return lanes.empty(); };
	void init(const QString& expectedSha);
	void clear();
	bool isFork(const QString& sha, bool& isDiscontinuity);
	void setBoundary(bool isBoundary);
	void setFork(const QString& sha);
	void setMerge(const QStringList& parents);
	void setInitial();
	void setApplied();
	void changeActiveLane(const QString& sha);
	void afterMerge();
	void afterFork();
	bool isBranch();
	void afterBranch();
	void afterApplied();
	void nextParent(const QString& sha);
	void getLanes(QValueVector<int> &ln);

private:
	int activeLane ;
	struct Lane {
		int type;
		QString next;
	};
	QValueVector<Lane> lanes;
	bool boundary;
	int NODE, NODE_L, NODE_R;

	int findNext(const QString& next, int pos);
	int findType(int type, int pos);
	int add(int type, const QString& next, int pos);
};

#endif
