

#include "myx_grt_public_interface.h"

#include "myx_grt_java.h"
#include "myx_grt_lua.h"




static MYX_GRT_VALUE *doTest(MYX_GRT_VALUE *value, void *ud)
{
  puts("Hello from C");
  return NULL;
}


MYX_GRT_BUILTIN_FUNCTION c_functions[]= {
{"doTest",  doTest}
};


MYX_GRT_BUILTIN_MODULE c_module= 
{
  "cTestModule",
  "testProtocol",
  1,
  c_functions
};




MYX_GRT *initialize_grt()
{
  MYX_GRT *grt= myx_grt_initialize();
  MYX_GRT_MODULE_LOADER *loader;
  MYX_GRT_ERROR error;

  myx_grt_register_builtin_module(grt, &c_module, NULL);

  // initialize the loaders
  g_message("Initializing Java loader...");
  loader= myx_java_init_loader(grt, "java:.", &error);
  if (!loader)
  {
    g_warning("Error initializing Java module loader (%i)", error);
  }
  else
  {
    if (myx_grt_register_module_loader(grt, loader) < 0)
    {
      g_warning("Could not register Java module loader.");
    }
  }

  g_message("Initializing Lua loader...");
  loader= myx_lua_init_loader(grt, &error);
  if (!loader)
  {
    g_warning("Error initializing Lua module loader (%i)", error);
  }
  else
  {
    if (myx_grt_register_module_loader(grt, loader) < 0)
    {
      g_warning("Could not register Java module loader.");
    }
  }

  return grt;
}


void show_module_summary(MYX_GRT *grt)
{
  unsigned int i, j, k;
  int count;

  printf("Module Summary--------------------------------------------------\n\n");

  count= myx_grt_get_protocols(grt, &protos);
  for (i= 0; i < count; i++)
  {
    MYX_GRT_MODULE **modules;
    int modcount;

    printf("Protocol '%s' is implemented by:\n", protos[i]->name);
    modcount= myx_grt_get_modules_for(grt, protos[i]->name, &modules);

    if (!modcount)
      continue;
    for (j= 0; j < modcount; j++)
    {
      printf("    Module: %s\n", modules[j]->name);
      for (k= 0; k < modules[j]->functions_num; k++)
      {
        MYX_GRT_FUNCTION_INTERFACE *fint;

        fint= myx_grt_lookup_function_interface(grt, modules[j]->protocol, modules[j]->functions[k].name);
        if (!fint)
          printf("        %s (interface not found)\n", modules[j]->functions[k].name);
        else
        {
          char *ret= "";
          char *arg= "";

          arg= fint->flags&MYX_GRT_FUNCTION_HAS_ARGUMENT ? "value" : "void";
          ret= fint->flags&MYX_GRT_FUNCTION_RETURNS_VALUE ? "value" : "void";

          printf("        %s %s(%s)\n", ret, modules[j]->functions[k].name, arg);
        }
      }
    }
  }
  
  printf("----------------------------------------------------------------\n");
}


void test_grt_value()
{
  MYX_GRT_VALUE *dict;
  
  dict= myx_grt_make_dict_value();

  myx_grt_set_dict_value_nocopy(dict, "name", myx_grt_make_value_from_string("Some Name"));
  myx_grt_set_dict_value_nocopy(dict, "length", myx_grt_make_value_from_int(12345));

  if (myx_grt_store_to_file(dict, "grt_value.xml") != MYX_GRT_NO_ERROR)
    g_message("Could not store GRT value to file.");
  
  dict= myx_grt_retrieve_from_file("grt_value.xml");
  if (!dict)
    g_message("Could not load GRT value from file.");
  else
    myx_grt_store_to_file(dict, "grt_value_copy.xml");
}


int main(int argc, char **argv)
{
  MYX_GRT *grt;
  MYX_GRT_VALUE *result= NULL;
  MYX_GRT_VALUE *argument= NULL;
  MYX_GRT_FUNCTION *func;
  MYX_GRT_ERROR error;
  int c;
  
  test_grt_value();

  grt= initialize_grt();

  g_message("Scanning for plugins...");
  c= myx_grt_scan_for_modules(grt, ".", &error);
  
  g_message("Initialized %i modules", c);
  
  show_module_summary(grt);

  argument= NULL;
  func= myx_grt_find_function(grt, "luaTestModule", "doTest");
  error= myx_grt_call_function(grt, func, argument, &result);
  if (error == MYX_GRT_NO_ERROR)
  {
    if (result)
      myx_grt_print_value(grt, result);
  }
  else
    g_message("ERROR %i calling function", error);
 
  argument= NULL;
  error= myx_grt_find_call_function(grt, "javaTestModule", "doTest", argument, &result);
  if (error == MYX_GRT_NO_ERROR)
  {
    if (result)
      myx_grt_print_value(grt, result);
  }
  else
    g_message("ERROR %i calling function", error);

  argument= NULL;
  error= myx_grt_find_call_function(grt, "cTestModule", "doTest", argument, &result);
  if (error == MYX_GRT_NO_ERROR)
  {
    if (result)
      myx_grt_print_value(grt, result);
  }
  else
    g_message("ERROR %i calling function", error);

 
  return 0;
}
