/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.NotSupportedException;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.Getval;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

class GetvalLob
extends Getval
implements Blob,
Clob {
    public GetvalLob(ConnectionSapDB connectionSapDB, byte[] byArray, StructuredMem structuredMem, int n) {
        super(connectionSapDB, byArray, structuredMem, n);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        --l;
        try {
            int n2;
            if (l < this.longPosition) {
                throw new NotSupportedException(MessageTranslator.translate("error.movebackwardinblob"));
            }
            InputStream inputStream = this.getBinaryStream();
            if (l > this.longPosition) {
                inputStream.skip(l - this.longPosition);
            }
            if ((n2 = inputStream.read(byArray = new byte[n], 0, n)) < n) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
            }
        }
        catch (StreamIOException streamIOException) {
            throw streamIOException.getSqlException();
        }
        catch (IOException iOException) {
            throw new JDBCDriverException(iOException.getMessage());
        }
        return byArray;
    }

    public String getSubString(long l, int n) throws SQLException {
        byte[] byArray = this.getBytes(l, n);
        return new String(byArray);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw new NotImplemented(MessageTranslator.translate("error.position.notimplemented"));
    }

    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l);
    }
}

