/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataBase;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.VersionInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class DatabaseMetaDataMaxDB
extends DatabaseMetaDataBase {
    private VersionInfo dbVersionInfo;
    private String dbVersion;
    private Hashtable systeminfo;

    DatabaseMetaDataMaxDB(ConnectionSapDB connectionSapDB, VersionInfo versionInfo) throws SQLException {
        super(connectionSapDB);
        this.dbVersionInfo = versionInfo;
        this.hasSchemaSupport = true;
        this.loadSystemInfo();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.dbVersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.dbVersionInfo.getMinorVersion();
    }

    public int getMaxConnections() throws SQLException {
        return this.getIntProperty("MAXCONNECTIONS");
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getIntProperty("MAXCURSORNAMELENGTH");
    }

    public int getMaxIndexLength() throws SQLException {
        return this.getIntProperty("MAXINDEXLENGTH");
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getIntProperty("MAXPROCEDURENAMELENGTH");
    }

    public int getMaxRowSize() throws SQLException {
        return this.getIntProperty("MAXROWSIZE");
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getIntProperty("MAXSCHEMANAMELENGTH");
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getIntProperty("MAXTABLENAMELENGTH");
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getIntProperty("MAXTABLESINSELECT");
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getIntProperty("MAXUSERNAMELENGTH");
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.dbVersion == null) {
            ResultSet resultSet = this.internalQuery("SELECT \"VALUE\" FROM SYSJDBC.SYSTEMINFO WHERE PROPERTY='KERNELVERSION'", "getDatabaseProductVersion");
            resultSet.next();
            this.dbVersion = resultSet.getString(1);
            resultSet.close();
        }
        return this.dbVersion;
    }

    public String getDriverName() throws SQLException {
        return DriverSapDB.singleton().getName();
    }

    public String getDriverVersion() throws SQLException {
        return DriverSapDB.singleton().getVersionString();
    }

    public ResultSet getCatalogs() throws SQLException {
        return this.internalQuery("SELECT TABLE_CAT FROM SYSJDBC.CATALOGS", "getCatalogs");
    }

    public ResultSet getSchemas() throws SQLException {
        return this.internalQuery("SELECT TABLE_SCHEM, TABLE_CATALOG FROM SYSJDBC.SCHEMAS ORDER BY TABLE_SCHEM", "getSchemas");
    }

    public ResultSet getTableTypes() throws SQLException {
        return this.internalQuery("SELECT TABLE_TYPE FROM SYSJDBC.TABLETYPES ORDER BY TABLE_TYPE", "getTableTypes");
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.internalQuery("SELECT TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE,CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE,AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE,SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX FROM SYSJDBC.SESSIONTYPEINFO ORDER BY DATA_TYPE, MATCHORDER", "getTypeInfo");
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYSJDBC.CROSSREFERENCES WHERE (1 = ? OR PKTABLE_SCHEM = ?)   AND PKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        if (string2 == null) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setNull(2, 1);
        } else {
            preparedStatement.setInt(1, 0);
            preparedStatement.setString(2, string2);
        }
        preparedStatement.setString(3, string3);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY, COMMENT FROM SYSJDBC.CROSSREFERENCES WHERE (1 = ? OR FKTABLE_SCHEM = ?)   AND FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        if (string2 == null) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setNull(2, 1);
        } else {
            preparedStatement.setInt(1, 0);
            preparedStatement.setString(2, string2);
        }
        preparedStatement.setString(3, string3);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, KEY_SEQ, PK_NAME FROM SYSJDBC.PRIMARYKEYS WHERE (1 = ? OR TABLE_SCHEM = ?)  AND TABLE_NAME = ?");
        if (string2 == null) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setNull(2, 1);
        } else {
            preparedStatement.setInt(1, 0);
            preparedStatement.setString(2, string2);
        }
        preparedStatement.setString(3, string3);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, RESERVED4, RESERVED5, RESERVED6, REMARKS, PROCEDURE_TYPE FROM SYSJDBC.PROCEDURES WHERE PROCEDURE_SCHEM LIKE ? ESCAPE '\\'  AND PROCEDURE_NAME LIKE ? ESCAPE '\\' ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return this.internalQuery("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, SUPERTABLE_NAME FROM SYSJDBC.SUPERTABLES", "getSuperTables");
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT, TYPE_SCHEM, TYPE_NAME,SUPERTYPE_CAT, SUPERTYPE_SCHEM, SUPERTYPE_NAME FROM SYSJDBC.SUPERTYPES", "getSuperTypes");
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.TABLEPRIVILEGES WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' AND TABLE_NAME LIKE ? ESCAPE '\\' ORDER BY TABLE_SCHEM, TABLE_NAME, PRIVILEGE");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.internalQuery("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.VERSIONCOLUMNS", "getVersionColumns");
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (string2 != null) {
            preparedStatement = this.connection.prepareStatement("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.BESTROWIDENTIFIER WHERE TABLE_SCHEM=? AND TABLE_NAME=? ORDER BY SCOPE, COLUMN_NAME");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
        } else {
            preparedStatement = this.connection.prepareStatement("SELECT SCOPE, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, PSEUDO_COLUMN FROM SYSJDBC.BESTROWIDENTIFIER WHERE TABLE_NAME=? ORDER BY SCOPE, COLUMN_NAME");
            preparedStatement.setString(1, string3);
        }
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    private String getIndexInfoTable(boolean bl, boolean bl2) {
        if (bl2) {
            return "SYSJDBC.APPROXINDEXINFO";
        }
        if (bl) {
            return "SYSJDBC.UNIQUEINDEXINFO";
        }
        return "SYSJDBC.INDEXINFO";
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, INDEX_QUALIFIER,  INDEX_NAME, TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC,  CARDINALITY, PAGES, FILTER_CONDITION, COMMENT FROM " + this.getIndexInfoTable(bl, bl2) + " WHERE ( 1 = ? OR TABLE_SCHEM = ?) " + "  AND TABLE_NAME = ? " + "  AND ( 1= ? OR NON_UNIQUE = ? ) " + "ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        if (string2 == null) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setNull(2, 1);
        } else {
            preparedStatement.setInt(1, 0);
            preparedStatement.setString(2, string2);
        }
        preparedStatement.setString(3, string3);
        if (bl) {
            preparedStatement.setInt(4, 0);
            preparedStatement.setBoolean(5, false);
        } else {
            preparedStatement.setInt(4, 1);
            preparedStatement.setBoolean(5, true);
        }
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS, BASE_TYPE FROM SYSJDBC.UDTS", "getUDTs");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return this.internalQuery("SELECT TYPE_CAT,                              TYPE_SCHEM,                             TYPE_NAME,                             ATTR_NAME,                             DATA_TYPE,                             ATTR_TYPE_NAME,                             ATTR_SIZE,                             DECIMAL_DIGITS,                             NUM_PREC_RADIX,                             NULLABLE,                             REMARKS,                             ATTR_DEF,                             SQL_DATA_TYPE,                             SQL_DATETIME_SUB,                             CHAR_OCTET_LENGTH,                             ORDINAL_POSITION,                             IS_NULLABLE,                             SCOPE_CATALOG,                             SCOPE_SCHEMA,                             SCOPE_TABLE,                             SOURCE_DATA_TYPE                              FROM SYSJDBC.ATTRIBUTES", "getAttributes");
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = null;
        if (string2 != null) {
            preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.COLUMNPRIVILEGES WHERE TABLE_SCHEM=? AND TABLE_NAME=? AND COLUMN_NAME LIKE ? ESCAPE '\\'");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            preparedStatement.setString(3, string4);
        } else {
            preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM SYSJDBC.COLUMNPRIVILEGES WHERE TABLE_NAME=? AND COLUMN_NAME LIKE ? ESCAPE '\\' ");
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string4);
        }
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE,REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SCOPE_CATLOG, SCOPE_SCHEMA, SCOPE_TABLE, SOURCE_DATA_TYPE, COLUMN_DEF_FUNC FROM SYSJDBC.COLUMNS WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' AND TABLE_NAME LIKE ? ESCAPE '\\' AND COLUMN_NAME LIKE ? ESCAPE '\\'ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        preparedStatement.setString(3, string4 == null ? "%" : string4);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT PROCEDURE_CAT, PROCEDURE_SCHEM, PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, LENGTH, SCALE, RADIX, NULLABLE, REMARKS FROM SYSJDBC.PROCEDURECOLUMNS WHERE (PROCEDURE_SCHEM LIKE ? ESCAPE '\\' )   AND (PROCEDURE_NAME LIKE ? ESCAPE '\\' )   AND (COLUMN_NAME LIKE ? ESCAPE '\\' ) ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, ORDINAL_POSITION");
        preparedStatement.setString(1, string2 == null ? "%" : string2);
        preparedStatement.setString(2, string3 == null ? "%" : string3);
        preparedStatement.setString(3, string4 == null ? "%" : string4);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        boolean bl = false;
        String string4 = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS, SAMPLE_PERCENT, SAMPLE_ROWS FROM SYSJDBC.TABLES";
        if (string2 != null) {
            string4 = string4 + " WHERE TABLE_SCHEM LIKE ? ESCAPE '\\' ";
            bl = true;
        }
        if (string3 != null) {
            if (bl) {
                string4 = string4 + " AND TABLE_NAME LIKE ? ESCAPE '\\' ";
            } else {
                string4 = string4 + " WHERE TABLE_NAME LIKE ? ESCAPE '\\'";
                bl = true;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            if (bl) {
                string4 = string4 + " AND (";
            } else {
                string4 = string4 + " WHERE (";
                bl = true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = i != 0 ? string4 + " OR TABLE_TYPE = ? " : string4 + " TABLE_TYPE = ? ";
            }
            string4 = string4 + " )";
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        int n = 1;
        if (string2 != null) {
            preparedStatement.setString(n, string2);
            ++n;
        }
        if (string3 != null) {
            preparedStatement.setString(n, string3);
            ++n;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                preparedStatement.setString(n, stringArray[i]);
                ++n;
            }
        }
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT PKTABLE_CAT,PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYSJDBC.CROSSREFERENCES WHERE (1 = ? OR PKTABLE_SCHEM = ?)   AND (1 = ? OR FKTABLE_SCHEM = ?)    AND PKTABLE_NAME = ? AND FKTABLE_NAME = ? ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        if (string2 == null) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setNull(2, 1);
        } else {
            preparedStatement.setInt(1, 0);
            preparedStatement.setString(2, string2);
        }
        if (string5 == null) {
            preparedStatement.setInt(3, 1);
            preparedStatement.setNull(4, 1);
        } else {
            preparedStatement.setInt(3, 0);
            preparedStatement.setString(4, string5);
        }
        preparedStatement.setString(5, string3);
        preparedStatement.setString(6, string6);
        return this.setFromMetaData(preparedStatement.executeQuery());
    }

    private ResultSet internalQuery(String string, String string2) throws SQLException {
        ResultSet resultSet;
        try {
            resultSet = this.connection.createStatement().executeQuery(string);
            try {
                ((ResultSetSapDB)resultSet).setFromMetaData(true);
            }
            catch (ClassCastException classCastException) {}
        }
        catch (DatabaseException databaseException) {
            throw new InternalJDBCError(string2, databaseException);
        }
        return resultSet;
    }

    private ResultSet setFromMetaData(ResultSet resultSet) {
        try {
            ((ResultSetSapDB)resultSet).setFromMetaData(true);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return resultSet;
    }

    private void loadSystemInfo() throws SQLException {
        this.systeminfo = new Hashtable();
        ResultSet resultSet = this.internalQuery("SELECT \"PROPERTY\", \"VALUE\" FROM SYSJDBC.SYSTEMINFO", "loadSystemInfo");
        while (resultSet.next()) {
            this.systeminfo.put(resultSet.getString(1), resultSet.getString(2));
        }
        resultSet.close();
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getIntProperty("MAXBINARYLITERALLENGTH");
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getIntProperty("MAXCATALOGNAMELENGTH");
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.getIntProperty("MAXCHARLITERALLENGTH");
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getIntProperty("MAXCOLUMNNAMELENGTH");
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINGROUPBY");
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSININDEX");
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINORDERBY");
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINSELECT");
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getIntProperty("MAXCOLUMNSINTABLE");
    }

    private int getIntProperty(String string) throws SQLException {
        try {
            return Integer.parseInt((String)this.systeminfo.get(string));
        }
        catch (Exception exception) {
            throw new InternalJDBCError(MessageTranslator.translate("error.nometadata", string, exception.getMessage()));
        }
    }

    public ResultSet getConstraints(String string, String string2, String string3) throws SQLException {
        boolean bl = false;
        String string4 = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, CONSTRAINT_NAME, CONSTRAINT_DEFINITION FROM SYSJDBC.CONSTRAINTS";
        if (string2 != null) {
            string4 = string4 + " WHERE TABLE_SCHEM LIKE ? ESCAPE '\\'";
            bl = true;
        }
        if (string3 != null) {
            if (bl) {
                string4 = string4 + " AND TABLE_NAME LIKE ? ESCAPE '\\'";
            } else {
                string4 = string4 + " WHERE TABLE_NAME LIKE ? ESCAPE '\\'";
                bl = true;
            }
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(string4);
        int n = 1;
        if (string2 != null) {
            preparedStatement.setString(n, string2);
            ++n;
        }
        if (string3 != null) {
            preparedStatement.setString(n, string3);
            ++n;
        }
        return this.setFromMetaData(preparedStatement.executeQuery());
    }
}

