
/******************************************************************************
 ******************************************************************************/

/** \file test.yada.c
 *  automatically generated from: test.yada
 */

/******************************************************************************
 * D E F I N E S **************************************************************
 ******************************************************************************/

#define __YADAC_TEST_LIBSRC_
#define YADAC_TEST_CHUNK_SZ 8

/******************************************************************************
 * I N C L U D E S ************************************************************
 ******************************************************************************/

#include <stdarg.h>

#include <stdlib.h>

#include <yada.h>

#include "test.yada.h"

/******************************************************************************
 * S Q L **********************************************************************
 ******************************************************************************/

#define SQL_CREATE_TABLE \
  "create table if not exists ?s ( "\
    "id int unsigned not null auto_increment, "\
    "name varchar(31) not null, "\
    "var1 int not null, "\
    "var2 int, "\
    "str1 varchar(15), "\
    "primary key (id), "\
    "unique key (name) "\
  ")"

#define SQL_DROP_TABLE \
  "drop table ttab"

#define SQL_ADDROW \
  "insert into ttab (name, var1, str1) "\
  "values ('?e', ?d, ?v)"

#define SQL_ADDROWSTRUCT \
  "insert into ttab (name, var1, str1) "\
  "values ('?e', ?d, ?v)"

#define SQL_GETID \
  "select id from ttab where name='?e'"

#define SQL_GETSTR \
  "select str1 from ttab where id=?d"

#define SQL_FINDROW \
  "select id, name, var1, var2, str1 "\
  "from ttab "\
  "where id=?d "\
    "and var1=?d"

#define SQL_FINDSTRUCT \
  "select id, name, var1, var2, str1 "\
  "from ttab "\
  "where id=?d "\
    "and var1=?d"

#define SQL_FINDMATCH \
  "select id, str1 "\
  "from ttab "\
  "where var1=?d"

#define SQL_MATCHSTRUCT \
  "select id, name, var1, var2, str1 "\
  "from ttab "\
  "where var1=?d"

/******************************************************************************
 * G L O B A L S **************************************************************
 ******************************************************************************/

/* saved database pointer */
static yadac_t *yadac;

/* test statements */
static yada_rc_t *stmt_create_table = NULL;
static yada_rc_t *stmt_drop_table = NULL;
static yada_rc_t *stmt_addrow = NULL;
static yada_rc_t *stmt_addrowstruct = NULL;
static yada_rc_t *stmt_getid = NULL;
static yada_rc_t *stmt_getstr = NULL;
static yada_rc_t *stmt_findrow = NULL;
static yada_rc_t *stmt_findstruct = NULL;
static yada_rc_t *stmt_findmatch = NULL;
static yada_rc_t *stmt_matchstruct = NULL;

/******************************************************************************
 * F U N C T I O N S **********************************************************
 ******************************************************************************/

/******************************************************************************/
/** prepare test statements
 * @param yc yadac_t to use
 * @param yada_t* db if yc is null, alloc new and use this db
 * @return yadac_t* on success, NULL on error
 */

yadac_t* test_init(yadac_t *yc, ...)
{
  int err = 0;
  va_list ap;
  yada_t *db;


  if(!yc)
    {
    if(!(yadac = calloc(1, sizeof(yadac_t))) || !(yadac->rc = malloc(YADAC_TEST_CHUNK_SZ * sizeof(yadac_t*))))
      {
      free(yadac);
      return(NULL);
      }
    va_start(ap, yc);
    yadac->db = va_arg(ap, yada_t*);
    va_end(ap);
    yadac->sz = YADAC_TEST_CHUNK_SZ;
    }
  else
    yadac = yc;

  db = yadac->db;

  /* prepare test statements */
  err |= !(stmt_create_table = db->yprepare(db, SQL_CREATE_TABLE, 0));
  err |= !(stmt_drop_table = db->prepare(db, SQL_DROP_TABLE, 0));
  err |= !(stmt_addrow = db->prepare(db, SQL_ADDROW, 0));
  err |= !(stmt_addrowstruct = db->prepare(db, SQL_ADDROWSTRUCT, 0));
  err |= !(stmt_getid = db->prepare(db, SQL_GETID, 0));
  err |= !(stmt_getstr = db->prepare(db, SQL_GETSTR, 0));
  err |= !(stmt_findrow = db->prepare(db, SQL_FINDROW, 0));
  err |= !(stmt_findstruct = db->prepare(db, SQL_FINDSTRUCT, 0));
  err |= !(stmt_findmatch = db->prepare(db, SQL_FINDMATCH, 0));
  err |= !(stmt_matchstruct = db->prepare(db, SQL_MATCHSTRUCT, 0));

  /* check for errors */
  if(err)
    {
    test_destroy(yadac);
    return(NULL);
    }

  return(yadac);
}

/******************************************************************************/
/** free test queries and bindsets
 */

void test_free(yadac_t *yc)
{
  if(!yc)
    yc = yadac;

  if(!yc->rcs)
    return;

  while(yc->rcs--)
    yc->db->free(yc->db, yc->rc[yc->rcs]);

  yc->rcs = 0;
}

/******************************************************************************/
/** destroy test statements
 */

void test_destroy(yadac_t *yc)
{
  yada_t *db;


  if(!yc)
    yc = yadac;
  db = yc->db;

  if(stmt_create_table)
    db->free(db, stmt_create_table);
  stmt_create_table = NULL;

  if(stmt_drop_table)
    db->free(db, stmt_drop_table);
  stmt_drop_table = NULL;

  if(stmt_addrow)
    db->free(db, stmt_addrow);
  stmt_addrow = NULL;

  if(stmt_addrowstruct)
    db->free(db, stmt_addrowstruct);
  stmt_addrowstruct = NULL;

  if(stmt_getid)
    db->free(db, stmt_getid);
  stmt_getid = NULL;

  if(stmt_getstr)
    db->free(db, stmt_getstr);
  stmt_getstr = NULL;

  if(stmt_findrow)
    db->free(db, stmt_findrow);
  stmt_findrow = NULL;

  if(stmt_findstruct)
    db->free(db, stmt_findstruct);
  stmt_findstruct = NULL;

  if(stmt_findmatch)
    db->free(db, stmt_findmatch);
  stmt_findmatch = NULL;

  if(stmt_matchstruct)
    db->free(db, stmt_matchstruct);
  stmt_matchstruct = NULL;

  test_free(yc);
  free(yc->rc);
  free(yc);
  if(yc == yadac)
    yadac = NULL;
}

/******************************************************************************/
/** push rcs onto yadac
 * @return 0 on success, -1 on error
 */

inline static int _yadac_push(yadac_t *yc, yada_rc_t *query, yada_rc_t *bs)
{
  yada_rc_t **tmp;


  if(yc->rcs + 1 >= yc->sz)
    {
    if(!(tmp = realloc(yc->rc, sizeof(yada_rc_t*) * (yc->sz + YADAC_TEST_CHUNK_SZ))))
      return(-1);
    yc->rc = tmp;
    yc->sz += YADAC_TEST_CHUNK_SZ;
    }

  yc->rc[yc->rcs++] = query;
  yc->rc[yc->rcs++] = bs;
  return(0);
}

/******************************************************************************/
/** create_table (STATUS operation)
 * @return num rows affected on success, -1 on error
 */

int test_create_table(yadac_t *yc, char *in1)
{
  yada_t *db;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* execute statement */
  return(db->execute(db, stmt_create_table, in1));
}

/******************************************************************************/
/** drop_table (STATUS operation)
 * @return num rows affected on success, -1 on error
 */

int test_drop_table(yadac_t *yc)
{
  yada_t *db;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* execute statement */
  return(db->execute(db, stmt_drop_table));
}

/******************************************************************************/
/** addrow (STATUS operation)
 * @return num rows affected on success, -1 on error
 */

int test_addrow(yadac_t *yc, char *in1, int in2, char *in3)
{
  yada_t *db;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* execute statement */
  return(db->execute(db, stmt_addrow, in1, in2, in3));
}

/******************************************************************************/
/** addrowstruct (STATUS operation)
 * @return num rows affected on success, -1 on error
 */

int test_addrowstruct(yadac_t *yc, testruct_t *in)
{
  yada_t *db;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* execute statement */
  return(db->execute(db, stmt_addrowstruct, in->name, in->var1, in->str1));
}

/******************************************************************************/
/** getid (SIMPLE operation)
 * @param errval value to return on error
 * @return value on success, errval on error
 */

int test_getid(yadac_t *yc, int errval, char *in1)
{
  int out;
  int rval;
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?d", &out)))
    return(errval);

  /* perform query */
  if(!(query = db->query(db, stmt_getid, in1)))
    {
    db->free(db, bs);
    return(errval);
    }

  /* fetch result */
  rval = db->fetch(db, query, bs);
  if(!rval || db->error || _yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(errval);
    }

  return(out);
}

/******************************************************************************/
/** getstr (SIMPLE operation)
 * @param errval value to return on error
 * @return value on success, errval on error
 */

char* test_getstr(yadac_t *yc, char *errval, int in1)
{
  char *out;
  int rval;
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?ps", &out)))
    return(errval);

  /* perform query */
  if(!(query = db->query(db, stmt_getstr, in1)))
    {
    db->free(db, bs);
    return(errval);
    }

  /* fetch result */
  rval = db->fetch(db, query, bs);
  if(!rval || db->error || _yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(errval);
    }

  return(out);
}

/******************************************************************************/
/** findrow (SINGLE operation)
 * @return 0 on success, -1 on error
 */

int test_findrow(yadac_t *yc, int in1, int in2, int *out1, char *out2, int *out3, int **out4, char **out5)
{
  int rval;
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?d?s?d?pd?ps", out1, out2, out3, out4, out5)))
    return(-1);

  /* perform query */
  if(!(query = db->query(db, stmt_findrow, in1, in2)))
    {
    db->free(db, bs);
    return(-1);
    }

  /* fetch result */
  rval = db->fetch(db, query, bs);
  if(!rval || db->error || _yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(db->error ? -1 : 1);
    }

  return(0);
}

/******************************************************************************/
/** findstruct (testruct_t STRUCT operation)
 * @return 0 on success, -1 on error, 1 no results
 */

int test_findstruct(yadac_t *yc, int in1, int in2, testruct_t *out)
{
  int rval;
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?d?s?d?pd?ps", &out->id, out->name, &out->var1, &out->var2, &out->str1)))
    return(-1);

  /* perform query */
  if(!(query = db->query(db, stmt_findstruct, in1, in2)))
    {
    db->free(db, bs);
    return(-1);
    }

  /* fetch result */
  rval = db->fetch(db, query, bs);
  if(!rval || db->error || _yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(db->error ? -1 : 1);
    }

  return(0);
}

/******************************************************************************/
/** findmatch (MULTIROW operation)
 * @return 0 on success, -1 on error
 */

int test_findmatch(yadac_t *yc, int in1, int *out1, char **out2)
{
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?d?ps", out1, out2)))
    return(-1);

  /* perform query */
  if(!(query = db->query(db, stmt_findmatch, in1)))
    {
    db->free(db, bs);
    return(-1);
    }

  if(_yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(-1);
    }

  return(0);
}

/******************************************************************************/
/** findmatch (MULTIROW operation) fetch routine
 * @return 0 on completion, 1 if incomplete, -1 on error
 */

int test_findmatch_fetch(yadac_t *yc)
{
  if(!yc)
    yc = yadac;

  /* fetch result */
  if(yc->db->fetch(yc->db, yc->rc[yc->rcs - 2], yc->rc[yc->rcs - 1]))
    return(1);

  /* check for errors */
  return(yc->db->error ? -1 : 0);
}

/******************************************************************************/
/** matchstruct (testruct_t MULTISTRUCT operation)
 * @return 0 on success, -1 on error, 1 no results
 */

int test_matchstruct(yadac_t *yc, int in1, testruct_t *out)
{
  yada_t *db;
  yada_rc_t *bs, *query;


  if(!yc)
    yc = yadac;
  db = yc->db;

  /* bind output variables */
  if(!(bs = db->bind(db, "?d?s?d?pd?ps", &out->id, out->name, &out->var1, &out->var2, &out->str1)))
    return(-1);

  /* perform query */
  if(!(query = db->query(db, stmt_matchstruct, in1)))
    {
    db->free(db, bs);
    return(-1);
    }

  if(_yadac_push(yc, query, bs))
    {
    db->free(db, query);
    db->free(db, bs);
    return(-1);
    }

  return(0);
}

/******************************************************************************/
/** matchstruct (MULTISTRUCT operation) fetch routine
 * @return 0 on completion, 1 if incomplete, -1 on error
 */

int test_matchstruct_fetch(yadac_t *yc)
{
  if(!yc)
    yc = yadac;

  /* fetch result */
  if(yc->db->fetch(yc->db, yc->rc[yc->rcs - 2], yc->rc[yc->rcs - 1]))
    return(1);

  /* check for errors */
  return(yc->db->error ? -1 : 0);
}

/******************************************************************************
 ******************************************************************************/

