/**
 * ===========================================
 * LibLayout : a free Java layouting library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/liblayout/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: LibLayoutInfo.java 6653 2008-12-02 14:53:40Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

package org.jfree.layouting;

import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;
import org.pentaho.reporting.libraries.fonts.LibFontInfo;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderInfo;
import org.pentaho.reporting.libraries.repository.LibRepositoryInfo;

public class LibLayoutInfo extends ProjectInformation
{

  private static LibLayoutInfo instance;

  public static ProjectInformation getInstance()
  {
    if (instance == null)
    {
      instance = new LibLayoutInfo();
      instance.initialize();
    }
    return instance;
  }

  /**
   * Constructs an empty project info object.
   */
  public LibLayoutInfo()
  {
    super("liblayout", "LibLayout");
  }

  private void initialize()
  {
    setVersion("0.2.9");
    setInfo("http://reporting.pentaho.org/liblayout/");
    setCopyright("(C)opyright 2006,2007, by Pentaho Corporation and Contributors");
    
    addLibrary(LibLoaderInfo.getInstance());
    addLibrary(LibRepositoryInfo.getInstance());
    addLibrary(LibFontInfo.getInstance());

    setBootClass(LibLayoutBoot.class.getName());
  }

}
