/* gsd-utils.c generated by valac 0.12.0, the Vala compiler
 * generated from gsd-utils.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <sys/select.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
   * Error domain for the FD namespace functions. It is mainly a wrapper around
   * some errnos to have exceptions for them.
   */
typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()


GQuark gsd_fd_error_quark (void);
gboolean gsd_fd_read_ready (gint fd, GError** error);
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error);
guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error);


GQuark gsd_fd_error_quark (void) {
	return g_quark_from_static_string ("gsd_fd_error-quark");
}


/**
     * Gets whether a file descriptor is ready to be read or not.
     * 
     * Being ready means that reading data from it would not be blocking, as
     * there is data to be read.
     * 
     * @param fd a file descriptor
     * 
     * @return %TRUE if the file is read, %FALSE otherwise.
     */
gboolean gsd_fd_read_ready (gint fd, GError** error) {
	gboolean result = FALSE;
	gboolean ready;
	GError * _inner_error_ = NULL;
	ready = FALSE;
	if (fd > 0) {
		fd_set _tmp0_ = {0};
		fd_set rfds;
		struct timeval _tmp1_ = {0};
		struct timeval tv;
		gint _tmp2_;
		gint rv;
		rfds = _tmp0_;
		_tmp1_.tv_sec = (time_t) 0;
		_tmp1_.tv_usec = (glong) 0;
		tv = _tmp1_;
		FD_ZERO (&rfds);
		FD_SET (fd, &rfds);
		_tmp2_ = select (fd + 1, &rfds, NULL, NULL, &tv);
		rv = _tmp2_;
		if (rv == (-1)) {
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
			_tmp3_ = g_strerror (errno);
			_tmp4_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_SELECT_ERROR, "select(): %s", _tmp3_);
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		} else {
			if (rv > 0) {
				ready = TRUE;
			}
		}
	}
	result = ready;
	return result;
}


/**
     * Reads content of a file as a string.
     * 
     * This function may only work with text data.
     * 
     * @param fd a file descriptor
     * @param n_bytes number of bytes to read from @fd, or -1 to read all @fd
     * 
     * @return a newly allocated string containing data in @fd.
     */
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error) {
	gchar* result = NULL;
	gchar* buf;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	buf = NULL;
	if (n_bytes > 0) {
		gssize n_read = 0L;
		gchar* _tmp0_ = NULL;
		gssize _tmp1_;
		_tmp0_ = g_new0 (gchar, n_bytes + 1);
		buf = _tmp0_;
		_tmp1_ = read (fd, buf, (gsize) n_bytes);
		n_read = _tmp1_;
		if (n_read < 0) {
			gint errn;
			const gchar* _tmp2_ = NULL;
			GError* _tmp3_ = NULL;
			errn = errno;
			g_free (buf);
			buf = NULL;
			_tmp2_ = g_strerror (errn);
			_tmp3_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp2_);
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			buf[n_read] = (gchar) 0;
		}
	} else {
		gsize packet_size;
		gsize n_read;
		gssize read_rv;
		packet_size = (gsize) 64;
		n_read = (gsize) 0;
		read_rv = (gssize) 0;
		n_bytes = (gssize) 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				void* _tmp7_ = NULL;
				gssize _tmp8_;
				if (!_tmp4_) {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					if (n_bytes > 0) {
						_tmp6_ = read_rv >= 0;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						_tmp5_ = read_rv == packet_size;
					} else {
						_tmp5_ = FALSE;
					}
					if (!_tmp5_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp7_ = g_realloc (buf, (n_bytes + packet_size) + 1);
				buf = _tmp7_;
				_tmp8_ = read (fd, &buf[n_bytes], packet_size);
				read_rv = _tmp8_;
				if (read_rv >= 0) {
					n_read = n_read + ((gsize) read_rv);
				}
				n_bytes = n_bytes + ((gssize) packet_size);
			}
		}
		if (read_rv < 0) {
			gint errn;
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			errn = errno;
			g_free (buf);
			buf = NULL;
			_tmp9_ = g_strerror (errn);
			_tmp10_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp9_);
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			buf[n_read] = (gchar) 0;
		}
	}
	_tmp11_ = buf;
	buf = NULL;
	result = (gchar*) _tmp11_;
	return result;
}


/**
     * Counts the number of occurrence of a given byte in a file descriptor.
     * 
     * This function is non-blocking and returns 0 if there is no data in the
     * buffer rather than blocking waiting for data.
     * 
     * @param fd a valid file descriptor
     * @param byte the byte to cont in @fd
     * @param bufsize the size of the buffer used to cache the file's content.
     *    Tweaking it may improve the performances with different amount of data
     *    in @fd: the better value is the closer to the total number of bytes
     *    that will be read (the size of the file's content) or a multiple of it
     *    if it is a too big value to be reasonably allocated at once.
     * 
     * @return the number of occurrences of @byte in @fd.
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error) {
	guint result = 0U;
	guint n_occur;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	n_occur = (guint) 0;
	_tmp0_ = gsd_fd_read_ready (fd, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			goto __catch11_gsd_fd_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* buf;
		gint buf_length1;
		gint _buf_size_;
		gssize read_rv;
		_tmp2_ = g_new0 (gchar, bufsize);
		buf = _tmp2_;
		buf_length1 = bufsize;
		_buf_size_ = bufsize;
		read_rv = (gssize) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gssize _tmp4_;
				if (!_tmp3_) {
					if (!(read_rv == bufsize)) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp4_ = read (fd, buf, bufsize);
				read_rv = _tmp4_;
				if (read_rv < 0) {
					const gchar* _tmp5_ = NULL;
					GError* _tmp6_ = NULL;
					_tmp5_ = g_strerror (errno);
					_tmp6_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp5_);
					_inner_error_ = _tmp6_;
					buf = (g_free (buf), NULL);
					if (_inner_error_->domain == GSD_FD_ERROR) {
						goto __catch11_gsd_fd_error;
					}
					buf = (g_free (buf), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				} else {
					{
						guint i;
						i = (guint) 0;
						{
							gboolean _tmp7_;
							_tmp7_ = TRUE;
							while (TRUE) {
								if (!_tmp7_) {
									i++;
								}
								_tmp7_ = FALSE;
								if (!(i < read_rv)) {
									break;
								}
								if (buf[i] == byte) {
									n_occur++;
								}
							}
						}
					}
				}
			}
		}
		buf = (g_free (buf), NULL);
	}
	goto __finally11;
	__catch11_gsd_fd_error:
	{
		GError * e;
		GError* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _g_error_copy0 (e);
		_inner_error_ = _tmp8_;
		_g_error_free0 (e);
		goto __finally11;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = n_occur;
	return result;
}



