/***************************************************************************
 $RCSfile$
 -------------------
 begin       : Mon Jan 07 2008
 copyright   : (C) 2008 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "g_ofx_p.h"
#include "ofxxmlctx_l.h"

#include "g_generic_l.h"
#include "g_ignore_l.h"
#include "g_signonmsgsrsv1_l.h"
#include "g_bankmsgsrsv1_l.h"
#include "g_creditcardmsgsrsv1_l.h"
#include "g_signupmsgsrsv1_l.h"
#include "g_invstmtmsgsrsv1_l.h"
#include "g_seclistmsgsrsv1_l.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>




AIO_OFX_GROUP *AIO_OfxGroup_OFX_new(const char *groupName,
				    AIO_OFX_GROUP *parent,
				    GWEN_XML_CONTEXT *ctx) {
  AIO_OFX_GROUP *g;

  /* create base group */
  g=AIO_OfxGroup_Generic_new(groupName, parent, ctx);
  assert(g);

  /* set virtual functions */
  AIO_OfxGroup_SetStartTagFn(g, AIO_OfxGroup_OFX_StartTag);

  return g;
}



int AIO_OfxGroup_OFX_StartTag(AIO_OFX_GROUP *g, const char *tagName) {
  AIO_OFX_GROUP *gNew=NULL;
  GWEN_XML_CONTEXT *ctx;

  assert(g);

  ctx=AIO_OfxGroup_GetXmlContext(g);

  if (strcasecmp(tagName, "SIGNONMSGSRSV1")==0)
    gNew=AIO_OfxGroup_SIGNONMSGSRSV1_new(tagName, g, ctx);
  else if (strcasecmp(tagName, "BANKMSGSRSV1")==0) {
    gNew=AIO_OfxGroup_BANKMSGSRSV1_new(tagName, g, ctx);
  }
  else if (strcasecmp(tagName, "CREDITCARDMSGSRSV1")==0) {
    gNew=AIO_OfxGroup_CREDITCARDMSGSRSV1_new(tagName, g, ctx);
  }
  else if (strcasecmp(tagName, "SIGNUPMSGSRSV1")==0)
    gNew=AIO_OfxGroup_SIGNUPMSGSRSV1_new(tagName, g, ctx);
  else if (strcasecmp(tagName, "INVSTMTMSGSRSV1")==0)
    gNew=AIO_OfxGroup_INVSTMTMSGSRSV1_new(tagName, g, ctx);
  else if (strcasecmp(tagName, "SECLISTMSGSRSV1")==0)
    gNew=AIO_OfxGroup_SECLISTMSGSRSV1_new(tagName, g, ctx);
  else {
    DBG_WARN(AQBANKING_LOGDOMAIN,
	     "Ignoring group [%s]", tagName);
    gNew=AIO_OfxGroup_Ignore_new(tagName, g, ctx);
  }

  if (gNew) {
    AIO_OfxXmlCtx_SetCurrentGroup(ctx, gNew);
    GWEN_XmlCtx_IncDepth(ctx);
  }

  return 0;
}



