/************************************************************************/
/*                                                                      */
/*               Copyright 1998-2002 by Ullrich Koethe                  */
/*       Cognitive Systems Group, University of Hamburg, Germany        */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    ( Version 1.4.0, Dec 21 2005 )                                    */
/*    The VIGRA Website is                                              */
/*        http://kogs-www.informatik.uni-hamburg.de/~koethe/vigra/      */
/*    Please direct questions, bug reports, and contributions to        */
/*        koethe@informatik.uni-hamburg.de          or                  */
/*        vigra@kogs1.informatik.uni-hamburg.de                         */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */                
/*                                                                      */
/************************************************************************/
 
 
#ifndef VIGRA_CONFIG_HXX 
#define VIGRA_CONFIG_HXX

#include <stdexcept>

///////////////////////////////////////////////////////////
//                                                       //
//                   VisualC++ 5.0                       //
//                                                       //
///////////////////////////////////////////////////////////

#ifdef _MSC_VER
    #if(_MSC_VER < 1100)    // before VisualC++ 5.0
        #error "Need VisualC++ 5.0, Service Pack 2, or later"
    #endif // _MSC_VER < 1100

	#pragma warning( disable : 4786 4250 4244 4305)

	#if (_MSC_VER < 1300)
		#define NO_TYPENAME         // no 'typename' keyword
		#define TEMPLATE_COPY_CONSTRUCTOR_BUG
		#define NO_STL_MEMBER_TEMPLATES
		#define NO_INLINE_STATIC_CONST_DEFINITION
		#define CMATH_NOT_IN_STD
		#define NO_COVARIANT_RETURN_TYPES
	    
		#ifdef VIGRA_NO_STD_MINMAX  // activate if necessary
		namespace std {
	    
		template<class T>
		const T& min(const T& x, const T& y)
		{
			return (y < x) 
				? y
				: x;
		}

		template<class T>
		const T& max(const T& x, const T& y)
		{
			return (x < y) 
				? y
				: x;
		}
		}
		#endif // VIGRA_NO_STD_MINMAX
	#endif // (_MSC_VER < 1300)

    #if _MSC_VER < 1310
        #define NO_PARTIAL_TEMPLATE_SPECIALIZATION
        #define NO_OUT_OF_LINE_MEMBER_TEMPLATES
        #include <cmath>

        #ifdef _MSC_EXTENSIONS
	    #ifndef CMATH_NOT_IN_STD
                namespace std {
	    #endif // CMATH_NOT_IN_STD
                inline double abs(double v) { return fabs(v); }
                inline float  abs(float v)  { return fabs(v); }
	    #ifndef CMATH_NOT_IN_STD
                }
	    #endif // CMATH_NOT_IN_STD
        #endif // _MSC_EXTENSIONS
    #endif // _MSC_VER < 1310

    #define VIGRA_NEED_BIN_STREAMS
#endif // _MSC_VER

///////////////////////////////////////////////////////////
//                                                       //
//                           gcc                         //
//                                                       //
///////////////////////////////////////////////////////////

#if defined(__GNUC__) 
    #if  __GNUC__ < 2 || ((__GNUC__ == 2) && (__GNUC_MINOR__ <= 8))
        #error "Need at least g++ 2.95"
    #endif 
    #define HAS_HASH_CONTAINERS
#endif  // __GNUC__

///////////////////////////////////////////////////////////
//                                                       //
//                         MingW                         //
//                                                       //
///////////////////////////////////////////////////////////

#if defined(__MINGW32__)
    #define VIGRA_NEED_BIN_STREAMS
#endif  // __MINGW32__

///////////////////////////////////////////////////////////
//                                                       //
//                      SGI C++ 7.2                      //
//                                                       //
///////////////////////////////////////////////////////////

#if defined(__sgi) && !defined(__GNUC__) 
    #if _COMPILER_VERSION < 720
        #error "Need SGI C++ 7.2 or later"
    #endif
    #if (_COMPILER_VERSION  == 720) || (_COMPILER_VERSION  == 721)
        #define SPECIAL_STDEXCEPTION_DEFINITION_NEEDED

        namespace vigra {
            typedef std::exception StdException; // must be above next #define !!
        }
        #define std
        #define NO_NAMESPACE_STD
    #endif // _COMPILER_VERSION
    #define HAS_HASH_CONTAINERS
#endif // __sgi

///////////////////////////////////////////////////////////
//                                                       //
//                        general                        //
//                                                       //
///////////////////////////////////////////////////////////

#ifdef CMATH_NOT_IN_STD
    #define VIGRA_CSTD
#else
    #define VIGRA_CSTD std
#endif

#ifdef NO_TYPENAME
    #define typename
#endif

#ifdef NO_EXPLICIT
    #define explicit
#endif

namespace vigra {

#ifndef SPECIAL_STDEXCEPTION_DEFINITION_NEEDED
     typedef std::exception StdException;
#endif

} // namespace vigra

#endif // VIGRA_CONFIG_HXX
