/* Generated by re2c 0.9.7.dev on Thu May 12 09:38:39 2005 */
#line 1 "cpp.re"
/*=============================================================================
    Boost.Wave: A Standard compliant C++ preprocessor library

    Copyright (c) 2001 Daniel C. Nuffer
    Copyright (c) 2001-2005 Hartmut Kaiser. 
    Distributed under the Boost Software License, Version 1.0. (See accompanying 
    file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

    TODO: 
        It also may be necessary to add $ to identifiers, for asm. 
        handle errors better.
        have some easier way to parse strings instead of files (done) 
=============================================================================*/

#include <ctime>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <boost/config.hpp>

#if defined(BOOST_HAS_UNISTD_H)
#include <unistd.h>
#else
#include <io.h>
#endif 

#include <boost/assert.hpp>
#include <boost/detail/workaround.hpp>

#include <boost/wave/token_ids.hpp>
#include <boost/wave/cpplexer/re2clex/aq.hpp>
#include <boost/wave/cpplexer/re2clex/scanner.hpp>
#include <boost/wave/cpplexer/re2clex/cpp_re.hpp>

///////////////////////////////////////////////////////////////////////////////
#if defined(BOOST_MSVC)
#pragma warning (disable: 4101)     // 'foo' : unreferenced local variable
#pragma warning (disable: 4102)     // 'foo' : unreferenced label
#endif

///////////////////////////////////////////////////////////////////////////////
#define BSIZE     196608

#define YYCTYPE   uchar
#define YYCURSOR  cursor
#define YYLIMIT   limit
#define YYMARKER  marker
#define YYFILL(n) {cursor = uchar_wrapper(fill(s, cursor), cursor.column);}

//#define RET(i)    {s->cur = cursor; return (i);}
#define RET(i)                                                                \
    {                                                                         \
        s->line += count_backslash_newlines(s, cursor);                       \
        s->curr_column = cursor.column;                                       \
        s->cur = cursor;                                                      \
        s->lim = limit;                                                       \
        s->ptr = marker;                                                      \
        return (i);                                                           \
    }                                                                         \
    /**/

///////////////////////////////////////////////////////////////////////////////
namespace boost {
namespace wave {
namespace cpplexer {
namespace re2clex {

#define RE2C_ASSERT BOOST_ASSERT

int get_one_char(Scanner *s)
{
    if (s->fd != -1) {
    uchar val;
    
        if (read(s->fd, &val, sizeof(val)))
            return val;
    }
    else if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        if (s->act < s->last) 
            return *(s->act)++;
    }
    return -1;
}

std::ptrdiff_t rewind_stream (Scanner *s, int cnt)
{
    if (s->fd != -1) {
        return lseek(s->fd, cnt, SEEK_CUR);
    }
    else if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        s->act += cnt;
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        return s->act - s->first;
    }
    return 0;
}

std::size_t get_first_eol_offset(Scanner* s)
{
    if (!AQ_EMPTY(s->eol_offsets))
    {
        return s->eol_offsets->queue[s->eol_offsets->head];
    }
    else
    {
        return (unsigned int)-1;
    }
}

void adjust_eol_offsets(Scanner* s, std::size_t adjustment)
{
    aq_queue q;
    std::size_t i;
    
    if (!s->eol_offsets)
        s->eol_offsets = aq_create();

    q = s->eol_offsets;

    if (AQ_EMPTY(q))
        return;

    i = q->head;
    while (i != q->tail)
    {
        if (adjustment > q->queue[i])
            q->queue[i] = 0;
        else
            q->queue[i] -= adjustment;
        ++i;
        if (i == q->max_size)
            i = 0;
    }
    if (adjustment > q->queue[i])
        q->queue[i] = 0;
    else
        q->queue[i] -= adjustment;
}

int count_backslash_newlines(Scanner *s, uchar *cursor)
{
    std::size_t diff, offset;
    int skipped = 0;
    
    /* figure out how many backslash-newlines skipped over unknowingly. */
    diff = cursor - s->bot;
    offset = get_first_eol_offset(s);
    while (offset <= diff && offset != (unsigned int)-1)
    {
        skipped++;
        aq_pop(s->eol_offsets);
        offset = get_first_eol_offset(s);
    }
    return skipped;
}

bool is_backslash(uchar *p, uchar *end, int &len)
{
    if (*p == '\\') {
        len = 1;
        return true;
    }
    else if (*p == '?' && *(p+1) == '?' && (p+2 < end && *(p+2) == '/')) {
        len = 3;
        return true;
    }
    return false;
}

uchar *fill(Scanner *s, uchar *cursor)
{
    using namespace std;    // some systems have memcpy etc. in namespace std
    if(!s->eof)
    {
        uchar* p;
        std::ptrdiff_t cnt = s->tok - s->bot;
        if(cnt)
        {
            memcpy(s->bot, s->tok, s->lim - s->tok);
            s->tok = s->bot;
            s->ptr -= cnt;
            cursor -= cnt;
            s->lim -= cnt;
            adjust_eol_offsets(s, cnt);
        }

        if((s->top - s->lim) < BSIZE)
        {
            uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
            if (buf == 0)
            {
                using namespace std;      // some systems have printf in std
                if (0 != s->error_proc)
                    (*s->error_proc)(s, "Out of memory!");
                else 
                    printf("Out of memory!\n");
                    
                /* get the scanner to stop */
                *cursor = 0;
                return cursor;
            }

            memcpy(buf, s->tok, s->lim - s->tok);
            s->tok = buf;
            s->ptr = &buf[s->ptr - s->bot];
            cursor = &buf[cursor - s->bot];
            s->lim = &buf[s->lim - s->bot];
            s->top = &s->lim[BSIZE];
            free(s->bot);
            s->bot = buf;
        }

        if (s->fd != -1) {
            if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE)
            {
                s->eof = &s->lim[cnt]; *(s->eof)++ = '\0';
            }
        }
        else if (s->act != 0) {
            cnt = s->last - s->act;
            if (cnt > BSIZE)
                cnt = BSIZE;
            memcpy(s->lim, s->act, cnt);
            s->act += cnt;
            if (cnt != BSIZE) 
            {
                s->eof = &s->lim[cnt]; *(s->eof)++ = '\0';
            }
        }
        
        /* backslash-newline erasing time */

        /* first scan for backslash-newline and erase them */
        for (p = s->lim; p < s->lim + cnt - 2; ++p)
        {
            int len = 0;
            if (is_backslash(p, s->lim + cnt, len))
            {
                if (*(p+len) == '\n')
                {
                    int offset = len + 1;
                    memmove(p, p + offset, s->lim + cnt - p - offset);
                    cnt -= offset;
                    --p;
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
                else if (*(p+len) == '\r')
                {
                    if (*(p+len+1) == '\n')
                    {
                        int offset = len + 2;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    else
                    {
                        int offset = len + 1;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
            }
        }

        /* FIXME: the following code should be fixed to recognize correctly the 
                  trigraph backslash token */
                  
        /* check to see if what we just read ends in a backslash */
        if (cnt >= 2)
        {
            uchar last = s->lim[cnt-1];
            uchar last2 = s->lim[cnt-2];
            /* check \ EOB */
            if (last == '\\')
            {
                int next = get_one_char(s);
                /* check for \ \n or \ \r or \ \r \n straddling the border */
                if (next == '\n')
                {
                    --cnt; /* chop the final \, we've already read the \n. */
                    aq_enqueue(s->eol_offsets, cnt + (s->lim - s->bot));    
                }
                else if (next == '\r')
                {
                    int next2 = get_one_char(s);
                    if (next2 == '\n')
                    {
                        --cnt; /* skip the backslash */
                    }
                    else
                    {
                        /* rewind one, and skip one char */
                        rewind_stream(s, -1);
                        --cnt;
                    }
                    aq_enqueue(s->eol_offsets, cnt + (s->lim - s->bot));    
                }
                else if (next != -1) /* -1 means end of file */
                {
                    /* next was something else, so rewind the stream */
                    rewind_stream(s, -1);
                }
            }
            /* check \ \r EOB */
            else if (last == '\r' && last2 == '\\')
            {
                int next = get_one_char(s);
                if (next == '\n')
                {
                    cnt -= 2; /* skip the \ \r */
                }
                else
                {
                    /* rewind one, and skip two chars */
                    rewind_stream(s, -1);
                    cnt -= 2;
                }
                aq_enqueue(s->eol_offsets, cnt + (s->lim - s->bot));    
            }
            /* check \ \n EOB */
            else if (last == '\n' && last2 == '\\')
            {
                cnt -= 2;
                aq_enqueue(s->eol_offsets, cnt + (s->lim - s->bot));    
            }
        }
        
        s->lim += cnt;
        if (s->eof) /* eof needs adjusting if we erased backslash-newlines */
        {
            s->eof = s->lim;
            *(s->eof)++ = '\0';
        }
    }
    return cursor;
}

///////////////////////////////////////////////////////////////////////////////
//  Special wrapper class holding the current cursor position 
struct uchar_wrapper
{
    uchar_wrapper (uchar *base_cursor, unsigned int column = 1)
    :   base_cursor(base_cursor), column(column)
    {}
    
    uchar_wrapper& operator++() 
    {
        ++base_cursor;
        ++column;
        return *this;
    }
    
    uchar_wrapper& operator--() 
    {
        --base_cursor;
        --column;
        return *this;
    }
    
    uchar operator* () const
    {
        return *base_cursor;
    }
    
    operator uchar *() const
    {
        return base_cursor;
    }
    
    uchar *base_cursor;
    unsigned int column;
};

///////////////////////////////////////////////////////////////////////////////
boost::wave::token_id scan(Scanner *s)
{
    uchar_wrapper cursor (s->tok = s->cur, s->column = s->curr_column);
    uchar_wrapper marker (s->ptr);
    uchar_wrapper limit (s->lim);
        
#line 409 "cpp.re"



#line 398 "cpp_re.cpp"
{
  YYCTYPE yych;
  unsigned int yyaccept;
  goto yy0;
  ++YYCURSOR;
yy0:
  if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
  yych = *YYCURSOR;
  switch(yych){
  case 0x00:  goto yy89;
  case 0x01:
  case 0x02:
  case 0x03:
  case 0x04:
  case 0x05:
  case 0x06:
  case 0x07:
  case 0x08:  case 0x0E:
  case 0x0F:
  case 0x10:
  case 0x11:
  case 0x12:
  case 0x13:
  case 0x14:
  case 0x15:
  case 0x16:
  case 0x17:
  case 0x18:
  case 0x19:
  case 0x1A:
  case 0x1B:
  case 0x1C:
  case 0x1D:
  case 0x1E:
  case 0x1F:  goto yy2;
  case 0x09:  case 0x0B:
  case 0x0C:  case ' ': goto yy84;
  case 0x0A:  goto yy86;
  case 0x0D:  goto yy88;
  case '!': goto yy67;
  case '"': goto yy83;
  case '#': goto yy42;
  case '%': goto yy34;
  case '&': goto yy61;
  case '\'':  goto yy82;
  case '(': goto yy44;
  case ')': goto yy46;
  case '*': goto yy56;
  case '+': goto yy52;
  case ',': goto yy73;
  case '-': goto yy54;
  case '.': goto yy50;
  case '/': goto yy3;
  case '0': goto yy79;
  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9': goto yy81;
  case ':': goto yy40;
  case ';': goto yy48;
  case '<': goto yy30;
  case '=': goto yy69;
  case '>': goto yy71;
  case '?': goto yy28;
  case 'A':
  case 'B':
  case 'C':
  case 'D':
  case 'E':
  case 'F':
  case 'G':
  case 'H':
  case 'I':
  case 'J':
  case 'K': case 'M':
  case 'N':
  case 'O':
  case 'P':
  case 'Q':
  case 'R':
  case 'S':
  case 'T':
  case 'U':
  case 'V':
  case 'W':
  case 'X':
  case 'Y':
  case 'Z': case 'h': case 'j':
  case 'k': case 'q': case 'y':
  case 'z': goto yy75;
  case 'L': goto yy76;
  case '[': goto yy36;
  case '\\':  goto yy77;
  case ']': goto yy38;
  case '^': goto yy58;
  case '_': goto yy25;
  case 'a': goto yy5;
  case 'b': goto yy7;
  case 'c': goto yy8;
  case 'd': goto yy9;
  case 'e': goto yy10;
  case 'f': goto yy11;
  case 'g': goto yy12;
  case 'i': goto yy13;
  case 'l': goto yy14;
  case 'm': goto yy15;
  case 'n': goto yy16;
  case 'o': goto yy17;
  case 'p': goto yy18;
  case 'r': goto yy19;
  case 's': goto yy20;
  case 't': goto yy21;
  case 'u': goto yy22;
  case 'v': goto yy23;
  case 'w': goto yy24;
  case 'x': goto yy60;
  case '{': goto yy26;
  case '|': goto yy63;
  case '}': goto yy32;
  case '~': goto yy65;
  default:  goto yy91;
  }
yy2:  YYCURSOR = YYMARKER;
  switch(yyaccept){
  case 102: goto yy934;
  case 101: goto yy932;
  case 98:  goto yy918;
  case 97:  goto yy915;
  case 96:  goto yy908;
  case 95:  goto yy906;
  case 94:  goto yy901;
  case 93:  goto yy898;
  case 91:  goto yy888;
  case 92:  goto yy894;
  case 90:  goto yy886;
  case 88:  goto yy870;
  case 87:  goto yy865;
  case 84:  goto yy842;
  case 86:  goto yy859;
  case 85:  goto yy854;
  case 83:  goto yy839;
  case 82:  goto yy836;
  case 81:  goto yy833;
  case 80:  goto yy828;
  case 79:  goto yy823;
  case 78:  goto yy814;
  case 77:  goto yy810;
  case 76:  goto yy806;
  case 75:  goto yy804;
  case 74:  goto yy795;
  case 71:  goto yy783;
  case 73:  goto yy791;
  case 72:  goto yy787;
  case 70:  goto yy781;
  case 69:  goto yy777;
  case 68:  goto yy770;
  case 67:  goto yy762;
  case 64:  goto yy751;
  case 61:  goto yy737;
  case 60:  goto yy732;
  case 59:  goto yy723;
  case 58:  goto yy716;
  case 57:  goto yy710;
  case 56:  goto yy696;
  case 55:  goto yy688;
  case 54:  goto yy684;
  case 53:  goto yy680;
  case 51:  goto yy668;
  case 52:  goto yy674;
  case 50:  goto yy664;
  case 49:  goto yy658;
  case 48:  goto yy649;
  case 47:  goto yy642;
  case 46:  goto yy640;
  case 45:  goto yy635;
  case 44:  goto yy633;
  case 43:  goto yy630;
  case 42:  goto yy627;
  case 41:  goto yy625;
  case 40:  goto yy612;
  case 39:  goto yy609;
  case 38:  goto yy601;
  case 37:  goto yy595;
  case 36:  goto yy589;
  case 35:  goto yy587;
  case 34:  goto yy577;
  case 33:  goto yy571;
  case 29:  goto yy559;
  case 32:  goto yy565;
  case 31:  goto yy563;
  case 30:  goto yy561;
  case 23:  goto yy523;
  case 21:  goto yy513;
  case 22:  goto yy518;
  case 20:  goto yy505;
  case 18:  goto yy491;
  case 27:  goto yy545;
  case 26:  goto yy542;
  case 28:  goto yy552;
  case 25:  goto yy536;
  case 19:  goto yy497;
  case 24:  goto yy526;
  case 2: goto yy43;
  case 14:  goto yy424;
  case 15:  goto yy452;
  case 1: goto yy29;
  case 3: goto yy51;
  case 10:  goto yy269;
  case 100: goto yy926;
  case 4: goto yy64;
  case 99:  goto yy923;
  case 16:  goto yy456;
  case 89:  goto yy879;
  case 65:  goto yy756;
  case 11:  goto yy273;
  case 104: goto yy940;
  case 63:  goto yy744;
  case 66:  goto yy760;
  case 103: goto yy936;
  case 62:  goto yy740;
  case 17:  goto yy460;
  case 0: goto yy6;
  case 6: goto yy80;
  case 9: goto yy188;
  case 8: goto yy150;
  case 7: goto yy100;
  case 13:  goto yy329;
  case 12:  goto yy314;
  case 5: goto yy78;
  }
yy3:  ++YYCURSOR;
  if((yych = *YYCURSOR) <= '.'){
    if(yych == '*') goto yy945;
    goto yy4;
  } else {
    if(yych <= '/') goto yy943;
    if(yych == '=') goto yy941;
    goto yy4;
  }
yy4:
#line 545 "cpp.re"
{ RET(T_DIVIDE); }
#line 646 "cpp_re.cpp"
yy5:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'r'){
    if(yych == 'n') goto yy927;
    goto yy225;
  } else {
    if(yych <= 's') goto yy928;
    if(yych == 'u') goto yy929;
    goto yy225;
  }
yy6:
#line 609 "cpp.re"
{ RET(T_IDENTIFIER); }
#line 660 "cpp_re.cpp"
yy7:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'n'){
    if(yych == 'i') goto yy909;
    goto yy225;
  } else {
    if(yych <= 'o') goto yy910;
    if(yych == 'r') goto yy911;
    goto yy225;
  }
yy8:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  switch(yych){
  case 'a': goto yy871;
  case 'h': goto yy872;
  case 'l': goto yy873;
  case 'o': goto yy874;
  default:  goto yy225;
  }
yy9:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'n'){
    if(yych == 'e') goto yy840;
    goto yy225;
  } else {
    if(yych <= 'o') goto yy841;
    if(yych == 'y') goto yy843;
    goto yy225;
  }
yy10: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'm'){
    if(yych == 'l') goto yy815;
    goto yy225;
  } else {
    if(yych <= 'n') goto yy816;
    if(yych == 'x') goto yy817;
    goto yy225;
  }
yy11: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  switch(yych){
  case 'a': goto yy796;
  case 'l': goto yy797;
  case 'o': goto yy798;
  case 'r': goto yy799;
  default:  goto yy225;
  }
yy12: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy792;
  goto yy225;
yy13: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'f') goto yy782;
  if(yych == 'n') goto yy784;
  goto yy225;
yy14: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy778;
  goto yy225;
yy15: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'u') goto yy771;
  goto yy225;
yy16: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'd'){
    if(yych == 'a') goto yy752;
    goto yy225;
  } else {
    if(yych <= 'e') goto yy753;
    if(yych == 'o') goto yy754;
    goto yy225;
  }
yy17: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'p') goto yy738;
  if(yych == 'r') goto yy739;
  goto yy225;
yy18: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'r') goto yy717;
  if(yych == 'u') goto yy718;
  goto yy225;
yy19: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy689;
  goto yy225;
yy20: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 's'){
    if(yych <= 'g') goto yy225;
    if(yych <= 'h') goto yy650;
    if(yych <= 'i') goto yy651;
    goto yy225;
  } else {
    if(yych <= 't') goto yy652;
    if(yych == 'w') goto yy653;
    goto yy225;
  }
yy21: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'h'){
    if(yych == 'e') goto yy613;
    if(yych <= 'g') goto yy225;
    goto yy614;
  } else {
    if(yych <= 'r'){
      if(yych <= 'q') goto yy225;
      goto yy615;
    } else {
      if(yych == 'y') goto yy616;
      goto yy225;
    }
  }
yy22: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy596;
  if(yych == 's') goto yy597;
  goto yy225;
yy23: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy578;
  if(yych == 'o') goto yy579;
  goto yy225;
yy24: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'c') goto yy566;
  if(yych == 'h') goto yy567;
  goto yy225;
yy25: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  switch(yych){
  case '_': goto yy477;
  case 'a': goto yy478;
  case 'b': goto yy479;
  case 'c': goto yy480;
  case 'd': goto yy481;
  case 'f': goto yy482;
  case 'i': goto yy483;
  case 's': goto yy484;
  default:  goto yy225;
  }
yy26: ++YYCURSOR;
  goto yy27;
yy27:
#line 495 "cpp.re"
{ RET(T_LEFTBRACE); }
#line 810 "cpp_re.cpp"
yy28: yyaccept = 1;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '?') goto yy442;
  goto yy29;
yy29:
#line 520 "cpp.re"
{ RET(T_QUESTION_MARK); }
#line 818 "cpp_re.cpp"
yy30: ++YYCURSOR;
  if((yych = *YYCURSOR) <= ':'){
    if(yych == '%') goto yy438;
    if(yych >= ':') goto yy436;
    goto yy31;
  } else {
    if(yych <= ';') goto yy31;
    if(yych <= '<') goto yy434;
    if(yych <= '=') goto yy432;
    goto yy31;
  }
yy31:
#line 561 "cpp.re"
{ RET(T_LESS); }
#line 833 "cpp_re.cpp"
yy32: ++YYCURSOR;
  goto yy33;
yy33:
#line 498 "cpp.re"
{ RET(T_RIGHTBRACE); }
#line 839 "cpp_re.cpp"
yy34: ++YYCURSOR;
  if((yych = *YYCURSOR) <= '<'){
    if(yych == ':') goto yy423;
    goto yy35;
  } else {
    if(yych <= '=') goto yy425;
    if(yych <= '>') goto yy427;
    goto yy35;
  }
yy35:
#line 546 "cpp.re"
{ RET(T_PERCENT); }
#line 852 "cpp_re.cpp"
yy36: ++YYCURSOR;
  goto yy37;
yy37:
#line 501 "cpp.re"
{ RET(T_LEFTBRACKET); }
#line 858 "cpp_re.cpp"
yy38: ++YYCURSOR;
  goto yy39;
yy39:
#line 504 "cpp.re"
{ RET(T_RIGHTBRACKET); }
#line 864 "cpp_re.cpp"
yy40: ++YYCURSOR;
  if((yych = *YYCURSOR) == ':') goto yy419;
  if(yych == '>') goto yy421;
  goto yy41;
yy41:
#line 518 "cpp.re"
{ RET(T_COLON); }
#line 872 "cpp_re.cpp"
yy42: yyaccept = 2;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'e'){
    if(yych <= '#'){
      if(yych <= 0x1F){
        if(yych == 0x09)  goto yy296;
        goto yy43;
      } else {
        if(yych <= ' ') goto yy296;
        if(yych >= '#') goto yy307;
        goto yy43;
      }
    } else {
      if(yych <= '>'){
        if(yych == '/') goto yy296;
        goto yy43;
      } else {
        if(yych <= '?') goto yy306;
        if(yych >= 'd') goto yy296;
        goto yy43;
      }
    }
  } else {
    if(yych <= 'p'){
      if(yych <= 'k'){
        if(yych == 'i') goto yy296;
        goto yy43;
      } else {
        if(yych <= 'l') goto yy296;
        if(yych >= 'p') goto yy296;
        goto yy43;
      }
    } else {
      if(yych <= 't'){
        if(yych == 'r') goto yy296;
        goto yy43;
      } else {
        if(yych == 'v') goto yy43;
        if(yych <= 'w') goto yy296;
        goto yy43;
      }
    }
  }
yy43:
#line 507 "cpp.re"
{ RET(T_POUND); }
#line 919 "cpp_re.cpp"
yy44: ++YYCURSOR;
  goto yy45;
yy45:
#line 515 "cpp.re"
{ RET(T_LEFTPAREN); }
#line 925 "cpp_re.cpp"
yy46: ++YYCURSOR;
  goto yy47;
yy47:
#line 516 "cpp.re"
{ RET(T_RIGHTPAREN); }
#line 931 "cpp_re.cpp"
yy48: ++YYCURSOR;
  goto yy49;
yy49:
#line 517 "cpp.re"
{ RET(T_SEMICOLON); }
#line 937 "cpp_re.cpp"
yy50: yyaccept = 3;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '-'){
    if(yych == '*') goto yy290;
    goto yy51;
  } else {
    if(yych <= '.') goto yy292;
    if(yych <= '/') goto yy51;
    if(yych <= '9') goto yy186;
    goto yy51;
  }
yy51:
#line 531 "cpp.re"
{ RET(T_DOT); }
#line 952 "cpp_re.cpp"
yy52: ++YYCURSOR;
  if((yych = *YYCURSOR) == '+') goto yy286;
  if(yych == '=') goto yy288;
  goto yy53;
yy53:
#line 542 "cpp.re"
{ RET(T_PLUS); }
#line 960 "cpp_re.cpp"
yy54: ++YYCURSOR;
  if((yych = *YYCURSOR) <= '<'){
    if(yych == '-') goto yy280;
    goto yy55;
  } else {
    if(yych <= '=') goto yy282;
    if(yych <= '>') goto yy278;
    goto yy55;
  }
yy55:
#line 543 "cpp.re"
{ RET(T_MINUS); }
#line 973 "cpp_re.cpp"
yy56: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy276;
  goto yy57;
yy57:
#line 544 "cpp.re"
{ RET(T_STAR); }
#line 980 "cpp_re.cpp"
yy58: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy274;
  goto yy59;
yy59:
#line 547 "cpp.re"
{ RET(T_XOR); }
#line 987 "cpp_re.cpp"
yy60: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy267;
  goto yy225;
yy61: ++YYCURSOR;
  if((yych = *YYCURSOR) == '&') goto yy263;
  if(yych == '=') goto yy265;
  goto yy62;
yy62:
#line 550 "cpp.re"
{ RET(T_AND); }
#line 999 "cpp_re.cpp"
yy63: yyaccept = 4;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '>'){
    if(yych == '=') goto yy258;
    goto yy64;
  } else {
    if(yych <= '?') goto yy255;
    if(yych == '|') goto yy256;
    goto yy64;
  }
yy64:
#line 552 "cpp.re"
{ RET(T_OR); }
#line 1013 "cpp_re.cpp"
yy65: ++YYCURSOR;
  goto yy66;
yy66:
#line 555 "cpp.re"
{ RET(T_COMPL); }
#line 1019 "cpp_re.cpp"
yy67: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy253;
  goto yy68;
yy68:
#line 558 "cpp.re"
{ RET(T_NOT); }
#line 1026 "cpp_re.cpp"
yy69: ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy251;
  goto yy70;
yy70:
#line 560 "cpp.re"
{ RET(T_ASSIGN); }
#line 1033 "cpp_re.cpp"
yy71: ++YYCURSOR;
  if((yych = *YYCURSOR) <= '<') goto yy72;
  if(yych <= '=') goto yy245;
  if(yych <= '>') goto yy247;
  goto yy72;
yy72:
#line 562 "cpp.re"
{ RET(T_GREATER); }
#line 1042 "cpp_re.cpp"
yy73: ++YYCURSOR;
  goto yy74;
yy74:
#line 594 "cpp.re"
{ RET(T_COMMA); }
#line 1048 "cpp_re.cpp"
yy75: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  goto yy225;
yy76: yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '?'){
    if(yych <= '\''){
      if(yych == '"') goto yy95;
      if(yych <= '&') goto yy6;
      goto yy244;
    } else {
      if(yych <= '/') goto yy6;
      if(yych <= '9') goto yy224;
      if(yych <= '>') goto yy6;
      goto yy227;
    }
  } else {
    if(yych <= '\\'){
      if(yych <= '@') goto yy6;
      if(yych <= 'Z') goto yy224;
      if(yych <= '[') goto yy6;
      goto yy226;
    } else {
      if(yych <= '_'){
        if(yych <= '^') goto yy6;
        goto yy224;
      } else {
        if(yych <= '`') goto yy6;
        if(yych <= 'z') goto yy224;
        goto yy6;
      }
    }
  }
yy77: yyaccept = 5;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'U') goto yy216;
  if(yych == 'u') goto yy215;
  goto yy78;
yy78:
#line 677 "cpp.re"
{
        /* if (0 != s->error_proc)
            (*s->error_proc)(s, "Unexpected character: '%c'", *s->tok);
        else
            printf("unexpected character: '%c'\n", *s->tok);
        */
        RET(TOKEN_FROM_ID(*s->tok, UnknownTokenType));
    }
#line 1097 "cpp_re.cpp"
yy79: yyaccept = 6;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'U'){
    if(yych <= '9'){
      if(yych <= '.'){
        if(yych >= '.') goto yy186;
        goto yy80;
      } else {
        if(yych <= '/') goto yy80;
        if(yych <= '7') goto yy208;
        goto yy210;
      }
    } else {
      if(yych <= 'K'){
        if(yych == 'E') goto yy183;
        goto yy80;
      } else {
        if(yych <= 'L') goto yy190;
        if(yych >= 'U') goto yy189;
        goto yy80;
      }
    }
  } else {
    if(yych <= 'k'){
      if(yych <= 'X'){
        if(yych >= 'X') goto yy212;
        goto yy80;
      } else {
        if(yych == 'e') goto yy183;
        goto yy80;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 'l') goto yy191;
        if(yych >= 'u') goto yy189;
        goto yy80;
      } else {
        if(yych == 'x') goto yy212;
        goto yy80;
      }
    }
  }
yy80:
#line 615 "cpp.re"
{ RET(T_INTLIT); }
#line 1143 "cpp_re.cpp"
yy81: yyaccept = 6;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'L'){
    if(yych <= '9'){
      if(yych == '.') goto yy186;
      if(yych <= '/') goto yy80;
      goto yy184;
    } else {
      if(yych == 'E') goto yy183;
      if(yych <= 'K') goto yy80;
      goto yy190;
    }
  } else {
    if(yych <= 'e'){
      if(yych == 'U') goto yy189;
      if(yych <= 'd') goto yy80;
      goto yy183;
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy80;
        goto yy191;
      } else {
        if(yych == 'u') goto yy189;
        goto yy80;
      }
    }
  }
yy82: yyaccept = 5;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy140;
    if(yych <= 0x0A)  goto yy78;
    goto yy140;
  } else {
    if(yych <= 0x1F)  goto yy78;
    if(yych == '\'')  goto yy78;
    goto yy140;
  }
yy83: yyaccept = 5;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 0x0A){
    if(yych == 0x09)  goto yy96;
    goto yy78;
  } else {
    if(yych <= 0x0C)  goto yy96;
    if(yych <= 0x1F)  goto yy78;
    goto yy96;
  }
yy84: ++YYCURSOR;
  yych = *YYCURSOR;
  goto yy94;
yy85:
#line 654 "cpp.re"
{ RET(T_SPACE); }
#line 1198 "cpp_re.cpp"
yy86: ++YYCURSOR;
  goto yy87;
yy87:
#line 657 "cpp.re"
{
        s->line++;
        cursor.column = 1;
        RET(T_NEWLINE);
    }
#line 1208 "cpp_re.cpp"
yy88: yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy92;
  goto yy87;
yy89: ++YYCURSOR;
  goto yy90;
yy90:
#line 664 "cpp.re"
{
        if(cursor != s->eof) 
        {
            using namespace std;      // some systems have printf in std
            if (0 != s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file\n");
        }
        RET(T_EOF);
    }
#line 1227 "cpp_re.cpp"
yy91: yych = *++YYCURSOR;
  goto yy78;
yy92: yych = *++YYCURSOR;
  goto yy87;
yy93: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy94;
yy94: if(yych <= 0x0A){
    if(yych == 0x09)  goto yy93;
    goto yy85;
  } else {
    if(yych <= 0x0C)  goto yy93;
    if(yych == ' ') goto yy93;
    goto yy85;
  }
yy95: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy96;
yy96: if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy97;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy97: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy110;
    } else {
      if(yych != '\\')  goto yy95;
      goto yy98;
    }
  }
yy98: ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '`'){
    if(yych <= '7'){
      if(yych <= '&'){
        if(yych == '"') goto yy95;
        goto yy2;
      } else {
        if(yych <= '\'')  goto yy95;
        if(yych <= '/') goto yy2;
        goto yy105;
      }
    } else {
      if(yych <= 'T'){
        if(yych == '?') goto yy103;
        goto yy2;
      } else {
        if(yych <= 'U') goto yy102;
        if(yych == '\\')  goto yy95;
        goto yy2;
      }
    }
  } else {
    if(yych <= 'r'){
      if(yych <= 'f'){
        if(yych <= 'b') goto yy95;
        if(yych <= 'e') goto yy2;
        goto yy95;
      } else {
        if(yych == 'n') goto yy95;
        if(yych <= 'q') goto yy2;
        goto yy95;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 's') goto yy2;
        if(yych <= 't') goto yy95;
        goto yy101;
      } else {
        if(yych <= 'v') goto yy95;
        if(yych == 'x') goto yy104;
        goto yy2;
      }
    }
  }
yy99: ++YYCURSOR;
  goto yy100;
yy100:
#line 624 "cpp.re"
{ RET(T_STRINGLIT); }
#line 1340 "cpp_re.cpp"
yy101:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy136;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy136;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy136;
    goto yy2;
  }
yy102:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy129;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy129;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy129;
    goto yy2;
  }
yy103:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy109;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy104:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy107;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy107;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy107;
    goto yy2;
  }
yy105:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy95;
      goto yy99;
    }
  } else {
    if(yych <= '>'){
      if(yych <= '/') goto yy95;
      if(yych >= '8') goto yy95;
      goto yy106;
    } else {
      if(yych <= '?') goto yy97;
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy106:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy97;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy107:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy108;
yy108:  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy107;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy107;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych <= 'f') goto yy107;
        goto yy95;
      }
    }
  }
yy109:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy110;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy110:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy111;
yy111:  if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy95;
      goto yy99;
    }
  } else {
    if(yych <= '>'){
      if(yych != '/') goto yy95;
      goto yy112;
    } else {
      if(yych <= '?') goto yy110;
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy112:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy113;
yy113:  if(yych <= '>'){
    if(yych <= 0x1F){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy95;
      } else {
        if(yych <= 0x0A)  goto yy2;
        if(yych <= 0x0C)  goto yy95;
        goto yy2;
      }
    } else {
      if(yych <= '"'){
        if(yych <= '!') goto yy95;
        goto yy116;
      } else {
        if(yych <= '/') goto yy95;
        if(yych <= '7') goto yy105;
        goto yy95;
      }
    }
  } else {
    if(yych <= '\\'){
      if(yych <= 'T'){
        if(yych <= '?') goto yy117;
        goto yy95;
      } else {
        if(yych <= 'U') goto yy115;
        if(yych <= '[') goto yy95;
        goto yy112;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 't') goto yy95;
        goto yy114;
      } else {
        if(yych == 'x') goto yy107;
        goto yy95;
      }
    }
  }
yy114:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy126;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy126;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych <= 'f') goto yy126;
        goto yy95;
      }
    }
  }
yy115:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy119;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy119;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych <= 'f') goto yy119;
        goto yy95;
      }
    }
  }
yy116:  yyaccept = 7;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy100;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy100;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy97;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy117:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy118;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy118:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '"'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '!') goto yy95;
      goto yy99;
    }
  } else {
    if(yych <= '>'){
      if(yych == '/') goto yy112;
      goto yy95;
    } else {
      if(yych <= '?') goto yy110;
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy119:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy120;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy120;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy120;
      }
    }
  }
yy120:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy121;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy121;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy121;
      }
    }
  }
yy121:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy122;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy122;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy122;
      }
    }
  }
yy122:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy123;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy123;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy123;
      }
    }
  }
yy123:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy124;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy124;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy124;
      }
    }
  }
yy124:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy125;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy125;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy125;
      }
    }
  }
yy125:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy97;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy126:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy127;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy127;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy127;
      }
    }
  }
yy127:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy95;
      if(yych <= 0x0A)  goto yy2;
      goto yy95;
    } else {
      if(yych <= '!'){
        if(yych <= 0x1F)  goto yy2;
        goto yy95;
      } else {
        if(yych <= '"') goto yy99;
        if(yych <= '/') goto yy95;
        goto yy128;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy97;
      if(yych <= '@') goto yy95;
      goto yy128;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy95;
        goto yy98;
      } else {
        if(yych <= '`') goto yy95;
        if(yych >= 'g') goto yy95;
        goto yy128;
      }
    }
  }
yy128:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '!'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy95;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy95;
      if(yych <= 0x1F)  goto yy2;
      goto yy95;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '"') goto yy99;
      if(yych <= '>') goto yy95;
      goto yy97;
    } else {
      if(yych == '\\')  goto yy98;
      goto yy95;
    }
  }
yy129:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy130;
  } else {
    if(yych <= 'F') goto yy130;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy130;
  }
yy130:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy131;
  } else {
    if(yych <= 'F') goto yy131;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy131;
  }
yy131:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy132;
  } else {
    if(yych <= 'F') goto yy132;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy132;
  }
yy132:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy133;
  } else {
    if(yych <= 'F') goto yy133;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy133;
  }
yy133:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy134;
  } else {
    if(yych <= 'F') goto yy134;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy134;
  }
yy134:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy135;
  } else {
    if(yych <= 'F') goto yy135;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy135;
  }
yy135:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy95;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy95;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy95;
    goto yy2;
  }
yy136:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy137;
  } else {
    if(yych <= 'F') goto yy137;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy137;
  }
yy137:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy138;
  } else {
    if(yych <= 'F') goto yy138;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy138;
  }
yy138:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy95;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy95;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy95;
    goto yy2;
  }
yy139:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy140;
yy140:  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy141;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy141:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy154;
    } else {
      if(yych != '\\')  goto yy139;
      goto yy142;
    }
  }
yy142:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '`'){
    if(yych <= '7'){
      if(yych <= '&'){
        if(yych == '"') goto yy139;
        goto yy2;
      } else {
        if(yych <= '\'')  goto yy139;
        if(yych <= '/') goto yy2;
        goto yy147;
      }
    } else {
      if(yych <= 'T'){
        if(yych == '?') goto yy145;
        goto yy2;
      } else {
        if(yych <= 'U') goto yy144;
        if(yych == '\\')  goto yy139;
        goto yy2;
      }
    }
  } else {
    if(yych <= 'r'){
      if(yych <= 'f'){
        if(yych <= 'b') goto yy139;
        if(yych <= 'e') goto yy2;
        goto yy139;
      } else {
        if(yych == 'n') goto yy139;
        if(yych <= 'q') goto yy2;
        goto yy139;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 's') goto yy2;
        if(yych <= 't') goto yy139;
        goto yy143;
      } else {
        if(yych <= 'v') goto yy139;
        if(yych == 'x') goto yy146;
        goto yy2;
      }
    }
  }
yy143:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy180;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy180;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy180;
    goto yy2;
  }
yy144:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy173;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy173;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy173;
    goto yy2;
  }
yy145:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy153;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy146:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy151;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy151;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy151;
    goto yy2;
  }
yy147:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy139;
      goto yy149;
    }
  } else {
    if(yych <= '>'){
      if(yych <= '/') goto yy139;
      if(yych >= '8') goto yy139;
      goto yy148;
    } else {
      if(yych <= '?') goto yy141;
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy148:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy141;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy149:  ++YYCURSOR;
  goto yy150;
yy150:
#line 621 "cpp.re"
{ RET(T_CHARLIT); }
#line 2358 "cpp_re.cpp"
yy151:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy152;
yy152:  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy151;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy151;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych <= 'f') goto yy151;
        goto yy139;
      }
    }
  }
yy153:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy154;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy154:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy155;
yy155:  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy139;
      goto yy149;
    }
  } else {
    if(yych <= '>'){
      if(yych != '/') goto yy139;
      goto yy156;
    } else {
      if(yych <= '?') goto yy154;
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy156:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy157;
yy157:  if(yych <= '>'){
    if(yych <= 0x1F){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy139;
      } else {
        if(yych <= 0x0A)  goto yy2;
        if(yych <= 0x0C)  goto yy139;
        goto yy2;
      }
    } else {
      if(yych <= '\''){
        if(yych <= '&') goto yy139;
        goto yy160;
      } else {
        if(yych <= '/') goto yy139;
        if(yych <= '7') goto yy147;
        goto yy139;
      }
    }
  } else {
    if(yych <= '\\'){
      if(yych <= 'T'){
        if(yych <= '?') goto yy161;
        goto yy139;
      } else {
        if(yych <= 'U') goto yy159;
        if(yych <= '[') goto yy139;
        goto yy156;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 't') goto yy139;
        goto yy158;
      } else {
        if(yych == 'x') goto yy151;
        goto yy139;
      }
    }
  }
yy158:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy170;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy170;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych <= 'f') goto yy170;
        goto yy139;
      }
    }
  }
yy159:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy163;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy163;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych <= 'f') goto yy163;
        goto yy139;
      }
    }
  }
yy160:  yyaccept = 8;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy150;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy150;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy141;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy161:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy162;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy162:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '\''){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      if(yych <= '&') goto yy139;
      goto yy149;
    }
  } else {
    if(yych <= '>'){
      if(yych == '/') goto yy156;
      goto yy139;
    } else {
      if(yych <= '?') goto yy154;
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy163:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy164;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy164;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy164;
      }
    }
  }
yy164:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy165;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy165;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy165;
      }
    }
  }
yy165:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy166;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy166;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy166;
      }
    }
  }
yy166:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy167;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy167;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy167;
      }
    }
  }
yy167:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy168;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy168;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy168;
      }
    }
  }
yy168:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy169;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy169;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy169;
      }
    }
  }
yy169:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy141;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy170:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy171;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy171;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy171;
      }
    }
  }
yy171:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '9'){
    if(yych <= 0x0C){
      if(yych == 0x09)  goto yy139;
      if(yych <= 0x0A)  goto yy2;
      goto yy139;
    } else {
      if(yych <= '&'){
        if(yych <= 0x1F)  goto yy2;
        goto yy139;
      } else {
        if(yych <= '\'')  goto yy149;
        if(yych <= '/') goto yy139;
        goto yy172;
      }
    }
  } else {
    if(yych <= 'F'){
      if(yych == '?') goto yy141;
      if(yych <= '@') goto yy139;
      goto yy172;
    } else {
      if(yych <= '\\'){
        if(yych <= '[') goto yy139;
        goto yy142;
      } else {
        if(yych <= '`') goto yy139;
        if(yych >= 'g') goto yy139;
        goto yy172;
      }
    }
  }
yy172:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '&'){
    if(yych <= 0x0A){
      if(yych == 0x09)  goto yy139;
      goto yy2;
    } else {
      if(yych <= 0x0C)  goto yy139;
      if(yych <= 0x1F)  goto yy2;
      goto yy139;
    }
  } else {
    if(yych <= '?'){
      if(yych <= '\'')  goto yy149;
      if(yych <= '>') goto yy139;
      goto yy141;
    } else {
      if(yych == '\\')  goto yy142;
      goto yy139;
    }
  }
yy173:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy174;
  } else {
    if(yych <= 'F') goto yy174;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy174;
  }
yy174:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy175;
  } else {
    if(yych <= 'F') goto yy175;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy175;
  }
yy175:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy176;
  } else {
    if(yych <= 'F') goto yy176;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy176;
  }
yy176:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy177;
  } else {
    if(yych <= 'F') goto yy177;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy177;
  }
yy177:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy178;
  } else {
    if(yych <= 'F') goto yy178;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy178;
  }
yy178:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy179;
  } else {
    if(yych <= 'F') goto yy179;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy179;
  }
yy179:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy139;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy139;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy139;
    goto yy2;
  }
yy180:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy181;
  } else {
    if(yych <= 'F') goto yy181;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy181;
  }
yy181:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy182;
  } else {
    if(yych <= 'F') goto yy182;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy182;
  }
yy182:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy139;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy139;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy139;
    goto yy2;
  }
yy183:  yych = *++YYCURSOR;
  if(yych <= ','){
    if(yych == '+') goto yy205;
    goto yy2;
  } else {
    if(yych <= '-') goto yy205;
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy206;
    goto yy2;
  }
yy184:  yyaccept = 6;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy185;
yy185:  if(yych <= 'L'){
    if(yych <= '9'){
      if(yych == '.') goto yy186;
      if(yych <= '/') goto yy80;
      goto yy184;
    } else {
      if(yych == 'E') goto yy183;
      if(yych <= 'K') goto yy80;
      goto yy190;
    }
  } else {
    if(yych <= 'e'){
      if(yych == 'U') goto yy189;
      if(yych <= 'd') goto yy80;
      goto yy183;
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy80;
        goto yy191;
      } else {
        if(yych == 'u') goto yy189;
        goto yy80;
      }
    }
  }
yy186:  yyaccept = 9;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy187;
yy187:  if(yych <= 'K'){
    if(yych <= 'D'){
      if(yych <= '/') goto yy188;
      if(yych <= '9') goto yy186;
      goto yy188;
    } else {
      if(yych <= 'E') goto yy198;
      if(yych <= 'F') goto yy199;
      goto yy188;
    }
  } else {
    if(yych <= 'e'){
      if(yych <= 'L') goto yy200;
      if(yych >= 'e') goto yy198;
      goto yy188;
    } else {
      if(yych <= 'f') goto yy199;
      if(yych == 'l') goto yy200;
      goto yy188;
    }
  }
yy188:
#line 618 "cpp.re"
{ RET(T_FLOATLIT); }
#line 3135 "cpp_re.cpp"
yy189:  yych = *++YYCURSOR;
  if(yych == 'L') goto yy197;
  if(yych == 'l') goto yy196;
  goto yy80;
yy190:  yych = *++YYCURSOR;
  if(yych <= 'T'){
    if(yych == 'L') goto yy192;
    goto yy80;
  } else {
    if(yych <= 'U') goto yy194;
    if(yych == 'u') goto yy194;
    goto yy80;
  }
yy191:  yych = *++YYCURSOR;
  if(yych <= 'k'){
    if(yych == 'U') goto yy194;
    goto yy80;
  } else {
    if(yych <= 'l') goto yy192;
    if(yych == 'u') goto yy194;
    goto yy80;
  }
yy192:  ++YYCURSOR;
  if((yych = *YYCURSOR) == 'U') goto yy195;
  if(yych == 'u') goto yy195;
  goto yy193;
yy193:
#line 612 "cpp.re"
{ RET(T_LONGINTLIT); }
#line 3165 "cpp_re.cpp"
yy194:  yych = *++YYCURSOR;
  goto yy80;
yy195:  yych = *++YYCURSOR;
  goto yy193;
yy196:  yych = *++YYCURSOR;
  if(yych == 'l') goto yy195;
  goto yy80;
yy197:  yych = *++YYCURSOR;
  if(yych == 'L') goto yy195;
  goto yy80;
yy198:  yych = *++YYCURSOR;
  if(yych <= ','){
    if(yych == '+') goto yy202;
    goto yy2;
  } else {
    if(yych <= '-') goto yy202;
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy203;
    goto yy2;
  }
yy199:  yych = *++YYCURSOR;
  if(yych == 'L') goto yy201;
  if(yych == 'l') goto yy201;
  goto yy188;
yy200:  yych = *++YYCURSOR;
  if(yych == 'F') goto yy201;
  if(yych != 'f') goto yy188;
  goto yy201;
yy201:  yych = *++YYCURSOR;
  goto yy188;
yy202:  yych = *++YYCURSOR;
  if(yych <= '/') goto yy2;
  if(yych >= ':') goto yy2;
  goto yy203;
yy203:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy204;
yy204:  if(yych <= 'K'){
    if(yych <= '9'){
      if(yych <= '/') goto yy188;
      goto yy203;
    } else {
      if(yych == 'F') goto yy199;
      goto yy188;
    }
  } else {
    if(yych <= 'f'){
      if(yych <= 'L') goto yy200;
      if(yych <= 'e') goto yy188;
      goto yy199;
    } else {
      if(yych == 'l') goto yy200;
      goto yy188;
    }
  }
yy205:  yych = *++YYCURSOR;
  if(yych <= '/') goto yy2;
  if(yych >= ':') goto yy2;
  goto yy206;
yy206:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy207;
yy207:  if(yych <= 'K'){
    if(yych <= '9'){
      if(yych <= '/') goto yy188;
      goto yy206;
    } else {
      if(yych == 'F') goto yy199;
      goto yy188;
    }
  } else {
    if(yych <= 'f'){
      if(yych <= 'L') goto yy200;
      if(yych <= 'e') goto yy188;
      goto yy199;
    } else {
      if(yych == 'l') goto yy200;
      goto yy188;
    }
  }
yy208:  yyaccept = 6;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy209;
yy209:  if(yych <= 'L'){
    if(yych <= '7'){
      if(yych == '.') goto yy186;
      if(yych <= '/') goto yy80;
      goto yy208;
    } else {
      if(yych <= 'D'){
        if(yych >= ':') goto yy80;
        goto yy210;
      } else {
        if(yych <= 'E') goto yy183;
        if(yych <= 'K') goto yy80;
        goto yy190;
      }
    }
  } else {
    if(yych <= 'e'){
      if(yych == 'U') goto yy189;
      if(yych <= 'd') goto yy80;
      goto yy183;
    } else {
      if(yych <= 'l'){
        if(yych <= 'k') goto yy80;
        goto yy191;
      } else {
        if(yych == 'u') goto yy189;
        goto yy80;
      }
    }
  }
yy210:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy211;
yy211:  if(yych <= '9'){
    if(yych == '.') goto yy186;
    if(yych <= '/') goto yy2;
    goto yy210;
  } else {
    if(yych <= 'E'){
      if(yych <= 'D') goto yy2;
      goto yy183;
    } else {
      if(yych == 'e') goto yy183;
      goto yy2;
    }
  }
yy212:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy213;
  } else {
    if(yych <= 'F') goto yy213;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy213;
  }
yy213:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
  yych = *YYCURSOR;
  goto yy214;
yy214:  if(yych <= 'T'){
    if(yych <= '@'){
      if(yych <= '/') goto yy80;
      if(yych <= '9') goto yy213;
      goto yy80;
    } else {
      if(yych <= 'F') goto yy213;
      if(yych == 'L') goto yy190;
      goto yy80;
    }
  } else {
    if(yych <= 'k'){
      if(yych <= 'U') goto yy189;
      if(yych <= '`') goto yy80;
      if(yych <= 'f') goto yy213;
      goto yy80;
    } else {
      if(yych <= 'l') goto yy191;
      if(yych == 'u') goto yy189;
      goto yy80;
    }
  }
yy215:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy241;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy241;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy241;
    goto yy2;
  }
yy216:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy217;
  } else {
    if(yych <= 'F') goto yy217;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy217;
  }
yy217:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy218;
  } else {
    if(yych <= 'F') goto yy218;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy218;
  }
yy218:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy219;
  } else {
    if(yych <= 'F') goto yy219;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy219;
  }
yy219:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy220;
  } else {
    if(yych <= 'F') goto yy220;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy220;
  }
yy220:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy221;
  } else {
    if(yych <= 'F') goto yy221;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy221;
  }
yy221:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy222;
  } else {
    if(yych <= 'F') goto yy222;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy222;
  }
yy222:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy223;
  } else {
    if(yych <= 'F') goto yy223;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy223;
  }
yy223:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy224;
  } else {
    if(yych <= 'F') goto yy224;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy224;
  }
yy224:  yyaccept = 0;
  YYMARKER = ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy225;
yy225:  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy6;
      if(yych <= '9') goto yy224;
      goto yy6;
    } else {
      if(yych <= '?') goto yy227;
      if(yych <= '@') goto yy6;
      goto yy224;
    }
  } else {
    if(yych <= '^'){
      if(yych != '\\')  goto yy6;
      goto yy226;
    } else {
      if(yych == '`') goto yy6;
      if(yych <= 'z') goto yy224;
      goto yy6;
    }
  }
yy226:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == 'U') goto yy230;
  if(yych == 'u') goto yy229;
  goto yy2;
yy227:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych != '?') goto yy2;
  goto yy228;
yy228:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '/') goto yy226;
  goto yy2;
yy229:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy238;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy238;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy238;
    goto yy2;
  }
yy230:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy231;
  } else {
    if(yych <= 'F') goto yy231;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy231;
  }
yy231:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy232;
  } else {
    if(yych <= 'F') goto yy232;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy232;
  }
yy232:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy233;
  } else {
    if(yych <= 'F') goto yy233;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy233;
  }
yy233:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy234;
  } else {
    if(yych <= 'F') goto yy234;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy234;
  }
yy234:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy235;
  } else {
    if(yych <= 'F') goto yy235;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy235;
  }
yy235:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy236;
  } else {
    if(yych <= 'F') goto yy236;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy236;
  }
yy236:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy237;
  } else {
    if(yych <= 'F') goto yy237;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy237;
  }
yy237:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy224;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy224;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy224;
    goto yy2;
  }
yy238:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy239;
  } else {
    if(yych <= 'F') goto yy239;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy239;
  }
yy239:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy240;
  } else {
    if(yych <= 'F') goto yy240;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy240;
  }
yy240:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy224;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy224;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy224;
    goto yy2;
  }
yy241:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy242;
  } else {
    if(yych <= 'F') goto yy242;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy242;
  }
yy242:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych >= ':') goto yy2;
    goto yy243;
  } else {
    if(yych <= 'F') goto yy243;
    if(yych <= '`') goto yy2;
    if(yych >= 'g') goto yy2;
    goto yy243;
  }
yy243:  yych = *++YYCURSOR;
  if(yych <= '@'){
    if(yych <= '/') goto yy2;
    if(yych <= '9') goto yy224;
    goto yy2;
  } else {
    if(yych <= 'F') goto yy224;
    if(yych <= '`') goto yy2;
    if(yych <= 'f') goto yy224;
    goto yy2;
  }
yy244:  yych = *++YYCURSOR;
  if(yych == '\'')  goto yy2;
  goto yy140;
yy245:  ++YYCURSOR;
  goto yy246;
yy246:
#line 584 "cpp.re"
{ RET(T_GREATEREQUAL); }
#line 3674 "cpp_re.cpp"
yy247:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy249;
  goto yy248;
yy248:
#line 577 "cpp.re"
{ RET(T_SHIFTRIGHT); }
#line 3681 "cpp_re.cpp"
yy249:  ++YYCURSOR;
  goto yy250;
yy250:
#line 578 "cpp.re"
{ RET(T_SHIFTRIGHTASSIGN); }
#line 3687 "cpp_re.cpp"
yy251:  ++YYCURSOR;
  goto yy252;
yy252:
#line 580 "cpp.re"
{ RET(T_EQUAL); }
#line 3693 "cpp_re.cpp"
yy253:  ++YYCURSOR;
  goto yy254;
yy254:
#line 581 "cpp.re"
{ RET(T_NOTEQUAL); }
#line 3699 "cpp_re.cpp"
yy255:  yych = *++YYCURSOR;
  if(yych == '?') goto yy260;
  goto yy2;
yy256:  ++YYCURSOR;
  goto yy257;
yy257:
#line 587 "cpp.re"
{ RET(T_OROR); }
#line 3708 "cpp_re.cpp"
yy258:  ++YYCURSOR;
  goto yy259;
yy259:
#line 573 "cpp.re"
{ RET(T_ORASSIGN); }
#line 3714 "cpp_re.cpp"
yy260:  yych = *++YYCURSOR;
  if(yych != '!') goto yy2;
  goto yy261;
yy261:  ++YYCURSOR;
  goto yy262;
yy262:
#line 589 "cpp.re"
{ RET(T_OROR_TRIGRAPH); }
#line 3723 "cpp_re.cpp"
yy263:  ++YYCURSOR;
  goto yy264;
yy264:
#line 585 "cpp.re"
{ RET(T_ANDAND); }
#line 3729 "cpp_re.cpp"
yy265:  ++YYCURSOR;
  goto yy266;
yy266:
#line 571 "cpp.re"
{ RET(T_ANDASSIGN); }
#line 3735 "cpp_re.cpp"
yy267:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy268;
yy268:  yyaccept = 10;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy269;
      if(yych <= '9') goto yy224;
      goto yy269;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy269;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy269;
    } else {
      if(yych <= '_') goto yy270;
      if(yych <= '`') goto yy269;
      if(yych <= 'z') goto yy224;
      goto yy269;
    }
  }
yy269:
#line 549 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_XOR_ALT); }
#line 3766 "cpp_re.cpp"
yy270:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy271;
yy271:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'q') goto yy225;
  goto yy272;
yy272:  yyaccept = 11;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy273;
      if(yych <= '9') goto yy224;
      goto yy273;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy273;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy273;
    } else {
      if(yych == '`') goto yy273;
      if(yych <= 'z') goto yy224;
      goto yy273;
    }
  }
yy273:
#line 569 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_XORASSIGN_ALT); }
#line 3800 "cpp_re.cpp"
yy274:  ++YYCURSOR;
  goto yy275;
yy275:
#line 568 "cpp.re"
{ RET(T_XORASSIGN); }
#line 3806 "cpp_re.cpp"
yy276:  ++YYCURSOR;
  goto yy277;
yy277:
#line 565 "cpp.re"
{ RET(T_STARASSIGN); }
#line 3812 "cpp_re.cpp"
yy278:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '*') goto yy284;
  goto yy279;
yy279:
#line 605 "cpp.re"
{ RET(T_ARROW); }
#line 3819 "cpp_re.cpp"
yy280:  ++YYCURSOR;
  goto yy281;
yy281:
#line 593 "cpp.re"
{ RET(T_MINUSMINUS); }
#line 3825 "cpp_re.cpp"
yy282:  ++YYCURSOR;
  goto yy283;
yy283:
#line 564 "cpp.re"
{ RET(T_MINUSASSIGN); }
#line 3831 "cpp_re.cpp"
yy284:  ++YYCURSOR;
  goto yy285;
yy285:
#line 596 "cpp.re"
{ 
            if (s->act_in_c99_mode) {
                --YYCURSOR;
                RET(T_ARROW);
            }
            else {
                RET(T_ARROWSTAR); 
            }
        }
#line 3845 "cpp_re.cpp"
yy286:  ++YYCURSOR;
  goto yy287;
yy287:
#line 592 "cpp.re"
{ RET(T_PLUSPLUS); }
#line 3851 "cpp_re.cpp"
yy288:  ++YYCURSOR;
  goto yy289;
yy289:
#line 563 "cpp.re"
{ RET(T_PLUSASSIGN); }
#line 3857 "cpp_re.cpp"
yy290:  ++YYCURSOR;
  goto yy291;
yy291:
#line 533 "cpp.re"
{ 
            if (s->act_in_c99_mode) {
                --YYCURSOR;
                RET(T_DOT);
            }
            else {
                RET(T_DOTSTAR); 
            }
        }
#line 3871 "cpp_re.cpp"
yy292:  yych = *++YYCURSOR;
  if(yych != '.') goto yy2;
  goto yy293;
yy293:  ++YYCURSOR;
  goto yy294;
yy294:
#line 519 "cpp.re"
{ RET(T_ELLIPSIS); }
#line 3880 "cpp_re.cpp"
yy295:  ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
  yych = *YYCURSOR;
  goto yy296;
yy296:  if(yych <= 'i'){
    if(yych <= '.'){
      if(yych <= 0x09){
        if(yych <= 0x08)  goto yy2;
        goto yy295;
      } else {
        if(yych == ' ') goto yy295;
        goto yy2;
      }
    } else {
      if(yych <= 'd'){
        if(yych <= '/') goto yy297;
        if(yych <= 'c') goto yy2;
        goto yy304;
      } else {
        if(yych <= 'e') goto yy298;
        if(yych <= 'h') goto yy2;
        goto yy305;
      }
    }
  } else {
    if(yych <= 'q'){
      if(yych <= 'l'){
        if(yych <= 'k') goto yy2;
        goto yy302;
      } else {
        if(yych == 'p') goto yy301;
        goto yy2;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 'r') goto yy299;
        if(yych <= 't') goto yy2;
        goto yy303;
      } else {
        if(yych == 'w') goto yy300;
        goto yy2;
      }
    }
  }
yy297:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '*') goto yy412;
  goto yy2;
yy298:  yych = *++YYCURSOR;
  if(yych <= 'm'){
    if(yych == 'l') goto yy388;
    goto yy2;
  } else {
    if(yych <= 'n') goto yy389;
    if(yych == 'r') goto yy390;
    goto yy2;
  }
yy299:  yych = *++YYCURSOR;
  if(yych == 'e') goto yy382;
  goto yy2;
yy300:  yych = *++YYCURSOR;
  if(yych == 'a') goto yy375;
  goto yy2;
yy301:  yych = *++YYCURSOR;
  if(yych == 'r') goto yy369;
  goto yy2;
yy302:  yych = *++YYCURSOR;
  if(yych == 'i') goto yy365;
  goto yy2;
yy303:  yych = *++YYCURSOR;
  if(yych == 'n') goto yy360;
  goto yy2;
yy304:  yych = *++YYCURSOR;
  if(yych == 'e') goto yy354;
  goto yy2;
yy305:  yych = *++YYCURSOR;
  if(yych == 'f') goto yy313;
  if(yych == 'n') goto yy312;
  goto yy2;
yy306:  yych = *++YYCURSOR;
  if(yych == '?') goto yy309;
  goto yy2;
yy307:  ++YYCURSOR;
  goto yy308;
yy308:
#line 510 "cpp.re"
{ RET(T_POUND_POUND); }
#line 3969 "cpp_re.cpp"
yy309:  yych = *++YYCURSOR;
  if(yych != '=') goto yy2;
  goto yy310;
yy310:  ++YYCURSOR;
  goto yy311;
yy311:
#line 511 "cpp.re"
{ RET(T_POUND_POUND_TRIGRAPH); }
#line 3978 "cpp_re.cpp"
yy312:  yych = *++YYCURSOR;
  if(yych == 'c') goto yy324;
  goto yy2;
yy313:  yyaccept = 12;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy316;
  if(yych == 'n') goto yy315;
  goto yy314;
yy314:
#line 636 "cpp.re"
{ RET(T_PP_IF); }
#line 3990 "cpp_re.cpp"
yy315:  yych = *++YYCURSOR;
  if(yych == 'd') goto yy320;
  goto yy2;
yy316:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy317;
yy317:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy318;
yy318:  ++YYCURSOR;
  goto yy319;
yy319:
#line 637 "cpp.re"
{ RET(T_PP_IFDEF); }
#line 4005 "cpp_re.cpp"
yy320:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy321;
yy321:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy322;
yy322:  ++YYCURSOR;
  goto yy323;
yy323:
#line 638 "cpp.re"
{ RET(T_PP_IFNDEF); }
#line 4017 "cpp_re.cpp"
yy324:  yych = *++YYCURSOR;
  if(yych != 'l') goto yy2;
  goto yy325;
yy325:  yych = *++YYCURSOR;
  if(yych != 'u') goto yy2;
  goto yy326;
yy326:  yych = *++YYCURSOR;
  if(yych != 'd') goto yy2;
  goto yy327;
yy327:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy328;
yy328:  yyaccept = 13;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '_') goto yy330;
  goto yy332;
yy329:
#line 634 "cpp.re"
{ RET(T_PP_INCLUDE); }
#line 4037 "cpp_re.cpp"
yy330:  yych = *++YYCURSOR;
  if(yych == 'n') goto yy351;
  goto yy2;
yy331:  yyaccept = 13;
  YYMARKER = ++YYCURSOR;
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  goto yy332;
yy332:  if(yych <= '!'){
    if(yych <= 0x09){
      if(yych <= 0x08)  goto yy329;
      goto yy331;
    } else {
      if(yych == ' ') goto yy331;
      goto yy329;
    }
  } else {
    if(yych <= '/'){
      if(yych <= '"') goto yy335;
      if(yych <= '.') goto yy329;
      goto yy333;
    } else {
      if(yych == '<') goto yy334;
      goto yy329;
    }
  }
yy333:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych == '*') goto yy344;
  goto yy2;
yy334:  yych = *++YYCURSOR;
  if(yych == '>') goto yy2;
  goto yy341;
yy335:  yych = *++YYCURSOR;
  if(yych == '"') goto yy2;
  goto yy337;
yy336:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy337;
yy337:  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy336;
    if(yych <= 0x0A)  goto yy2;
    goto yy336;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '"') goto yy336;
    goto yy338;
  }
yy338:  ++YYCURSOR;
  goto yy339;
yy339:
#line 631 "cpp.re"
{ RET(T_PP_QHEADER); }
#line 4093 "cpp_re.cpp"
yy340:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy341;
yy341:  if(yych <= 0x0C){
    if(yych == 0x09)  goto yy340;
    if(yych <= 0x0A)  goto yy2;
    goto yy340;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '>') goto yy340;
    goto yy342;
  }
yy342:  ++YYCURSOR;
  goto yy343;
yy343:
#line 628 "cpp.re"
{ RET(T_PP_HHEADER); }
#line 4112 "cpp_re.cpp"
yy344:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy345;
yy345:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy344;
    goto yy346;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy348;
    goto yy344;
  }
yy346:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy347;
yy347:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy344;
    goto yy346;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '*') goto yy344;
    goto yy348;
  }
yy348:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy349;
yy349:  if(yych <= 0x1F){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy344;
    if(yych >= 0x0E)  goto yy2;
    goto yy350;
  } else {
    if(yych <= '*'){
      if(yych <= ')') goto yy344;
      goto yy348;
    } else {
      if(yych == '/') goto yy331;
      goto yy344;
    }
  }
yy350:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy344;
    goto yy346;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy348;
    goto yy344;
  }
yy351:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy352;
yy352:  yych = *++YYCURSOR;
  if(yych != 'x') goto yy2;
  goto yy353;
yy353:  yych = *++YYCURSOR;
  if(yych == 't') goto yy331;
  goto yy2;
yy354:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy355;
yy355:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy356;
yy356:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy357;
yy357:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy358;
yy358:  ++YYCURSOR;
  goto yy359;
yy359:
#line 642 "cpp.re"
{ RET(T_PP_DEFINE); }
#line 4195 "cpp_re.cpp"
yy360:  yych = *++YYCURSOR;
  if(yych != 'd') goto yy2;
  goto yy361;
yy361:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy362;
yy362:  yych = *++YYCURSOR;
  if(yych != 'f') goto yy2;
  goto yy363;
yy363:  ++YYCURSOR;
  goto yy364;
yy364:
#line 643 "cpp.re"
{ RET(T_PP_UNDEF); }
#line 4210 "cpp_re.cpp"
yy365:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy366;
yy366:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy367;
yy367:  ++YYCURSOR;
  goto yy368;
yy368:
#line 644 "cpp.re"
{ RET(T_PP_LINE); }
#line 4222 "cpp_re.cpp"
yy369:  yych = *++YYCURSOR;
  if(yych != 'a') goto yy2;
  goto yy370;
yy370:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy371;
yy371:  yych = *++YYCURSOR;
  if(yych != 'm') goto yy2;
  goto yy372;
yy372:  yych = *++YYCURSOR;
  if(yych != 'a') goto yy2;
  goto yy373;
yy373:  ++YYCURSOR;
  goto yy374;
yy374:
#line 646 "cpp.re"
{ RET(T_PP_PRAGMA); }
#line 4240 "cpp_re.cpp"
yy375:  yych = *++YYCURSOR;
  if(yych != 'r') goto yy2;
  goto yy376;
yy376:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy377;
yy377:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy378;
yy378:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy379;
yy379:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy380;
yy380:  ++YYCURSOR;
  goto yy381;
yy381:
#line 648 "cpp.re"
{ RET(T_PP_WARNING); }
#line 4261 "cpp_re.cpp"
yy382:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy383;
yy383:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy384;
yy384:  yych = *++YYCURSOR;
  if(yych != 'o') goto yy2;
  goto yy385;
yy385:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy386;
yy386:  ++YYCURSOR;
  goto yy387;
yy387:
#line 650 "cpp.re"
{ RET(T_MSEXT_PP_REGION); }
#line 4279 "cpp_re.cpp"
yy388:  yych = *++YYCURSOR;
  if(yych == 'i') goto yy406;
  if(yych == 's') goto yy407;
  goto yy2;
yy389:  yych = *++YYCURSOR;
  if(yych == 'd') goto yy395;
  goto yy2;
yy390:  yych = *++YYCURSOR;
  if(yych != 'r') goto yy2;
  goto yy391;
yy391:  yych = *++YYCURSOR;
  if(yych != 'o') goto yy2;
  goto yy392;
yy392:  yych = *++YYCURSOR;
  if(yych != 'r') goto yy2;
  goto yy393;
yy393:  ++YYCURSOR;
  goto yy394;
yy394:
#line 645 "cpp.re"
{ RET(T_PP_ERROR); }
#line 4301 "cpp_re.cpp"
yy395:  yych = *++YYCURSOR;
  if(yych == 'i') goto yy396;
  if(yych == 'r') goto yy397;
  goto yy2;
yy396:  yych = *++YYCURSOR;
  if(yych == 'f') goto yy404;
  goto yy2;
yy397:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy398;
yy398:  yych = *++YYCURSOR;
  if(yych != 'g') goto yy2;
  goto yy399;
yy399:  yych = *++YYCURSOR;
  if(yych != 'i') goto yy2;
  goto yy400;
yy400:  yych = *++YYCURSOR;
  if(yych != 'o') goto yy2;
  goto yy401;
yy401:  yych = *++YYCURSOR;
  if(yych != 'n') goto yy2;
  goto yy402;
yy402:  ++YYCURSOR;
  goto yy403;
yy403:
#line 651 "cpp.re"
{ RET(T_MSEXT_PP_ENDREGION); }
#line 4329 "cpp_re.cpp"
yy404:  ++YYCURSOR;
  goto yy405;
yy405:
#line 641 "cpp.re"
{ RET(T_PP_ENDIF); }
#line 4335 "cpp_re.cpp"
yy406:  yych = *++YYCURSOR;
  if(yych == 'f') goto yy410;
  goto yy2;
yy407:  yych = *++YYCURSOR;
  if(yych != 'e') goto yy2;
  goto yy408;
yy408:  ++YYCURSOR;
  goto yy409;
yy409:
#line 639 "cpp.re"
{ RET(T_PP_ELSE); }
#line 4347 "cpp_re.cpp"
yy410:  ++YYCURSOR;
  goto yy411;
yy411:
#line 640 "cpp.re"
{ RET(T_PP_ELIF); }
#line 4353 "cpp_re.cpp"
yy412:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy413;
yy413:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy412;
    goto yy414;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy416;
    goto yy412;
  }
yy414:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy415;
yy415:  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy412;
    goto yy414;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych != '*') goto yy412;
    goto yy416;
  }
yy416:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  goto yy417;
yy417:  if(yych <= 0x1F){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy412;
    if(yych >= 0x0E)  goto yy2;
    goto yy418;
  } else {
    if(yych <= '*'){
      if(yych <= ')') goto yy412;
      goto yy416;
    } else {
      if(yych == '/') goto yy295;
      goto yy412;
    }
  }
yy418:  ++YYCURSOR;
  if(YYLIMIT == YYCURSOR) YYFILL(1);
  yych = *YYCURSOR;
  if(yych <= 0x0D){
    if(yych <= 0x08)  goto yy2;
    if(yych <= 0x0C)  goto yy412;
    goto yy414;
  } else {
    if(yych <= 0x1F)  goto yy2;
    if(yych == '*') goto yy416;
    goto yy412;
  }
yy419:  ++YYCURSOR;
  goto yy420;
yy420:
#line 522 "cpp.re"
{ 
            if (s->act_in_c99_mode) {
                --YYCURSOR;
                RET(T_COLON);
            }
            else {
                RET(T_COLON_COLON); 
            }
        }
#line 4423 "cpp_re.cpp"
yy421:  ++YYCURSOR;
  goto yy422;
yy422:
#line 506 "cpp.re"
{ RET(T_RIGHTBRACKET_ALT); }
#line 4429 "cpp_re.cpp"
yy423:  yyaccept = 14;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'h'){
    if(yych <= '$'){
      if(yych <= 0x09){
        if(yych >= 0x09)  goto yy296;
        goto yy424;
      } else {
        if(yych == ' ') goto yy296;
        goto yy424;
      }
    } else {
      if(yych <= '/'){
        if(yych <= '%') goto yy429;
        if(yych >= '/') goto yy296;
        goto yy424;
      } else {
        if(yych <= 'c') goto yy424;
        if(yych <= 'e') goto yy296;
        goto yy424;
      }
    }
  } else {
    if(yych <= 'q'){
      if(yych <= 'l'){
        if(yych <= 'i') goto yy296;
        if(yych >= 'l') goto yy296;
        goto yy424;
      } else {
        if(yych == 'p') goto yy296;
        goto yy424;
      }
    } else {
      if(yych <= 'u'){
        if(yych <= 'r') goto yy296;
        if(yych >= 'u') goto yy296;
        goto yy424;
      } else {
        if(yych == 'w') goto yy296;
        goto yy424;
      }
    }
  }
yy424:
#line 508 "cpp.re"
{ RET(T_POUND_ALT); }
#line 4476 "cpp_re.cpp"
yy425:  ++YYCURSOR;
  goto yy426;
yy426:
#line 567 "cpp.re"
{ RET(T_PERCENTASSIGN); }
#line 4482 "cpp_re.cpp"
yy427:  ++YYCURSOR;
  goto yy428;
yy428:
#line 500 "cpp.re"
{ RET(T_RIGHTBRACE_ALT); }
#line 4488 "cpp_re.cpp"
yy429:  yych = *++YYCURSOR;
  if(yych != ':') goto yy2;
  goto yy430;
yy430:  ++YYCURSOR;
  goto yy431;
yy431:
#line 514 "cpp.re"
{ RET(T_POUND_POUND_ALT); }
#line 4497 "cpp_re.cpp"
yy432:  ++YYCURSOR;
  goto yy433;
yy433:
#line 583 "cpp.re"
{ RET(T_LESSEQUAL); }
#line 4503 "cpp_re.cpp"
yy434:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy440;
  goto yy435;
yy435:
#line 576 "cpp.re"
{ RET(T_SHIFTLEFT); }
#line 4510 "cpp_re.cpp"
yy436:  ++YYCURSOR;
  goto yy437;
yy437:
#line 503 "cpp.re"
{ RET(T_LEFTBRACKET_ALT); }
#line 4516 "cpp_re.cpp"
yy438:  ++YYCURSOR;
  goto yy439;
yy439:
#line 497 "cpp.re"
{ RET(T_LEFTBRACE_ALT); }
#line 4522 "cpp_re.cpp"
yy440:  ++YYCURSOR;
  goto yy441;
yy441:
#line 579 "cpp.re"
{ RET(T_SHIFTLEFTASSIGN); }
#line 4528 "cpp_re.cpp"
yy442:  yych = *++YYCURSOR;
  switch(yych){
  case '!': goto yy455;
  case '\'':  goto yy453;
  case '(': goto yy447;
  case ')': goto yy449;
  case '-': goto yy457;
  case '/': goto yy459;
  case '<': goto yy443;
  case '=': goto yy451;
  case '>': goto yy445;
  default:  goto yy2;
  }
yy443:  ++YYCURSOR;
  goto yy444;
yy444:
#line 496 "cpp.re"
{ RET(T_LEFTBRACE_TRIGRAPH); }
#line 4547 "cpp_re.cpp"
yy445:  ++YYCURSOR;
  goto yy446;
yy446:
#line 499 "cpp.re"
{ RET(T_RIGHTBRACE_TRIGRAPH); }
#line 4553 "cpp_re.cpp"
yy447:  ++YYCURSOR;
  goto yy448;
yy448:
#line 502 "cpp.re"
{ RET(T_LEFTBRACKET_TRIGRAPH); }
#line 4559 "cpp_re.cpp"
yy449:  ++YYCURSOR;
  goto yy450;
yy450:
#line 505 "cpp.re"
{ RET(T_RIGHTBRACKET_TRIGRAPH); }
#line 4565 "cpp_re.cpp"
yy451:  yyaccept = 15;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'e'){
    if(yych <= '#'){
      if(yych <= 0x1F){
        if(yych == 0x09)  goto yy296;
        goto yy452;
      } else {
        if(yych <= ' ') goto yy296;
        if(yych >= '#') goto yy472;
        goto yy452;
      }
    } else {
      if(yych <= '>'){
        if(yych == '/') goto yy296;
        goto yy452;
      } else {
        if(yych <= '?') goto yy471;
        if(yych >= 'd') goto yy296;
        goto yy452;
      }
    }
  } else {
    if(yych <= 'p'){
      if(yych <= 'k'){
        if(yych == 'i') goto yy296;
        goto yy452;
      } else {
        if(yych <= 'l') goto yy296;
        if(yych >= 'p') goto yy296;
        goto yy452;
      }
    } else {
      if(yych <= 't'){
        if(yych == 'r') goto yy296;
        goto yy452;
      } else {
        if(yych == 'v') goto yy452;
        if(yych <= 'w') goto yy296;
        goto yy452;
      }
    }
  }
yy452:
#line 509 "cpp.re"
{ RET(T_POUND_TRIGRAPH); }
#line 4612 "cpp_re.cpp"
yy453:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '=') goto yy469;
  goto yy454;
yy454:
#line 548 "cpp.re"
{ RET(T_XOR_TRIGRAPH); }
#line 4619 "cpp_re.cpp"
yy455:  yyaccept = 16;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '>'){
    if(yych == '=') goto yy464;
    goto yy456;
  } else {
    if(yych <= '?') goto yy461;
    if(yych == '|') goto yy462;
    goto yy456;
  }
yy456:
#line 554 "cpp.re"
{ RET(T_OR_TRIGRAPH); }
#line 4633 "cpp_re.cpp"
yy457:  ++YYCURSOR;
  goto yy458;
yy458:
#line 556 "cpp.re"
{ RET(T_COMPL_TRIGRAPH); }
#line 4639 "cpp_re.cpp"
yy459:  yyaccept = 17;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'U') goto yy216;
  if(yych == 'u') goto yy215;
  goto yy460;
yy460:
#line 606 "cpp.re"
{ RET(T_ANY_TRIGRAPH); }
#line 4648 "cpp_re.cpp"
yy461:  yych = *++YYCURSOR;
  if(yych == '?') goto yy466;
  goto yy2;
yy462:  ++YYCURSOR;
  goto yy463;
yy463:
#line 588 "cpp.re"
{ RET(T_OROR_TRIGRAPH); }
#line 4657 "cpp_re.cpp"
yy464:  ++YYCURSOR;
  goto yy465;
yy465:
#line 575 "cpp.re"
{ RET(T_ORASSIGN_TRIGRAPH); }
#line 4663 "cpp_re.cpp"
yy466:  yych = *++YYCURSOR;
  if(yych != '!') goto yy2;
  goto yy467;
yy467:  ++YYCURSOR;
  goto yy468;
yy468:
#line 591 "cpp.re"
{ RET(T_OROR_TRIGRAPH); }
#line 4672 "cpp_re.cpp"
yy469:  ++YYCURSOR;
  goto yy470;
yy470:
#line 570 "cpp.re"
{ RET(T_XORASSIGN_TRIGRAPH); }
#line 4678 "cpp_re.cpp"
yy471:  yych = *++YYCURSOR;
  if(yych == '?') goto yy474;
  goto yy2;
yy472:  ++YYCURSOR;
  goto yy473;
yy473:
#line 512 "cpp.re"
{ RET(T_POUND_POUND_TRIGRAPH); }
#line 4687 "cpp_re.cpp"
yy474:  yych = *++YYCURSOR;
  if(yych != '=') goto yy2;
  goto yy475;
yy475:  ++YYCURSOR;
  goto yy476;
yy476:
#line 513 "cpp.re"
{ RET(T_POUND_POUND_TRIGRAPH); }
#line 4696 "cpp_re.cpp"
yy477:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  switch(yych){
  case 'a': goto yy478;
  case 'b': goto yy479;
  case 'c': goto yy480;
  case 'd': goto yy481;
  case 'e': goto yy530;
  case 'f': goto yy528;
  case 'i': goto yy527;
  case 'l': goto yy531;
  case 's': goto yy484;
  case 't': goto yy529;
  default:  goto yy225;
  }
yy478:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 's') goto yy524;
  goto yy225;
yy479:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy519;
  goto yy225;
yy480:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy514;
  goto yy225;
yy481:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy506;
  goto yy225;
yy482:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy498;
  goto yy225;
yy483:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy492;
  goto yy225;
yy484:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy485;
yy485:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy486;
yy486:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy487;
yy487:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy488;
yy488:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy489;
yy489:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy490;
yy490:  yyaccept = 18;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy491;
      if(yych <= '9') goto yy224;
      goto yy491;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy491;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy491;
    } else {
      if(yych == '`') goto yy491;
      if(yych <= 'z') goto yy224;
      goto yy491;
    }
  }
yy491:
#line 487 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_STDCALL : T_IDENTIFIER); }
#line 4785 "cpp_re.cpp"
yy492:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy493;
yy493:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy494;
yy494:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy495;
yy495:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy496;
yy496:  yyaccept = 19;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy497;
      if(yych <= '9') goto yy224;
      goto yy497;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy497;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy497;
    } else {
      if(yych == '`') goto yy497;
      if(yych <= 'z') goto yy224;
      goto yy497;
    }
  }
yy497:
#line 492 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_INLINE : T_IDENTIFIER); }
#line 4827 "cpp_re.cpp"
yy498:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy499;
yy499:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy500;
yy500:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy501;
yy501:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy502;
yy502:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy503;
yy503:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy504;
yy504:  yyaccept = 20;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy505;
      if(yych <= '9') goto yy224;
      goto yy505;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy505;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy505;
    } else {
      if(yych == '`') goto yy505;
      if(yych <= 'z') goto yy224;
      goto yy505;
    }
  }
yy505:
#line 486 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_FASTCALL : T_IDENTIFIER); }
#line 4877 "cpp_re.cpp"
yy506:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy507;
yy507:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy508;
yy508:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy509;
yy509:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy510;
yy510:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy511;
yy511:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy512;
yy512:  yyaccept = 21;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy513;
      if(yych <= '9') goto yy224;
      goto yy513;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy513;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy513;
    } else {
      if(yych == '`') goto yy513;
      if(yych <= 'z') goto yy224;
      goto yy513;
    }
  }
yy513:
#line 484 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_DECLSPEC : T_IDENTIFIER); }
#line 4927 "cpp_re.cpp"
yy514:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy515;
yy515:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy516;
yy516:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy517;
yy517:  yyaccept = 22;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy518;
      if(yych <= '9') goto yy224;
      goto yy518;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy518;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy518;
    } else {
      if(yych == '`') goto yy518;
      if(yych <= 'z') goto yy224;
      goto yy518;
    }
  }
yy518:
#line 485 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_CDECL : T_IDENTIFIER); }
#line 4965 "cpp_re.cpp"
yy519:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy520;
yy520:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy521;
yy521:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy522;
yy522:  yyaccept = 23;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy523;
      if(yych <= '9') goto yy224;
      goto yy523;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy523;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy523;
    } else {
      if(yych == '`') goto yy523;
      if(yych <= 'z') goto yy224;
      goto yy523;
    }
  }
yy523:
#line 483 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_BASED : T_IDENTIFIER); }
#line 5003 "cpp_re.cpp"
yy524:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'm') goto yy225;
  goto yy525;
yy525:  yyaccept = 24;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy526;
      if(yych <= '9') goto yy224;
      goto yy526;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy526;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy526;
    } else {
      if(yych == '`') goto yy526;
      if(yych <= 'z') goto yy224;
      goto yy526;
    }
  }
yy526:
#line 493 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_ASM : T_IDENTIFIER); }
#line 5033 "cpp_re.cpp"
yy527:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy553;
  goto yy225;
yy528:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy498;
  if(yych == 'i') goto yy546;
  goto yy225;
yy529:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'r') goto yy543;
  goto yy225;
yy530:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'x') goto yy537;
  goto yy225;
yy531:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy532;
yy532:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy533;
yy533:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'v') goto yy225;
  goto yy534;
yy534:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy535;
yy535:  yyaccept = 25;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy536;
      if(yych <= '9') goto yy224;
      goto yy536;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy536;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy536;
    } else {
      if(yych == '`') goto yy536;
      if(yych <= 'z') goto yy224;
      goto yy536;
    }
  }
yy536:
#line 491 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_LEAVE : T_IDENTIFIER); }
#line 5092 "cpp_re.cpp"
yy537:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy538;
yy538:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy539;
yy539:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy540;
yy540:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy541;
yy541:  yyaccept = 26;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy542;
      if(yych <= '9') goto yy224;
      goto yy542;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy542;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy542;
    } else {
      if(yych == '`') goto yy542;
      if(yych <= 'z') goto yy224;
      goto yy542;
    }
  }
yy542:
#line 489 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_EXCEPT : T_IDENTIFIER); }
#line 5134 "cpp_re.cpp"
yy543:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'y') goto yy225;
  goto yy544;
yy544:  yyaccept = 27;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy545;
      if(yych <= '9') goto yy224;
      goto yy545;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy545;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy545;
    } else {
      if(yych == '`') goto yy545;
      if(yych <= 'z') goto yy224;
      goto yy545;
    }
  }
yy545:
#line 488 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_TRY : T_IDENTIFIER); }
#line 5164 "cpp_re.cpp"
yy546:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy547;
yy547:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy548;
yy548:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy549;
yy549:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy550;
yy550:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'y') goto yy225;
  goto yy551;
yy551:  yyaccept = 28;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy552;
      if(yych <= '9') goto yy224;
      goto yy552;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy552;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy552;
    } else {
      if(yych == '`') goto yy552;
      if(yych <= 'z') goto yy224;
      goto yy552;
    }
  }
yy552:
#line 490 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_FINALLY : T_IDENTIFIER); }
#line 5210 "cpp_re.cpp"
yy553:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'l') goto yy493;
  if(yych != 't') goto yy225;
  goto yy554;
yy554:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  switch(yych){
  case '1': goto yy555;
  case '3': goto yy556;
  case '6': goto yy557;
  case '8': goto yy558;
  default:  goto yy225;
  }
yy555:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '6') goto yy564;
  goto yy225;
yy556:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '2') goto yy562;
  goto yy225;
yy557:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == '4') goto yy560;
  goto yy225;
yy558:  yyaccept = 29;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy559;
      if(yych <= '9') goto yy224;
      goto yy559;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy559;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy559;
    } else {
      if(yych == '`') goto yy559;
      if(yych <= 'z') goto yy224;
      goto yy559;
    }
  }
yy559:
#line 479 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_INT8 : T_IDENTIFIER); }
#line 5262 "cpp_re.cpp"
yy560:  yyaccept = 30;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy561;
      if(yych <= '9') goto yy224;
      goto yy561;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy561;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy561;
    } else {
      if(yych == '`') goto yy561;
      if(yych <= 'z') goto yy224;
      goto yy561;
    }
  }
yy561:
#line 482 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_INT64 : T_IDENTIFIER); }
#line 5288 "cpp_re.cpp"
yy562:  yyaccept = 31;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy563;
      if(yych <= '9') goto yy224;
      goto yy563;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy563;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy563;
    } else {
      if(yych == '`') goto yy563;
      if(yych <= 'z') goto yy224;
      goto yy563;
    }
  }
yy563:
#line 481 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_INT32 : T_IDENTIFIER); }
#line 5314 "cpp_re.cpp"
yy564:  yyaccept = 32;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy565;
      if(yych <= '9') goto yy224;
      goto yy565;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy565;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy565;
    } else {
      if(yych == '`') goto yy565;
      if(yych <= 'z') goto yy224;
      goto yy565;
    }
  }
yy565:
#line 480 "cpp.re"
{ RET(s->enable_ms_extensions ? T_MSEXT_INT16 : T_IDENTIFIER); }
#line 5340 "cpp_re.cpp"
yy566:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'h') goto yy572;
  goto yy225;
yy567:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy568;
yy568:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy569;
yy569:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy570;
yy570:  yyaccept = 33;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy571;
      if(yych <= '9') goto yy224;
      goto yy571;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy571;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy571;
    } else {
      if(yych == '`') goto yy571;
      if(yych <= 'z') goto yy224;
      goto yy571;
    }
  }
yy571:
#line 477 "cpp.re"
{ RET(T_WHILE); }
#line 5382 "cpp_re.cpp"
yy572:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy573;
yy573:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy574;
yy574:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != '_') goto yy225;
  goto yy575;
yy575:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy576;
yy576:  yyaccept = 34;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy577;
      if(yych <= '9') goto yy224;
      goto yy577;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy577;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy577;
    } else {
      if(yych == '`') goto yy577;
      if(yych <= 'z') goto yy224;
      goto yy577;
    }
  }
yy577:
#line 476 "cpp.re"
{ RET(T_WCHART); }
#line 5424 "cpp_re.cpp"
yy578:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'r') goto yy590;
  goto yy225;
yy579:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy580;
  if(yych == 'l') goto yy581;
  goto yy225;
yy580:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy588;
  goto yy225;
yy581:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy582;
yy582:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy583;
yy583:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy584;
yy584:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy585;
yy585:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy586;
yy586:  yyaccept = 35;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy587;
      if(yych <= '9') goto yy224;
      goto yy587;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy587;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy587;
    } else {
      if(yych == '`') goto yy587;
      if(yych <= 'z') goto yy224;
      goto yy587;
    }
  }
yy587:
#line 475 "cpp.re"
{ RET(T_VOLATILE); }
#line 5483 "cpp_re.cpp"
yy588:  yyaccept = 36;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy589;
      if(yych <= '9') goto yy224;
      goto yy589;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy589;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy589;
    } else {
      if(yych == '`') goto yy589;
      if(yych <= 'z') goto yy224;
      goto yy589;
    }
  }
yy589:
#line 474 "cpp.re"
{ RET(T_VOID); }
#line 5509 "cpp_re.cpp"
yy590:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy591;
yy591:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'u') goto yy225;
  goto yy592;
yy592:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy593;
yy593:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy594;
yy594:  yyaccept = 37;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy595;
      if(yych <= '9') goto yy224;
      goto yy595;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy595;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy595;
    } else {
      if(yych == '`') goto yy595;
      if(yych <= 'z') goto yy224;
      goto yy595;
    }
  }
yy595:
#line 473 "cpp.re"
{ RET(T_VIRTUAL); }
#line 5551 "cpp_re.cpp"
yy596:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy602;
  if(yych == 's') goto yy603;
  goto yy225;
yy597:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy598;
yy598:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy599;
yy599:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'g') goto yy225;
  goto yy600;
yy600:  yyaccept = 38;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy601;
      if(yych <= '9') goto yy224;
      goto yy601;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy601;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy601;
    } else {
      if(yych == '`') goto yy601;
      if(yych <= 'z') goto yy224;
      goto yy601;
    }
  }
yy601:
#line 472 "cpp.re"
{ RET(T_USING); }
#line 5594 "cpp_re.cpp"
yy602:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy610;
  goto yy225;
yy603:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy604;
yy604:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'g') goto yy225;
  goto yy605;
yy605:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy606;
yy606:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy607;
yy607:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy608;
yy608:  yyaccept = 39;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy609;
      if(yych <= '9') goto yy224;
      goto yy609;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy609;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy609;
    } else {
      if(yych == '`') goto yy609;
      if(yych <= 'z') goto yy224;
      goto yy609;
    }
  }
yy609:
#line 471 "cpp.re"
{ RET(T_UNSIGNED); }
#line 5644 "cpp_re.cpp"
yy610:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy611;
yy611:  yyaccept = 40;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy612;
      if(yych <= '9') goto yy224;
      goto yy612;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy612;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy612;
    } else {
      if(yych == '`') goto yy612;
      if(yych <= 'z') goto yy224;
      goto yy612;
    }
  }
yy612:
#line 470 "cpp.re"
{ RET(T_UNION); }
#line 5674 "cpp_re.cpp"
yy613:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'm') goto yy643;
  goto yy225;
yy614:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy636;
  if(yych == 'r') goto yy637;
  goto yy225;
yy615:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'u') goto yy631;
  if(yych == 'y') goto yy632;
  goto yy225;
yy616:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy617;
yy617:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy618;
yy618:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'h'){
    if(yych != 'd') goto yy225;
    goto yy619;
  } else {
    if(yych <= 'i') goto yy620;
    if(yych == 'n') goto yy621;
    goto yy225;
  }
yy619:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy628;
  goto yy225;
yy620:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy626;
  goto yy225;
yy621:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy622;
yy622:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'm') goto yy225;
  goto yy623;
yy623:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy624;
yy624:  yyaccept = 41;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy625;
      if(yych <= '9') goto yy224;
      goto yy625;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy625;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy625;
    } else {
      if(yych == '`') goto yy625;
      if(yych <= 'z') goto yy224;
      goto yy625;
    }
  }
yy625:
#line 469 "cpp.re"
{ RET(T_TYPENAME); }
#line 5752 "cpp_re.cpp"
yy626:  yyaccept = 42;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy627;
      if(yych <= '9') goto yy224;
      goto yy627;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy627;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy627;
    } else {
      if(yych == '`') goto yy627;
      if(yych <= 'z') goto yy224;
      goto yy627;
    }
  }
yy627:
#line 468 "cpp.re"
{ RET(T_TYPEID); }
#line 5778 "cpp_re.cpp"
yy628:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'f') goto yy225;
  goto yy629;
yy629:  yyaccept = 43;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy630;
      if(yych <= '9') goto yy224;
      goto yy630;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy630;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy630;
    } else {
      if(yych == '`') goto yy630;
      if(yych <= 'z') goto yy224;
      goto yy630;
    }
  }
yy630:
#line 467 "cpp.re"
{ RET(T_TYPEDEF); }
#line 5808 "cpp_re.cpp"
yy631:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy634;
  goto yy225;
yy632:  yyaccept = 44;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy633;
      if(yych <= '9') goto yy224;
      goto yy633;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy633;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy633;
    } else {
      if(yych == '`') goto yy633;
      if(yych <= 'z') goto yy224;
      goto yy633;
    }
  }
yy633:
#line 466 "cpp.re"
{ RET(T_TRY); }
#line 5838 "cpp_re.cpp"
yy634:  yyaccept = 45;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy635;
      if(yych <= '9') goto yy224;
      goto yy635;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy635;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy635;
    } else {
      if(yych == '`') goto yy635;
      if(yych <= 'z') goto yy224;
      goto yy635;
    }
  }
yy635:
#line 465 "cpp.re"
{ RET(T_TRUE); }
#line 5864 "cpp_re.cpp"
yy636:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 's') goto yy641;
  goto yy225;
yy637:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'o') goto yy225;
  goto yy638;
yy638:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'w') goto yy225;
  goto yy639;
yy639:  yyaccept = 46;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy640;
      if(yych <= '9') goto yy224;
      goto yy640;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy640;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy640;
    } else {
      if(yych == '`') goto yy640;
      if(yych <= 'z') goto yy224;
      goto yy640;
    }
  }
yy640:
#line 464 "cpp.re"
{ RET(T_THROW); }
#line 5902 "cpp_re.cpp"
yy641:  yyaccept = 47;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy642;
      if(yych <= '9') goto yy224;
      goto yy642;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy642;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy642;
    } else {
      if(yych == '`') goto yy642;
      if(yych <= 'z') goto yy224;
      goto yy642;
    }
  }
yy642:
#line 463 "cpp.re"
{ RET(T_THIS); }
#line 5928 "cpp_re.cpp"
yy643:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy644;
yy644:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy645;
yy645:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy646;
yy646:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy647;
yy647:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy648;
yy648:  yyaccept = 48;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy649;
      if(yych <= '9') goto yy224;
      goto yy649;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy649;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy649;
    } else {
      if(yych == '`') goto yy649;
      if(yych <= 'z') goto yy224;
      goto yy649;
    }
  }
yy649:
#line 462 "cpp.re"
{ RET(T_TEMPLATE); }
#line 5974 "cpp_re.cpp"
yy650:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy685;
  goto yy225;
yy651:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'g') goto yy675;
  if(yych == 'z') goto yy676;
  goto yy225;
yy652:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy659;
  if(yych == 'r') goto yy660;
  goto yy225;
yy653:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy654;
yy654:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy655;
yy655:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy656;
yy656:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'h') goto yy225;
  goto yy657;
yy657:  yyaccept = 49;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy658;
      if(yych <= '9') goto yy224;
      goto yy658;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy658;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy658;
    } else {
      if(yych == '`') goto yy658;
      if(yych <= 'z') goto yy224;
      goto yy658;
    }
  }
yy658:
#line 461 "cpp.re"
{ RET(T_SWITCH); }
#line 6030 "cpp_re.cpp"
yy659:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 't') goto yy665;
  goto yy225;
yy660:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'u') goto yy225;
  goto yy661;
yy661:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy662;
yy662:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy663;
yy663:  yyaccept = 50;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy664;
      if(yych <= '9') goto yy224;
      goto yy664;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy664;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy664;
    } else {
      if(yych == '`') goto yy664;
      if(yych <= 'z') goto yy224;
      goto yy664;
    }
  }
yy664:
#line 460 "cpp.re"
{ RET(T_STRUCT); }
#line 6072 "cpp_re.cpp"
yy665:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy666;
yy666:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy667;
yy667:  yyaccept = 51;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy668;
      if(yych <= '9') goto yy224;
      goto yy668;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy668;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy668;
    } else {
      if(yych <= '_') goto yy669;
      if(yych <= '`') goto yy668;
      if(yych <= 'z') goto yy224;
      goto yy668;
    }
  }
yy668:
#line 458 "cpp.re"
{ RET(T_STATIC); }
#line 6107 "cpp_re.cpp"
yy669:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy670;
yy670:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy671;
yy671:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy672;
yy672:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy673;
yy673:  yyaccept = 52;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy674;
      if(yych <= '9') goto yy224;
      goto yy674;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy674;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy674;
    } else {
      if(yych == '`') goto yy674;
      if(yych <= 'z') goto yy224;
      goto yy674;
    }
  }
yy674:
#line 459 "cpp.re"
{ RET(T_STATICCAST); }
#line 6149 "cpp_re.cpp"
yy675:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy681;
  goto yy225;
yy676:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy677;
yy677:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'o') goto yy225;
  goto yy678;
yy678:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'f') goto yy225;
  goto yy679;
yy679:  yyaccept = 53;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy680;
      if(yych <= '9') goto yy224;
      goto yy680;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy680;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy680;
    } else {
      if(yych == '`') goto yy680;
      if(yych <= 'z') goto yy224;
      goto yy680;
    }
  }
yy680:
#line 457 "cpp.re"
{ RET(T_SIZEOF); }
#line 6191 "cpp_re.cpp"
yy681:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy682;
yy682:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy683;
yy683:  yyaccept = 54;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy684;
      if(yych <= '9') goto yy224;
      goto yy684;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy684;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy684;
    } else {
      if(yych == '`') goto yy684;
      if(yych <= 'z') goto yy224;
      goto yy684;
    }
  }
yy684:
#line 456 "cpp.re"
{ RET(T_SIGNED); }
#line 6225 "cpp_re.cpp"
yy685:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy686;
yy686:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy687;
yy687:  yyaccept = 55;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy688;
      if(yych <= '9') goto yy224;
      goto yy688;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy688;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy688;
    } else {
      if(yych == '`') goto yy688;
      if(yych <= 'z') goto yy224;
      goto yy688;
    }
  }
yy688:
#line 455 "cpp.re"
{ RET(T_SHORT); }
#line 6259 "cpp_re.cpp"
yy689:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'h'){
    if(yych != 'g') goto yy225;
    goto yy690;
  } else {
    if(yych <= 'i') goto yy691;
    if(yych == 't') goto yy692;
    goto yy225;
  }
yy690:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy711;
  goto yy225;
yy691:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy697;
  goto yy225;
yy692:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'u') goto yy225;
  goto yy693;
yy693:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy694;
yy694:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy695;
yy695:  yyaccept = 56;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy696;
      if(yych <= '9') goto yy224;
      goto yy696;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy696;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy696;
    } else {
      if(yych == '`') goto yy696;
      if(yych <= 'z') goto yy224;
      goto yy696;
    }
  }
yy696:
#line 454 "cpp.re"
{ RET(T_RETURN); }
#line 6315 "cpp_re.cpp"
yy697:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy698;
yy698:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy699;
yy699:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy700;
yy700:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy701;
yy701:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy702;
yy702:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy703;
yy703:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy704;
yy704:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != '_') goto yy225;
  goto yy705;
yy705:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy706;
yy706:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy707;
yy707:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy708;
yy708:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy709;
yy709:  yyaccept = 57;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy710;
      if(yych <= '9') goto yy224;
      goto yy710;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy710;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy710;
    } else {
      if(yych == '`') goto yy710;
      if(yych <= 'z') goto yy224;
      goto yy710;
    }
  }
yy710:
#line 453 "cpp.re"
{ RET(T_REINTERPRETCAST); }
#line 6389 "cpp_re.cpp"
yy711:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy712;
yy712:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy713;
yy713:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy714;
yy714:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy715;
yy715:  yyaccept = 58;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy716;
      if(yych <= '9') goto yy224;
      goto yy716;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy716;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy716;
    } else {
      if(yych == '`') goto yy716;
      if(yych <= 'z') goto yy224;
      goto yy716;
    }
  }
yy716:
#line 452 "cpp.re"
{ RET(T_REGISTER); }
#line 6431 "cpp_re.cpp"
yy717:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy724;
  if(yych == 'o') goto yy725;
  goto yy225;
yy718:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'b') goto yy225;
  goto yy719;
yy719:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy720;
yy720:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy721;
yy721:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy722;
yy722:  yyaccept = 59;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy723;
      if(yych <= '9') goto yy224;
      goto yy723;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy723;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy723;
    } else {
      if(yych == '`') goto yy723;
      if(yych <= 'z') goto yy224;
      goto yy723;
    }
  }
yy723:
#line 451 "cpp.re"
{ RET(T_PUBLIC); }
#line 6478 "cpp_re.cpp"
yy724:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'v') goto yy733;
  goto yy225;
yy725:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy726;
yy726:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy727;
yy727:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy728;
yy728:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy729;
yy729:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy730;
yy730:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy731;
yy731:  yyaccept = 60;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy732;
      if(yych <= '9') goto yy224;
      goto yy732;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy732;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy732;
    } else {
      if(yych == '`') goto yy732;
      if(yych <= 'z') goto yy224;
      goto yy732;
    }
  }
yy732:
#line 450 "cpp.re"
{ RET(T_PROTECTED); }
#line 6532 "cpp_re.cpp"
yy733:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy734;
yy734:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy735;
yy735:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy736;
yy736:  yyaccept = 61;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy737;
      if(yych <= '9') goto yy224;
      goto yy737;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy737;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy737;
    } else {
      if(yych == '`') goto yy737;
      if(yych <= 'z') goto yy224;
      goto yy737;
    }
  }
yy737:
#line 449 "cpp.re"
{ RET(T_PRIVATE); }
#line 6570 "cpp_re.cpp"
yy738:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy745;
  goto yy225;
yy739:  yyaccept = 62;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy740;
      if(yych <= '9') goto yy224;
      goto yy740;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy740;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy740;
    } else {
      if(yych <= '_') goto yy741;
      if(yych <= '`') goto yy740;
      if(yych <= 'z') goto yy224;
      goto yy740;
    }
  }
yy740:
#line 590 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_OROR_ALT); }
#line 6601 "cpp_re.cpp"
yy741:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy742;
yy742:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'q') goto yy225;
  goto yy743;
yy743:  yyaccept = 63;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy744;
      if(yych <= '9') goto yy224;
      goto yy744;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy744;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy744;
    } else {
      if(yych == '`') goto yy744;
      if(yych <= 'z') goto yy224;
      goto yy744;
    }
  }
yy744:
#line 574 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_ORASSIGN_ALT); }
#line 6635 "cpp_re.cpp"
yy745:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy746;
yy746:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy747;
yy747:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy748;
yy748:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'o') goto yy225;
  goto yy749;
yy749:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy750;
yy750:  yyaccept = 64;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy751;
      if(yych <= '9') goto yy224;
      goto yy751;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy751;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy751;
    } else {
      if(yych == '`') goto yy751;
      if(yych <= 'z') goto yy224;
      goto yy751;
    }
  }
yy751:
#line 448 "cpp.re"
{ RET(T_OPERATOR); }
#line 6681 "cpp_re.cpp"
yy752:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'm') goto yy763;
  goto yy225;
yy753:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'w') goto yy761;
  goto yy225;
yy754:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy755;
yy755:  yyaccept = 65;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy756;
      if(yych <= '9') goto yy224;
      goto yy756;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy756;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy756;
    } else {
      if(yych <= '_') goto yy757;
      if(yych <= '`') goto yy756;
      if(yych <= 'z') goto yy224;
      goto yy756;
    }
  }
yy756:
#line 559 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_NOT_ALT); }
#line 6720 "cpp_re.cpp"
yy757:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy758;
yy758:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'q') goto yy225;
  goto yy759;
yy759:  yyaccept = 66;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy760;
      if(yych <= '9') goto yy224;
      goto yy760;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy760;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy760;
    } else {
      if(yych == '`') goto yy760;
      if(yych <= 'z') goto yy224;
      goto yy760;
    }
  }
yy760:
#line 582 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_NOTEQUAL_ALT); }
#line 6754 "cpp_re.cpp"
yy761:  yyaccept = 67;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy762;
      if(yych <= '9') goto yy224;
      goto yy762;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy762;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy762;
    } else {
      if(yych == '`') goto yy762;
      if(yych <= 'z') goto yy224;
      goto yy762;
    }
  }
yy762:
#line 447 "cpp.re"
{ RET(T_NEW); }
#line 6780 "cpp_re.cpp"
yy763:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy764;
yy764:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy765;
yy765:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy766;
yy766:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy767;
yy767:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy768;
yy768:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy769;
yy769:  yyaccept = 68;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy770;
      if(yych <= '9') goto yy224;
      goto yy770;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy770;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy770;
    } else {
      if(yych == '`') goto yy770;
      if(yych <= 'z') goto yy224;
      goto yy770;
    }
  }
yy770:
#line 446 "cpp.re"
{ RET(T_NAMESPACE); }
#line 6830 "cpp_re.cpp"
yy771:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy772;
yy772:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy773;
yy773:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'b') goto yy225;
  goto yy774;
yy774:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy775;
yy775:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy776;
yy776:  yyaccept = 69;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy777;
      if(yych <= '9') goto yy224;
      goto yy777;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy777;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy777;
    } else {
      if(yych == '`') goto yy777;
      if(yych <= 'z') goto yy224;
      goto yy777;
    }
  }
yy777:
#line 445 "cpp.re"
{ RET(T_MUTABLE); }
#line 6876 "cpp_re.cpp"
yy778:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy779;
yy779:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'g') goto yy225;
  goto yy780;
yy780:  yyaccept = 70;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy781;
      if(yych <= '9') goto yy224;
      goto yy781;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy781;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy781;
    } else {
      if(yych == '`') goto yy781;
      if(yych <= 'z') goto yy224;
      goto yy781;
    }
  }
yy781:
#line 444 "cpp.re"
{ RET(T_LONG); }
#line 6910 "cpp_re.cpp"
yy782:  yyaccept = 71;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy783;
      if(yych <= '9') goto yy224;
      goto yy783;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy783;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy783;
    } else {
      if(yych == '`') goto yy783;
      if(yych <= 'z') goto yy224;
      goto yy783;
    }
  }
yy783:
#line 441 "cpp.re"
{ RET(T_IF); }
#line 6936 "cpp_re.cpp"
yy784:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'l') goto yy785;
  if(yych == 't') goto yy786;
  goto yy225;
yy785:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy788;
  goto yy225;
yy786:  yyaccept = 72;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy787;
      if(yych <= '9') goto yy224;
      goto yy787;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy787;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy787;
    } else {
      if(yych == '`') goto yy787;
      if(yych <= 'z') goto yy224;
      goto yy787;
    }
  }
yy787:
#line 443 "cpp.re"
{ RET(T_INT); }
#line 6971 "cpp_re.cpp"
yy788:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy789;
yy789:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy790;
yy790:  yyaccept = 73;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy791;
      if(yych <= '9') goto yy224;
      goto yy791;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy791;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy791;
    } else {
      if(yych == '`') goto yy791;
      if(yych <= 'z') goto yy224;
      goto yy791;
    }
  }
yy791:
#line 442 "cpp.re"
{ RET(T_INLINE); }
#line 7005 "cpp_re.cpp"
yy792:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy793;
yy793:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'o') goto yy225;
  goto yy794;
yy794:  yyaccept = 74;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy795;
      if(yych <= '9') goto yy224;
      goto yy795;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy795;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy795;
    } else {
      if(yych == '`') goto yy795;
      if(yych <= 'z') goto yy224;
      goto yy795;
    }
  }
yy795:
#line 440 "cpp.re"
{ RET(T_GOTO); }
#line 7039 "cpp_re.cpp"
yy796:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'l') goto yy811;
  goto yy225;
yy797:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy807;
  goto yy225;
yy798:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'r') goto yy805;
  goto yy225;
yy799:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy800;
yy800:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy801;
yy801:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy802;
yy802:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy803;
yy803:  yyaccept = 75;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy804;
      if(yych <= '9') goto yy224;
      goto yy804;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy804;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy804;
    } else {
      if(yych == '`') goto yy804;
      if(yych <= 'z') goto yy224;
      goto yy804;
    }
  }
yy804:
#line 439 "cpp.re"
{ RET(T_FRIEND); }
#line 7093 "cpp_re.cpp"
yy805:  yyaccept = 76;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy806;
      if(yych <= '9') goto yy224;
      goto yy806;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy806;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy806;
    } else {
      if(yych == '`') goto yy806;
      if(yych <= 'z') goto yy224;
      goto yy806;
    }
  }
yy806:
#line 438 "cpp.re"
{ RET(T_FOR); }
#line 7119 "cpp_re.cpp"
yy807:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy808;
yy808:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy809;
yy809:  yyaccept = 77;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy810;
      if(yych <= '9') goto yy224;
      goto yy810;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy810;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy810;
    } else {
      if(yych == '`') goto yy810;
      if(yych <= 'z') goto yy224;
      goto yy810;
    }
  }
yy810:
#line 437 "cpp.re"
{ RET(T_FLOAT); }
#line 7153 "cpp_re.cpp"
yy811:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy812;
yy812:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy813;
yy813:  yyaccept = 78;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy814;
      if(yych <= '9') goto yy224;
      goto yy814;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy814;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy814;
    } else {
      if(yych == '`') goto yy814;
      if(yych <= 'z') goto yy224;
      goto yy814;
    }
  }
yy814:
#line 436 "cpp.re"
{ RET(T_FALSE); }
#line 7187 "cpp_re.cpp"
yy815:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 's') goto yy837;
  goto yy225;
yy816:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'u') goto yy834;
  goto yy225;
yy817:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'p') goto yy818;
  if(yych == 't') goto yy819;
  goto yy225;
yy818:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'l') goto yy824;
  if(yych == 'o') goto yy825;
  goto yy225;
yy819:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy820;
yy820:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy821;
yy821:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy822;
yy822:  yyaccept = 79;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy823;
      if(yych <= '9') goto yy224;
      goto yy823;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy823;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy823;
    } else {
      if(yych == '`') goto yy823;
      if(yych <= 'z') goto yy224;
      goto yy823;
    }
  }
yy823:
#line 435 "cpp.re"
{ RET(T_EXTERN); }
#line 7243 "cpp_re.cpp"
yy824:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'i') goto yy829;
  goto yy225;
yy825:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy826;
yy826:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy827;
yy827:  yyaccept = 80;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy828;
      if(yych <= '9') goto yy224;
      goto yy828;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy828;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy828;
    } else {
      if(yych == '`') goto yy828;
      if(yych <= 'z') goto yy224;
      goto yy828;
    }
  }
yy828:
#line 434 "cpp.re"
{ RET(T_EXPORT); }
#line 7281 "cpp_re.cpp"
yy829:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy830;
yy830:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy831;
yy831:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy832;
yy832:  yyaccept = 81;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy833;
      if(yych <= '9') goto yy224;
      goto yy833;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy833;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy833;
    } else {
      if(yych == '`') goto yy833;
      if(yych <= 'z') goto yy224;
      goto yy833;
    }
  }
yy833:
#line 433 "cpp.re"
{ RET(T_EXPLICIT); }
#line 7319 "cpp_re.cpp"
yy834:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'm') goto yy225;
  goto yy835;
yy835:  yyaccept = 82;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy836;
      if(yych <= '9') goto yy224;
      goto yy836;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy836;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy836;
    } else {
      if(yych == '`') goto yy836;
      if(yych <= 'z') goto yy224;
      goto yy836;
    }
  }
yy836:
#line 432 "cpp.re"
{ RET(T_ENUM); }
#line 7349 "cpp_re.cpp"
yy837:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy838;
yy838:  yyaccept = 83;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy839;
      if(yych <= '9') goto yy224;
      goto yy839;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy839;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy839;
    } else {
      if(yych == '`') goto yy839;
      if(yych <= 'z') goto yy224;
      goto yy839;
    }
  }
yy839:
#line 431 "cpp.re"
{ RET(T_ELSE); }
#line 7379 "cpp_re.cpp"
yy840:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'f') goto yy860;
  if(yych == 'l') goto yy861;
  goto yy225;
yy841:  yyaccept = 84;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= '['){
    if(yych <= '>'){
      if(yych <= '/') goto yy842;
      if(yych <= '9') goto yy224;
      goto yy842;
    } else {
      if(yych <= '?') goto yy227;
      if(yych <= '@') goto yy842;
      if(yych <= 'Z') goto yy224;
      goto yy842;
    }
  } else {
    if(yych <= '`'){
      if(yych <= '\\')  goto yy226;
      if(yych == '_') goto yy224;
      goto yy842;
    } else {
      if(yych == 'u') goto yy855;
      if(yych <= 'z') goto yy224;
      goto yy842;
    }
  }
yy842:
#line 428 "cpp.re"
{ RET(T_DO); }
#line 7412 "cpp_re.cpp"
yy843:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy844;
yy844:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy845;
yy845:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'm') goto yy225;
  goto yy846;
yy846:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy847;
yy847:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy848;
yy848:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != '_') goto yy225;
  goto yy849;
yy849:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy850;
yy850:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy851;
yy851:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy852;
yy852:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy853;
yy853:  yyaccept = 85;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy854;
      if(yych <= '9') goto yy224;
      goto yy854;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy854;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy854;
    } else {
      if(yych == '`') goto yy854;
      if(yych <= 'z') goto yy224;
      goto yy854;
    }
  }
yy854:
#line 430 "cpp.re"
{ RET(T_DYNAMICCAST); }
#line 7478 "cpp_re.cpp"
yy855:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'b') goto yy225;
  goto yy856;
yy856:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy857;
yy857:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy858;
yy858:  yyaccept = 86;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy859;
      if(yych <= '9') goto yy224;
      goto yy859;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy859;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy859;
    } else {
      if(yych == '`') goto yy859;
      if(yych <= 'z') goto yy224;
      goto yy859;
    }
  }
yy859:
#line 429 "cpp.re"
{ RET(T_DOUBLE); }
#line 7516 "cpp_re.cpp"
yy860:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy866;
  goto yy225;
yy861:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy862;
yy862:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy863;
yy863:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy864;
yy864:  yyaccept = 87;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy865;
      if(yych <= '9') goto yy224;
      goto yy865;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy865;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy865;
    } else {
      if(yych == '`') goto yy865;
      if(yych <= 'z') goto yy224;
      goto yy865;
    }
  }
yy865:
#line 427 "cpp.re"
{ RET(T_DELETE); }
#line 7558 "cpp_re.cpp"
yy866:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'u') goto yy225;
  goto yy867;
yy867:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy868;
yy868:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy869;
yy869:  yyaccept = 88;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy870;
      if(yych <= '9') goto yy224;
      goto yy870;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy870;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy870;
    } else {
      if(yych == '`') goto yy870;
      if(yych <= 'z') goto yy224;
      goto yy870;
    }
  }
yy870:
#line 426 "cpp.re"
{ RET(T_DEFAULT); }
#line 7596 "cpp_re.cpp"
yy871:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'r') goto yy225;
  if(yych <= 's') goto yy902;
  if(yych <= 't') goto yy903;
  goto yy225;
yy872:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy899;
  goto yy225;
yy873:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy895;
  goto yy225;
yy874:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'l') goto yy225;
  if(yych <= 'm') goto yy876;
  if(yych >= 'o') goto yy225;
  goto yy875;
yy875:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'r') goto yy225;
  if(yych <= 's') goto yy880;
  if(yych <= 't') goto yy881;
  goto yy225;
yy876:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'p') goto yy225;
  goto yy877;
yy877:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy878;
yy878:  yyaccept = 89;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy879;
      if(yych <= '9') goto yy224;
      goto yy879;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy879;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy879;
    } else {
      if(yych == '`') goto yy879;
      if(yych <= 'z') goto yy224;
      goto yy879;
    }
  }
yy879:
#line 557 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_COMPL_ALT); }
#line 7656 "cpp_re.cpp"
yy880:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 't') goto yy887;
  goto yy225;
yy881:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'i') goto yy225;
  goto yy882;
yy882:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'n') goto yy225;
  goto yy883;
yy883:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'u') goto yy225;
  goto yy884;
yy884:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy885;
yy885:  yyaccept = 90;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy886;
      if(yych <= '9') goto yy224;
      goto yy886;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy886;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy886;
    } else {
      if(yych == '`') goto yy886;
      if(yych <= 'z') goto yy224;
      goto yy886;
    }
  }
yy886:
#line 425 "cpp.re"
{ RET(T_CONTINUE); }
#line 7702 "cpp_re.cpp"
yy887:  yyaccept = 91;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy888;
      if(yych <= '9') goto yy224;
      goto yy888;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy888;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy888;
    } else {
      if(yych <= '_') goto yy889;
      if(yych <= '`') goto yy888;
      if(yych <= 'z') goto yy224;
      goto yy888;
    }
  }
yy888:
#line 423 "cpp.re"
{ RET(T_CONST); }
#line 7729 "cpp_re.cpp"
yy889:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy890;
yy890:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy891;
yy891:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy892;
yy892:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy893;
yy893:  yyaccept = 92;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy894;
      if(yych <= '9') goto yy224;
      goto yy894;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy894;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy894;
    } else {
      if(yych == '`') goto yy894;
      if(yych <= 'z') goto yy224;
      goto yy894;
    }
  }
yy894:
#line 424 "cpp.re"
{ RET(T_CONSTCAST); }
#line 7771 "cpp_re.cpp"
yy895:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy896;
yy896:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 's') goto yy225;
  goto yy897;
yy897:  yyaccept = 93;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy898;
      if(yych <= '9') goto yy224;
      goto yy898;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy898;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy898;
    } else {
      if(yych == '`') goto yy898;
      if(yych <= 'z') goto yy224;
      goto yy898;
    }
  }
yy898:
#line 422 "cpp.re"
{ RET(T_CLASS); }
#line 7805 "cpp_re.cpp"
yy899:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy900;
yy900:  yyaccept = 94;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy901;
      if(yych <= '9') goto yy224;
      goto yy901;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy901;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy901;
    } else {
      if(yych == '`') goto yy901;
      if(yych <= 'z') goto yy224;
      goto yy901;
    }
  }
yy901:
#line 421 "cpp.re"
{ RET(T_CHAR); }
#line 7835 "cpp_re.cpp"
yy902:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'e') goto yy907;
  goto yy225;
yy903:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'c') goto yy225;
  goto yy904;
yy904:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'h') goto yy225;
  goto yy905;
yy905:  yyaccept = 95;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy906;
      if(yych <= '9') goto yy224;
      goto yy906;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy906;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy906;
    } else {
      if(yych == '`') goto yy906;
      if(yych <= 'z') goto yy224;
      goto yy906;
    }
  }
yy906:
#line 420 "cpp.re"
{ RET(T_CATCH); }
#line 7873 "cpp_re.cpp"
yy907:  yyaccept = 96;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy908;
      if(yych <= '9') goto yy224;
      goto yy908;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy908;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy908;
    } else {
      if(yych == '`') goto yy908;
      if(yych <= 'z') goto yy224;
      goto yy908;
    }
  }
yy908:
#line 419 "cpp.re"
{ RET(T_CASE); }
#line 7899 "cpp_re.cpp"
yy909:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 't') goto yy919;
  goto yy225;
yy910:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'o') goto yy916;
  goto yy225;
yy911:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy912;
yy912:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'a') goto yy225;
  goto yy913;
yy913:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'k') goto yy225;
  goto yy914;
yy914:  yyaccept = 97;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy915;
      if(yych <= '9') goto yy224;
      goto yy915;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy915;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy915;
    } else {
      if(yych == '`') goto yy915;
      if(yych <= 'z') goto yy224;
      goto yy915;
    }
  }
yy915:
#line 418 "cpp.re"
{ RET(T_BREAK); }
#line 7945 "cpp_re.cpp"
yy916:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'l') goto yy225;
  goto yy917;
yy917:  yyaccept = 98;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy918;
      if(yych <= '9') goto yy224;
      goto yy918;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy918;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy918;
    } else {
      if(yych == '`') goto yy918;
      if(yych <= 'z') goto yy224;
      goto yy918;
    }
  }
yy918:
#line 417 "cpp.re"
{ RET(T_BOOL); }
#line 7975 "cpp_re.cpp"
yy919:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'a') goto yy920;
  if(yych == 'o') goto yy921;
  goto yy225;
yy920:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'n') goto yy924;
  goto yy225;
yy921:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'r') goto yy225;
  goto yy922;
yy922:  yyaccept = 99;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy923;
      if(yych <= '9') goto yy224;
      goto yy923;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy923;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy923;
    } else {
      if(yych == '`') goto yy923;
      if(yych <= 'z') goto yy224;
      goto yy923;
    }
  }
yy923:
#line 553 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_OR_ALT); }
#line 8014 "cpp_re.cpp"
yy924:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'd') goto yy225;
  goto yy925;
yy925:  yyaccept = 100;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy926;
      if(yych <= '9') goto yy224;
      goto yy926;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy926;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy926;
    } else {
      if(yych == '`') goto yy926;
      if(yych <= 'z') goto yy224;
      goto yy926;
    }
  }
yy926:
#line 551 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_AND_ALT); }
#line 8044 "cpp_re.cpp"
yy927:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'd') goto yy935;
  goto yy225;
yy928:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych == 'm') goto yy933;
  goto yy225;
yy929:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 't') goto yy225;
  goto yy930;
yy930:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'o') goto yy225;
  goto yy931;
yy931:  yyaccept = 101;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy932;
      if(yych <= '9') goto yy224;
      goto yy932;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy932;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy932;
    } else {
      if(yych == '`') goto yy932;
      if(yych <= 'z') goto yy224;
      goto yy932;
    }
  }
yy932:
#line 416 "cpp.re"
{ RET(T_AUTO); }
#line 8086 "cpp_re.cpp"
yy933:  yyaccept = 102;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy934;
      if(yych <= '9') goto yy224;
      goto yy934;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy934;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy934;
    } else {
      if(yych == '`') goto yy934;
      if(yych <= 'z') goto yy224;
      goto yy934;
    }
  }
yy934:
#line 415 "cpp.re"
{ RET(T_ASM); }
#line 8112 "cpp_re.cpp"
yy935:  yyaccept = 103;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy936;
      if(yych <= '9') goto yy224;
      goto yy936;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy936;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy936;
    } else {
      if(yych <= '_') goto yy937;
      if(yych <= '`') goto yy936;
      if(yych <= 'z') goto yy224;
      goto yy936;
    }
  }
yy936:
#line 586 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_ANDAND_ALT); }
#line 8139 "cpp_re.cpp"
yy937:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'e') goto yy225;
  goto yy938;
yy938:  yyaccept = 0;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych != 'q') goto yy225;
  goto yy939;
yy939:  yyaccept = 104;
  yych = *(YYMARKER = ++YYCURSOR);
  if(yych <= 'Z'){
    if(yych <= '>'){
      if(yych <= '/') goto yy940;
      if(yych <= '9') goto yy224;
      goto yy940;
    } else {
      if(yych <= '?') goto yy227;
      if(yych >= 'A') goto yy224;
      goto yy940;
    }
  } else {
    if(yych <= '^'){
      if(yych == '\\')  goto yy226;
      goto yy940;
    } else {
      if(yych == '`') goto yy940;
      if(yych <= 'z') goto yy224;
      goto yy940;
    }
  }
yy940:
#line 572 "cpp.re"
{ RET(s->act_in_c99_mode ? T_IDENTIFIER : T_ANDASSIGN_ALT); }
#line 8173 "cpp_re.cpp"
yy941:  ++YYCURSOR;
  goto yy942;
yy942:
#line 566 "cpp.re"
{ RET(T_DIVIDEASSIGN); }
#line 8179 "cpp_re.cpp"
yy943:  ++YYCURSOR;
  goto yy944;
yy944:
#line 413 "cpp.re"
{ goto cppcomment; }
#line 8185 "cpp_re.cpp"
yy945:  ++YYCURSOR;
  goto yy946;
yy946:
#line 412 "cpp.re"
{ goto ccomment; }
#line 8191 "cpp_re.cpp"
}
#line 685 "cpp.re"


ccomment:

#line 8198 "cpp_re.cpp"
{
  YYCTYPE yych;
  goto yy947;
  ++YYCURSOR;
yy947:
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  if(yych <= 0x0C){
    if(yych <= 0x08){
      if(yych <= 0x00)  goto yy956;
      goto yy949;
    } else {
      if(yych == 0x0A)  goto yy952;
      goto yy955;
    }
  } else {
    if(yych <= 0x1F){
      if(yych <= 0x0D)  goto yy954;
      goto yy949;
    } else {
      if(yych == '*') goto yy950;
      goto yy955;
    }
  }
yy949:yy950:  ++YYCURSOR;
  if((yych = *YYCURSOR) == '/') goto yy959;
  goto yy951;
yy951:
#line 700 "cpp.re"
{ goto ccomment; }
#line 8229 "cpp_re.cpp"
yy952:  ++YYCURSOR;
  goto yy953;
yy953:
#line 692 "cpp.re"
{
        /*if(cursor == s->eof) RET(T_EOF);*/
        /*s->tok = cursor; */
        s->line += count_backslash_newlines(s, cursor) +1;
        cursor.column = 1;
        goto ccomment;
    }
#line 8241 "cpp_re.cpp"
yy954:  yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy958;
  goto yy953;
yy955:  yych = *++YYCURSOR;
  goto yy951;
yy956:  ++YYCURSOR;
  goto yy957;
yy957:
#line 703 "cpp.re"
{
        using namespace std;      // some systems have printf in std
        if(cursor == s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, "Unterminated comment");
            else
                printf("Error: Unterminated comment\n");
        }
        else
        {
            if (s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        RET(T_CCOMMENT);
    }
#line 8272 "cpp_re.cpp"
yy958:  yych = *++YYCURSOR;
  goto yy953;
yy959:  ++YYCURSOR;
  goto yy960;
yy960:
#line 689 "cpp.re"
{ RET(T_CCOMMENT); }
#line 8280 "cpp_re.cpp"
}
#line 725 "cpp.re"


cppcomment:

#line 8287 "cpp_re.cpp"
{
  YYCTYPE yych;
  goto yy961;
  ++YYCURSOR;
yy961:
  if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
  yych = *YYCURSOR;
  if(yych <= 0x0A){
    if(yych <= 0x00)  goto yy969;
    if(yych <= 0x08)  goto yy963;
    if(yych <= 0x09)  goto yy967;
    goto yy964;
  } else {
    if(yych <= 0x0C)  goto yy967;
    if(yych <= 0x0D)  goto yy966;
    if(yych >= ' ') goto yy967;
    goto yy963;
  }
yy963:yy964:  ++YYCURSOR;
  goto yy965;
yy965:
#line 730 "cpp.re"
{
        /*if(cursor == s->eof) RET(T_EOF); */
        /*s->tok = cursor; */
        s->line++;
        cursor.column = 1;
        RET(T_CPPCOMMENT);
    }
#line 8317 "cpp_re.cpp"
yy966:  yych = *++YYCURSOR;
  if(yych == 0x0A)  goto yy971;
  goto yy965;
yy967:  ++YYCURSOR;
  goto yy968;
yy968:
#line 738 "cpp.re"
{ goto cppcomment; }
#line 8326 "cpp_re.cpp"
yy969:  ++YYCURSOR;
  goto yy970;
yy970:
#line 741 "cpp.re"
{
        using namespace std;      // some systems have printf in std
        if(cursor != s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        RET(T_CPPCOMMENT);
    }
#line 8345 "cpp_re.cpp"
yy971:  ++YYCURSOR;
  yych = *YYCURSOR;
  goto yy965;
}
#line 755 "cpp.re"


} /* end of scan */

///////////////////////////////////////////////////////////////////////////////
}   // namespace re2clex
}   // namespace cpplexer
}   // namespace wave
}   // namespace boost

#undef RET
#undef BSIZE 
#undef YYCTYPE
#undef YYCURSOR
#undef YYLIMIT
#undef YYMARKER
#undef YYFILL

