AC_DEFUN(AC_CHECK_EXTRA,[
  AC_ARG_WITH(
    extra-libs,
    [  --with-extra-libs=DIR   comma separated list of additional lib directories ],
    [
      EXTRA=`echo $withval | sed -e ':a;s/,/ -L/;t a'`
      LDFLAGS="$LDFLAGS -L$EXTRA"
    ]
  )
  AC_ARG_WITH(
    extra-includes,
    [  --with-extra-includes=DIR  comma separated list of additional include directories ],
    [
      EXTRA=`echo $withval | sed -e ':a;s/,/ -I/;t a'`
      CPPFLAGS="$CPPFLAGS -I$EXTRA"
    ]
  )
])

AC_DEFUN(AC_FEATURE_IODBC,[
  AC_ARG_ENABLE(
    odbc,
    [  --enable-odbc           Enable ODBC support],
    [ 
      if test "x$enable_odbc" = "xyes"
      then
        AC_DEFINE(USE_ODBC)
        LIBADD="$LIBADD -liodbc"
      fi
    ],
    [
      enable_odbc="yes"
      AC_DEFINE(USE_ODBC)
      LIBADD="$LIBADD -liodbc"
    ]
  )
])

AC_DEFUN(AC_FEATURE_MYSQL,[
  AC_ARG_ENABLE(
    mysql,
    [  --enable-mysql          Enable native mysql support],
    [ 
      if test "x$enable_mysql" = "xyes"
      then
        AC_DEFINE(USE_MYSQL)
        LIBADD="$LIBADD -lmysqlclient"
      fi
    ],
    [
      enable_mysql="yes"
      AC_DEFINE(USE_MYSQL)
      LIBADD="$LIBADD -lmysqlclient"
    ]
  )
])

AC_DEFUN(AC_FEATURE_POSTGRES,[
  AC_ARG_ENABLE(
    postgres,
    [  --enable-postgres       Enable native postgres support],
    [ 
      if test "x$enable_postgres" = "xyes"
      then
        AC_DEFINE(USE_POSTGRES)
        LIBADD="$LIBADD -lpq"
      fi
    ],
    [
      enable_postgres="no"
    ]
  )
])

AC_DEFUN(AC_FEATURE_DEBUG,[
  AC_ARG_ENABLE(
    debug,
    [  --enable-debug          Enable debugging messages],
    [ 
      if test "x$enable_debug" = "xyes"
      then
        AC_DEFINE(DEBUG)
      fi
    ],
    [
      enable_debug="no"
    ]
)])
