#ifndef VISUAL_THREAD_H
#define VISUAL_THREAD_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

// thread.  General purpose synchronization helpers.
namespace visual {

template <class syncObject>
class lock 
{
 private:
	syncObject& obj;

 public:

	lock(syncObject& _obj) : obj(_obj) { _obj.sync_lock(); }
	
	~lock() { obj.sync_unlock(); }

 private:  // not implemented by design, to be noncopyable
	lock(const lock&);
	void operator=(const lock&);
};

template <class syncObject>
class counted_lock 
{
	syncObject& obj;

 public:
	inline counted_lock(syncObject& _obj) : obj(_obj) { _obj.count_lock(); }
	inline ~counted_lock() { obj.sync_unlock(); }

 private:  // not implemented by design, to be noncopyable
	counted_lock(const counted_lock&);
	void operator=(const counted_lock&);
};

template <class dataObject, class syncObject>
class thread_safe 
{
	dataObject data;
	syncObject sync;

 public:
	thread_safe(const dataObject& _data) : data(_data) {}
	inline void operator=(const dataObject& _data) 
	{
		lock<syncObject> L(sync);
		data = _data;
	}
	
	operator dataObject() 
	{
		lock<syncObject> L(sync);
		return data;
	}
};

} // !namespace visual

#endif
