
import test_driver, os

from Ft.Server.Server.Drivers import FtssInputSource, FtssDriver, PathImp
from Ft.Server.Server import Drivers
from Ft.Server.Common import AclConstants, Schema, ResourceTypes
from Ft.Server import FTSERVER_NAMESPACE

def Test(tester):

    tester.startTest("Init")
    #Have to do this all in one transaction because we don't yet have users!!!

    driver = Drivers.Begin(None,{'Driver':{'TYPE':'FlatFile',
                                            'Root':test_driver.TEST_DBNAME,
                                            },
                                  'SystemContainer':'ftss',
                                  })
    if driver.exists() != -1:
        driver.destroy()

    tester.compare(-1,driver.exists())

    driver.initialize()

    p = PathImp.CreateInitialPath('/',
                          driver)

    md = NewXmlDocumentXml(driver,
                           '/include1.xml',
                           {},
                           AclConstants.SUPER_USER_GROUP_NAME,
                           'text/xml',
                           INC1,
                           None,
                           ResourceTypes.ResourceType.XML_DOCUMENT)

    driver.createResource(p.normalize('include1.xml;traverse'),md,INC1)


    tester.testDone()


    tester.startGroup("Resolve")

    tester.startTest("Resolve Present")
    res = FtssInputSource.FtssInputSourceFactory.fromUri('/include1.xml',driver)
    tester.compare(INC1,res.stream.read())
    tester.testDone()

    tester.groupDone()


    tester.startGroup("XInclude")

    tester.startTest("Create with XInclude")
    md = NewXmlDocumentXml(driver,
                           '/include2.xml',
                           {},
                           AclConstants.SUPER_USER_GROUP_NAME,
                           'text/xml',
                           INC2,
                           None,
                           ResourceTypes.ResourceType.XML_DOCUMENT)

    driver.createResource(p.normalize('include2.xml;traverse'),md,INC2)

    context = driver.getContext(p.normalize('include2.xml;traverse'))
    tester.compare('foo',context.node.documentElement.childNodes[1].nodeName)
    tester.testDone()

    tester.groupDone()

    driver.rollback()






def NewXmlDocumentXml(driver, path, acl, owner, imt, src, docDef, typ):
    a = driver.aclToXml(acl)
    t = FtssDriver.CurrentTime()
    md = """<ftss:MetaData xmlns:ftss="%s" path='%s' type='%s' creation-date='%s' document-definition='%s'>
  %s
<ftss:LastModifiedDate>%s</ftss:LastModifiedDate>
<ftss:Owner>%s</ftss:Owner>
<ftss:Imt>%s</ftss:Imt>
<ftss:Size>%d</ftss:Size>
</ftss:MetaData>
        """ % (FTSERVER_NAMESPACE,
               path,
               Schema.g_rdfResourceTypes[typ],
               t,
               docDef or Schema.NULL_DOCDEF,
               a,
               t,
               owner,
               imt,
               len(src))
    return md

INC1 = """<?xml version='1.0' encoding='utf-8'?>
<foo/>
"""

INC2 = """<?xml version='1.0' encoding='utf-8'?>
<foo xmlns:xi="http://www.w3.org/2001/XInclude">
  <xi:include href="include1.xml"/>
</foo>
"""
