// silencedetecter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// SilenceDetecter is a DataModifier which finds the first location in a 
// selection that falls below the average amplitude in dB of what precedes it.

#ifndef SILENCEDECTER_H
#ifdef __GNUG__
//#pragma interface
#endif
#define SILENCEDECTER_H

#include "datamodifier.h"

class SilenceDetecter : public DataModifier {
	typedef DataModifier Super;
	friend class SilenceDetectRequester;
protected:
	enum ThresholdMode { Relative = 1, Absolute = 2 };
public:
	SilenceDetecter(Data *);
	SilenceDetecter(Data *, double attenThreshold, int framesize, int silenceLen);
	static Modifier* create(DataEditor *);
	redefined Modifier* createUndo();
	redefined const char* message() { return "Searching for silence..."; }
	
	int getSilenceOffset() const { return _silenceOffset; }
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int doApply(Data *);
private:
	double 		_attenuationThreshold;
	ChoiceValue	_thresholdMode;
	int 		_frameSize;
	int 		_silenceLength;
	int 		_silenceOffset;
	
	static double		_savedAttenuationThreshold;
	static ChoiceValue	_savedThresholdMode;
	static int 			_savedFrameSize;
	static int 			_savedSilenceLength;
};

#endif	// SILENCEDECTER_H

