// iallpole.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The InverseAllPole class performs the linear predictive coding analysis
// upon a Sound object.  The results are stored into the Data object, 'frame',
// which is a clone of an LPCData object into which the entire analysis is
// loaded.  This code was adapted from Paul Lansky's command-line version of
// the analysis routines.

#ifndef IALLPOLE_H
#ifdef __GNUG__
#pragma interface
#endif
#define IALLPOLE_H

#include "localdefs.h"
#include "arrayfunction.h"

#ifndef maxFrameSize
#define maxFrameSize 1010       /* maximum sample frame size */
#endif

class InverseAllPole : public ArrayFunction {
	typedef ArrayFunction Super;
	friend class InverseAllPoleRequester;
	enum Values { nDataValues = 4 };
public:
	InverseAllPole(Data* data, int poles, int framelength, int froffset);
	InverseAllPole(Data* data);
	virtual ~InverseAllPole();
	redefined const char* message() { return "Running LPC:  "; }
	redefined int operator () (double *input, Data *frame);
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined int maxFrameLength() { return maxFrameSize; }
	redefined void saveConfig();
private:
	int gauss(double*, double*);
private:
	double** gmatrix;	// was a in alpol(), aold in gauss
	double* b;			// in alpol()
	double* v;			// in alpol()
	double* c;			// in gauss()
	int npoles;
private:
	static int 		_savedNPoles;
	static int 		_savedOffset;
	static float 	_savedFrameRate;
};

#endif
