// alsa_converter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef ALSA

#ifndef ALSA_CONVERTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define ALSA_CONVERTER_H

#include "conv_device.h"
#define ALSA_PCM_NEW_HW_PARAMS_API
#include <alsa/asoundlib.h>

class HWMixer;
class String;

class ALSA_Converter : public RealConverter {
	typedef RealConverter Super;
public:
	ALSA_Converter();
	virtual ~ALSA_Converter();
	redefined int pause();
	redefined int stop();
	redefined DataType bestPlayableType();
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int currentPlayLevel() const;
	redefined int currentRecordLevel() const;
	redefined boolean setPlayLevel(int volume);
	redefined boolean setRecordLevel(int volume);
	int currentInputDevice();
	int currentOutputDevice();
	boolean setInputDevice(int);
	boolean setOutputDevice(int);
	ChoiceValue inputDeviceToChoice(int);
	ChoiceValue outputDeviceToChoice(int);
	int inputChoiceToDevice(ChoiceValue);
	int outputChoiceToDevice(ChoiceValue);
	void getInputDeviceLabels(String &);
	void getOutputDeviceLabels(String &);
	redefined int doConfigure();					// hardware-specific
	redefined int checkChannels(int chans);
	redefined int writeSize();						// buffer size in bytes
	redefined int readSize();						// buffer size in bytes
    redefined int doConversion(ProgressAction *);
    redefined int doRecording(ProgressAction *);
 	redefined int waitForStop(ProgressAction *);
	class ALSA_ConfigRequester : public RealConverter::ConfigRequester {
	public:
	    ALSA_ConfigRequester(RealConverter* cnverter) : ConfigRequester(cnverter) {}
	protected:
	    redefined void configureRequest(Request *);
	    redefined boolean confirmValues();
	private:
	    ChoiceValue inputDeviceValue;
	    ChoiceValue outputDeviceValue;
	};
	friend void ALSA_ConfigRequester::configureRequest(Request *);
	friend boolean ALSA_ConfigRequester::confirmValues();
	redefined Requester* configRequester();
private:
	ALSA_Converter(const ALSA_Converter &);
private:
	HWMixer *_mixer;
	snd_pcm_t *_playbackHandle;
	snd_pcm_t *_recordHandle;
	snd_pcm_hw_params_t *_hwParams;
	unsigned audioFormatBits;
	int audioBufferSize;
};

#endif

#endif	/* ALSA */
