/*
 *  MudName Server v. 1.6 - A character name generator
 *  Copyright (C) 1997-2001 Ragnar Hojland Espinosa <ragnar@ragnar-hojland.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>

#include "server.h"
#include "names.h"

unsigned int port;
FILE *logfile;

char const *text_version =
"MudNames 1.6 - (C) 1997-2001 Ragnar Hojland Espinosa <ragnar@ragnar-hojland.com>\n\r"
"FREE software with NO WARRANTY.  Thanks to Mike (mike@cs.pdx.edu)\n\r";

char const *text_fullid =
"MudNames 1.6";

char const *text_ad = 
"\n\r=-= Macula was at macula.net 4000, RIP. =-=\n\r\n\r";

char const *text_footer =
"\n\r-- If you'd like to see more names, please connect again with us.\n\r";


const struct option longopts[] =
{
   { "data",	required_argument, 0, 'd' },
   { "logfile",	required_argument, 0, 'l' },
   { "port",    required_argument, 0, 'p' },
   { "version", no_argument,	    0, 'V' },
   { "help",    no_argument,	    0, 'h' },
   { 0, 0, 0, 0 }
};

void show_version()
{
   printf (text_version);
}

void show_help (char const *progname)
{
   printf ("%s [OPTION...]\n"
	   "   -d, --data=DIRECTORY   read particle data from DIRECTORY (default data/)\n"
	   "   -l, --logfile=FILE     write statistics to FILE on termination\n\r"
	   "   -p, --port=PORT        listen on port PORT (default 4004)\n"
	   "       --help             display this help and exit\n"
	   "       --version          output version information and exit\n",
	   progname);
}


int main (int argc, char **argv)
{
   char* datadir = strdup ("data/");
   int o, longindex;
   port = 4004;
   logfile = stdout;
   
   while ( (o=getopt_long (argc, argv, "d:l:p:hV", longopts, &longindex)) != EOF)
   switch (o) {
    case 'h':
      show_version();
      show_help (argv[0]);
      return 0;
      
    case 'V':
      show_version();
      return 0;
      
    case 'p':
      port = atoi (optarg);
      if (port < 1) {
	 fprintf (stderr, "port number must be positive\n");
	 return 1;
      }
      
    case 'l':
      logfile = fopen (optarg, "a");
      if (!logfile) {
	 perror (optarg);
	 return 1;
      }
      
    case 'd':
      free (datadir);
      datadir = strdup (optarg);
      break;
   }
   
   if (access (datadir, X_OK)) {
      perror (datadir);
      return 1;
   }
   
   if (load_dictionaries (datadir) < 1) {
      return 1;
   }
   free (datadir);

   if (init_server(port)) {
      return 1;
   }

   signal (SIGTERM, handler_sigterm);
   run_server (&name_generator, NULL);
   
   return 0;
}
