/*
** pgsql_dispatch.h
*/

#define PG_MP3_GET "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s WHERE signature = '%s'"
#define PG_MP3_GET_RANDOM "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s ORDER BY round(random()*1000) LIMIT 1"
#define PG_MP3_INSERT "INSERT IGNORE INTO %s (name,filename,signature,artist,album,comment,track,year,genre) VALUES ('%s','%s','%s','%s','%s','%s','%s','%s','%s')"

#define PG_MP3_GETS "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s"
#define PG_MP3_GET_LIST "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s WHERE signature IN (%s)"
#define PG_MP3_GETS_TOKEN "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s,%s WHERE token ~* \"%s\" AND signature = for_signature"

#define PG_MP3_GETS_RANDOM "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s ORDER BY round(random()*1000)"
#define PG_MP3_GET_LIST_RANDOM "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s WHERE signature IN (%s) ORDER BY round(random()*1000)"
#define PG_MP3_GETS_TOKEN_RANDOM "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s,%s WHERE token ~* \"%s\" AND signature = for_signature ORDER BY round(random()*1000)"

#define PG_MP3_GETS_COUNT "SELECT count(signature) FROM %s"
#define PG_MP3_GET_LIST_COUNT "SELECT name,filename,signature,artist,album,comment,track,year,genre FROM %s WHERE signature IN (%s)"
#define PG_MP3_GETS_TOKEN_COUNT "SELECT count(signature) FROM %s,%s WHERE token ~* \"%s\" AND signature = for_signature"

#define PG_MP3_FETCH_PATTERN "SELECT signature FROM %s WHERE name ~* \"%s\""
#define PG_MP3_FETCH "SELECT signature FROM %s"

#define TABLE_LIST "name,filename,signature,artist,album,comment,track,year,genre"

typedef struct {
	PGconn *dbh;		/* database handler */
	PGresult *sth;		/* statement handler */
	int row;		/* Which row number to look at */
	const char *hostname;	/* DB host */
	const char *user;	/* DB user */
	const char *password;	/* DB password */
	const char *database;	/* DB name */
	const char *table;	/* DB table with MP3 data */
	const char *table_token;		/* Table name for dealing with a db */
	const char *each_sql;			/* Table name for dealing with a db */
	mp3_data bank;		/* Contains MP3 data */
} pgsql_context;
