/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;

/**
 * Class that provides the ability to group several Windows together.
 */
public class WindowGroup extends GObject 
{
	/**
	 * Construct a new WindowGroup
	 */
	public WindowGroup() {
		super(gtk_window_group_new());
	}
	
	/**
	 * Add a Window to this WindowGroup
	 * 
	 * @param window The Window to be added to this WindowGroup
	 */
	public void addWindow(Window window) {
		WindowGroup.gtk_window_group_add_window(getHandle(), window.getHandle());
	}
	
	/**
	 * Remove a Window from this WindowGroup
	 *
	 * @param window The Window to be removed from this WindowGroup.
	 */
	public void removeWindow(Window window) {
		WindowGroup.gtk_window_group_remove_window(getHandle(), window.getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_window_group_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_window_group_get_type ();
    native static final protected int gtk_window_group_new ();
    native static final protected void gtk_window_group_add_window (int windowGroup, int window);
    native static final protected void gtk_window_group_remove_window (int windowGroup, int window);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

