#!/usr/bin/python
# This script should be run from inside the debian/ directory.
# You have been warned.

import os, sys

def find_property (line, prop):
    loc = line.index ('%s="' % (prop))
    loc = loc + len ('%s="' % (prop))
    end = line[loc:].index ('"') + len (line[:loc])
    return line[loc:end]

if not os.access ('./devhelp-books.doc-base.EX', os.R_OK):
    print 'You should run this script from inside the debian/ directory!'
    sys.exit (1)

try:
    os.mkdir ('tmp')
except OSError:
    pass

os.chdir ('tmp')

package = sys.argv[1]
book = sys.argv[2]
os.system ('tar zxpf ../../books/%s.tar.gz' % (book))
control = open ('book.devhelp')

inside_book_tag = False
author = None
title = None
link = None
while True:
    line = control.readline ()
    if line == '':
        break

    if line[:6] == "<book ":
        inside_book_tag = True

    if inside_book_tag:
        try:
            author = find_property (line, 'author')
        except ValueError:
            pass

        try:
            title = find_property (line, 'title')
        except ValueError:
            pass

        try:
            link = find_property (line, 'link')
        except ValueError:
            pass

        try:
            line.index ('>')
            inside_book_tag = False

            template = open ('../devhelp-books.doc-base.EX')
            content = template.read ()
            template.close ()
            
            if not author:
                author = 'N/A'
            if not title:
                title = 'N/A'

            if not link:
                os.chdir ('..')
                sys.exit (1)
                
            content = content.replace ('#AUTHOR#', author)
            content = content.replace ('#TITLE#', title)
            content = content.replace ('#PACKAGE#', package)
            content = content.replace ('#BOOK#', book)
            content = content.replace ('#INDEX#', link)

            print content
            break
        except ValueError:
            pass

os.chdir ('..')
