/*  
 *  xcall - Packet radio program for GTK+
 *  Copyright (C) 2001 Joop Stakenborg <pg4i@amsat.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* proc.c: lookup settings in the proc filesystem */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <asm/param.h>
#include "support.h"

#ifdef HAVE_NETAX25_AX25_H
#include <netax25/ax25.h>
#else
#include <netax25/kernel_ax25.h>
#endif
#ifdef HAVE_NETROM_NETROM_H
#include <netrom/netrom.h>
#else
#include <netax25/kernel_netrom.h>
#endif
#ifdef HAVE_NETROSE_ROSE_H
#include <netrose/rose.h>
#else
#include <netax25/kernel_rose.h>
#endif

#include <netax25/axconfig.h>
#include <netax25/nrconfig.h>
#include <netax25/rsconfig.h>

#define AX25PROCPATH "/proc/sys/net/ax25"

extern GtkWidget *preferencesdialog;
static gchar *ax25procentry[] = {
  "ax25_default_mode", "backoff_type", "extended_window_size",
  "idle_timeout", "maximum_packet_length", "maximum_retry_count",
  "standard_window_size", "t1_timeout", "t2_timeout", "t3_timeout" };

static gint ax25portsetting(gchar *port, gint i) {
  FILE *fs;
  gint value;
  gchar *procfile;

  procfile = g_strdup_printf("%s/%s/%s", AX25PROCPATH, ax25_config_get_dev(port), ax25procentry[i]);
  if ((fs = fopen(procfile, "r")) == NULL) return(-1);
  fscanf(fs, "%d", &value);
  fclose(fs);
  return(value);
}

void axupdatelabels(gchar *axportentry) {
  GtkWidget *label;
  gchar *text, *tochar;
  gint setting;

  label = lookup_widget(preferencesdialog, "axlabel1");
  setting = ax25portsetting(axportentry, 0);
  text = g_strdup_printf(_("AX.25 default mode: %s"), 
    (setting == -1 ? _("Unknown") : (setting == 0 ? _("Standard") : _("Extended"))));
  gtk_label_set_text(GTK_LABEL(label), text);

  label = lookup_widget(preferencesdialog, "axlabel2");
  setting = ax25portsetting(axportentry, 1);
  text = g_strdup_printf(_("Backoff: %s"), 
    (setting == -1 ? _("Unknown") : (setting == 0 ? _("Linear") : _("Exponential"))));
  gtk_label_set_text(GTK_LABEL(label), text);

  label = lookup_widget(preferencesdialog, "axlabel3");
  setting = ax25portsetting(axportentry, 2);
  tochar = g_strdup_printf("%d", setting);
  text = g_strdup_printf(_("Extended window size: %s"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

  label = lookup_widget(preferencesdialog, "axlabel4");
  setting = ax25portsetting(axportentry, 3);
  tochar = g_strdup_printf("%.2f", (gfloat)setting/HZ);
  text = g_strdup_printf(_("Idle timeout: %s seconds"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);
  
  label = lookup_widget(preferencesdialog, "axlabel5");
  setting = ax25portsetting(axportentry, 4);
  tochar = g_strdup_printf("%d", setting);
  text = g_strdup_printf(_("AX.25 frame length: %s bytes"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

  label = lookup_widget(preferencesdialog, "axlabel6");
  setting = ax25portsetting(axportentry, 5);
  tochar = g_strdup_printf("%d", setting);
  text = g_strdup_printf(_("N2 (Retry count): %s"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

label = lookup_widget(preferencesdialog, "axlabel7");
  setting = ax25portsetting(axportentry, 6);
  tochar = g_strdup_printf("%d", setting);
  text = g_strdup_printf(_("Standard window: %s"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

label = lookup_widget(preferencesdialog, "axlabel8");
  setting = ax25portsetting(axportentry, 7);
  tochar = g_strdup_printf("%.2f", (gfloat)setting/HZ);
  text = g_strdup_printf(_("T1 timeout: %s seconds"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

label = lookup_widget(preferencesdialog, "axlabel9");
  setting = ax25portsetting(axportentry, 8);
  tochar = g_strdup_printf("%.2f", (gfloat)setting/HZ);
  text = g_strdup_printf(_("T2 timeout: %s seconds"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);

label = lookup_widget(preferencesdialog, "axlabel10");
  setting = ax25portsetting(axportentry, 9);
  tochar = g_strdup_printf("%.2f", (gfloat)setting/HZ);
  text = g_strdup_printf(_("T3 timeout: %s seconds"), 
    (setting == -1 ? _("Unknown") : tochar));
  gtk_label_set_text(GTK_LABEL(label), text);
}
