/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLForEach;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.style.XSLWithParam;
import java.util.Vector;
import org.xml.sax.SAXException;

public class XSLCallTemplate
extends StyleElement {
    private Name calledTemplateName = null;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private static Name saxonAllowAVT = Name.reconstruct("saxon", "http://icl.com/saxon", "allow-avt");

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"name"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue(saxonAllowAVT);
        boolean bl = string != null && string.equals("yes");
        String string2 = this.getAttributeValue("name");
        if (string2 == null) {
            this.reportAbsence("name");
        }
        if (bl) {
            this.calledTemplateExpression = AttributeValueTemplate.make(string2, this);
        } else {
            this.calledTemplateName = new Name(string2, this, false);
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        if (this.calledTemplateExpression == null) {
            this.template = this.findTemplate(this.calledTemplateName);
            if (this.template.isAncestor(this)) {
                this.useTailRecursion = true;
                StyleElement styleElement = this;
                while (styleElement != this.template) {
                    if (((StyleElement)styleElement).isInstruction() && styleElement.getNextSibling() != null || styleElement instanceof XSLWithParam || styleElement instanceof XSLForEach) {
                        this.useTailRecursion = false;
                        break;
                    }
                    styleElement = (StyleElement)styleElement.getParentNode();
                }
            }
        }
    }

    private XSLTemplate findTemplate(Name name) throws SAXException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        String string = name.getAbsoluteName();
        int n = vector.size() - 1;
        while (n >= 0) {
            XSLTemplate xSLTemplate;
            String string2;
            if (vector.elementAt(n) instanceof XSLTemplate && (string2 = (xSLTemplate = (XSLTemplate)vector.elementAt(n)).getTemplateName()) != null && string2 == string) {
                return xSLTemplate;
            }
            --n;
        }
        throw this.styleError("No template exists named " + name.getDisplayName());
    }

    public void process(Context context) throws SAXException {
        Object object;
        Object object2;
        XSLTemplate xSLTemplate = this.template;
        if (this.calledTemplateExpression != null) {
            object2 = this.calledTemplateExpression.evaluateAsString(context);
            if (!Name.isQName((String)object2)) {
                throw new SAXException("Invalid template name: " + (String)object2);
            }
            object = new Name((String)object2, this, false);
            xSLTemplate = this.findTemplate((Name)object);
        }
        object2 = null;
        if (this.getNumberOfChildren() > 0) {
            object = (NodeInfo)this.getFirstChild();
            object2 = new ParameterSet();
            while (object != null) {
                if (object instanceof XSLWithParam) {
                    XSLWithParam xSLWithParam = (XSLWithParam)object;
                    ((ParameterSet)object2).put(xSLWithParam.getVariableName(), xSLWithParam.getParamValue(context));
                }
                object = (NodeInfo)object.getNextSibling();
            }
        }
        if (this.useTailRecursion) {
            context.setTailRecursion((ParameterSet)object2);
        } else {
            object = context.getBindery();
            ((Bindery)object).openStackFrame((ParameterSet)object2);
            xSLTemplate.expand(context);
            ((Bindery)object).closeStackFrame();
        }
    }
}

