/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import org.xml.sax.SAXException;

class FilterExpression
extends NodeSetExpression {
    private Expression start;
    private Expression filter;

    public FilterExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.filter = expression2;
    }

    public Expression simplify() throws SAXException {
        this.start = this.start.simplify();
        this.filter = this.filter.simplify();
        if (this.start instanceof EmptyNodeSet) {
            return this.start;
        }
        if (this.filter instanceof Value && !(this.filter instanceof NumericValue)) {
            boolean bl = ((Value)this.filter).asBoolean();
            if (bl) {
                return this.start;
            }
            return new EmptyNodeSet();
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context) throws SAXException {
        NodeEnumeration nodeEnumeration = this.start.enumerate(context);
        if (!nodeEnumeration.hasMoreElements()) {
            return nodeEnumeration;
        }
        if ((this.filter.getDataType() == 2 || this.filter.getDataType() == -1 || this.filter.isRelative()) && !nodeEnumeration.isSorted()) {
            nodeEnumeration = new NodeSetExtent(nodeEnumeration).sort().enumerate();
        }
        return new FilterEnumerator(nodeEnumeration, this.filter, context);
    }

    public String toString() {
        return this.start.toString() + "[" + this.filter.toString() + "]";
    }

    public int getDependencies() {
        return this.start.getDependencies() | this.filter.getDependencies() & 0x45;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression = this.start.reduce(n, context);
            Expression expression2 = this.filter.reduce(n & 0x45, context);
            FilterExpression filterExpression = new FilterExpression(expression, expression2);
            filterExpression.setStaticContext(this.getStaticContext());
            return ((Expression)filterExpression).simplify();
        }
        return this;
    }
}

