// This header contains some structure definitions. Similiar defintions can be 
// found in other header files. But it seems like it is hard to find a set of
// headers which are identical on different systems. So they are included
// here.
//
// The definitions here are based on similar definitions in the Linux kernel.

#define MAC_ADDR_LEN    6      // Length of MAC address
#define MAC_PROTO_IP4V	0x800  // Protocol type of IP v.4 packets.

#define IPPROTO_TCP 6
#define IPPROTO_UDP 17

#ifdef __GNUC__
#include <sys/types.h>

  typedef u_int8_t  u8;  // Unsigned 8 bit type
  typedef u_int16_t u16; // Unsigned 16 bit type
  typedef u_int32_t u32; // Unsigned 32 bit type
#else
  // Use current conventions...:
  typedef unsigned char  u8;
  typedef unsigned short u16;
  typedef unsigned int   u32;
#endif  

struct mac_addr_t {
  u8 addr[MAC_ADDR_LEN];
};  

struct mac_header {
  mac_addr_t dst;
  mac_addr_t src;
  u16 protocol;
};

struct ip_header {
  u8  ver_hdrlen;
  u8  tos;
  u16 len;
  u16 f2;
  u16 f3;
  u8  f4;
  u8  protocol;
  u16 checksum;
  u32 src;
  u32 dst;
};

struct tcp_header {
  u16 src_port;
  u16 dst_port;
};

struct udp_header {
  u16 src_port;
  u16 dst_port;
};
