
do 'bandwidth-lib.pl';
&foreign_require("firewall", "backup_config.pl");
&foreign_require("syslog", "backup_config.pl");

# backup_config_files()
# Returns files and directories that can be backed up
sub backup_config_files
{
# Just backup syslog and firewall
return ( &firewall::backup_config_files(),
	 &syslog::backup_config_files() );
}

# pre_backup(&files)
# Called before the files are actually read
sub pre_backup
{
return &firewall::pre_backup() &&
       &syslog::pre_backup();
}

# post_backup(&files)
# Called after the files are actually read
sub post_backup
{
return &firewall::post_backup() &&
       &syslog::post_backup();
}

# pre_restore(&files)
# Called before the files are restored from a backup
sub pre_restore
{
return &firewall::pre_restore() &&
       &syslog::pre_restore();
}

# post_restore(&files)
# Called after the files are restored from a backup
sub post_restore
{
return &firewall::post_restore() &&
       &syslog::post_restore();
}

1;

