#!/usr/local/bin/perl
# stop.cgi
# Stop the running apache server

require './apache-lib.pl';
&ReadParse();
&error_setup($text{'stop_err'});

$access{'stop'} || &error($text{'stop_ecannot'});
if ($config{'stop_cmd'}) {
	# use the configured stop command
	$out = &backquote_logged("($config{'stop_cmd'}) 2>&1");
	if ($?) {
		&error("<pre>$out</pre>");
		}
	}
elsif (-x $config{'apachectl_path'}) {
	# use the apachectl program
	$out = &backquote_logged("($config{'apachectl_path'} stop) 2>&1");
	if ($httpd_modules{'core'} >= 2 ? $? : $out !~ /httpd stopped/) {
		&error("<pre>$out</pre>");
		}
	}
else {
	# kill the process
	$conf = &get_config();
	$pidfile = &get_pid_file();

	open(PID, $pidfile) || &error(&text('stop_epid', $pidfile));
	<PID> =~ /(\d+)/ || &error(&text('stop_epid2', $pidfile));
	close(PID);
	&kill_logged('TERM', $1) || &error(&text('stop_esig', $1));
	}
sleep(1);
&webmin_log("stop");
&redirect($in{'redir'});

