/*
 * =========================== 
 * VDK Visual Development Kit 
 * Version 0.6.1 
 * May 1999 
 * =========================== 
 * 
 * Copyright (C) 1998, Mario Motta 
 * Developed by Mario Motta <mmotta@guest.net> 
 * Modified by Tamas Kohegyi <tamas.kohegyi@unforgettable.com> 
 * 
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public 
 * License as published by the Free Software Foundation; either 
 * version 2 of the License, or (at your option) any later version. 
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Library General Public License for more details. 
 * 
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 */ 
 
 
#include "vdk/canvas.h" 
#include "vdk/forms.h" 
#include "vdk/rawpixmap.h" 
#include <stdlib.h> 
/* 
 * Recreates the buffered pixmap  
 */ 
void VDKCanvas::Reset() 
{ 
  if(pixmap) 
    gdk_pixmap_unref(pixmap); 
  pixmap = gdk_pixmap_new(widget->window, 
			  widget->allocation.width, 
			  widget->allocation.height, 
			  -1); 
  if(gc)
    gdk_gc_destroy(gc);
  gc = gdk_gc_new(pixmap);
  return; 
} 
 
/* 
 * This function called when the VDKCanvas resized, this means that the size of the  
 * buffered pixmap is incorrect, so we have to recreate it, and the Programmer should  
 * redraw its content in his/her ConfigureEvent function. Except if EnableClear is true
 * but it may cause flashes... 
 */ 
int 
VDKCanvas::ConfigureEvent(GtkWidget* , GdkEventConfigure* , void* o) 
{ 
  g_return_val_if_fail(o != NULL, FALSE); 
  VDKCanvas* canvas = reinterpret_cast<VDKCanvas*>(o); 
  canvas->Reset();
  if (canvas->EnableClear)
      canvas->DrawBackground();
  return FALSE;// TRUE;
}   
 
/* 
 * This internal function caled by the Configure Event if the EnableClear is true
 * It clears the drawing area, and shows it on the screen.
 */ 
void VDKCanvas::DrawBackground() 
{ 
  Clear(); 
  gtk_widget_draw(widget,NULL); 
} 
 
/* 
 * This function fills the canvas area with the background color.  
 */ 
void VDKCanvas::Clear() 
{ 
  gdk_draw_rectangle(pixmap, 
	     // gc ? gc : widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
		     widget->style-> bg_gc[GTK_WIDGET_STATE(widget)], 
		     TRUE, 
		     0, 
		     0, 
		     widget->allocation.width, 
		     widget->allocation.height); 
} 
 
/* 
 * This function called, when the canvas got an expose event, and takes care 
 * about the refresh. The Programmer may not use this event, because of the  
 * buffered pixmap. 
 */  
int
VDKCanvas::ExposeEvent(GtkWidget* w , GdkEventExpose* event, void* o) 
{  
  g_return_val_if_fail(o != NULL,FALSE); 
  g_return_val_if_fail(w != NULL,FALSE); 
  VDKCanvas* canvas = reinterpret_cast<VDKCanvas*>(o); 
  // avoid to redrawing in case of 
  // setting canvas foreg, backg or font 
  if(canvas->setFg)  
    { 
      canvas->setFg = false; 
      return FALSE; //TRUE; 
    } 
  if(canvas->setBg) 
    { 
      canvas->setBg = false; 
      return FALSE; // TRUE; 
    } 
  gdk_draw_pixmap(canvas->widget->window,
		  canvas->gc ? 
		  canvas->gc : 
	  //canvas->widget ->style->bg_gc[GTK_WIDGET_STATE(canvas->widget)],
		  canvas->widget->style->
		  bg_gc[GTK_WIDGET_STATE(canvas->widget)], 
		  canvas->pixmap, 
		  event->area.x,event->area.y, 
		  event->area.x,event->area.y, 
		  event->area.width, 
		  event->area.height);  
  return FALSE; // TRUE; 
} 
 
/* 
 * This function copies the buffered pixmap into the screen. 
 * Call it, when you finished the drawing on the canvas,  
 * and You would like to show it on the screen. 
 */ 
void VDKCanvas::Redraw() 
{ 
if(pixmap) 
 gdk_draw_pixmap(widget->window, 
		 //gc ? gc : widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
		 widget->style->bg_gc[GTK_WIDGET_STATE(widget)], 
		 pixmap, 
		 0, 
		 0, 
		 0,   
		 0, 
		 widget->allocation.width, 
		 widget->allocation.height); 
return; 
} 
 
/* 
int
VDKCanvas::MotionNotifyEvent(GtkWidget *w,  
				  GdkEventMotion* event,  
				  void* o) 
{ 
  int x, y;  
  g_return_val_if_fail(o != NULL, FALSE); 
  g_return_val_if_fail(w != NULL, FALSE); 
  VDKCanvas* obj = reinterpret_cast<VDKCanvas*>(o); 
  GdkModifierType state; 
  if (event->is_hint) 
    gdk_window_get_pointer (event->window, &x, &y, &state); 
  if ( obj->Captured == false )
    // checks where the cursor is 
    if( x < 0  
	|| y < 0  
	|| x > w->allocation.width  
	|| y > w->allocation.height 
	) 
      return FALSE; //TRUE; 

  if(obj->startdragFlag && obj->EnableDrag) 
    { 
      obj->startdragFlag = false; 
      GdkEventMotion *motionEv = new GdkEventMotion; 
      *motionEv = *event; 
      motionEv->x = x; 
      motionEv->y = y; 
      motionEv->state = state; 
      motionEv->type = (GdkEventType) drag_start_event; 
      obj->VDKObject::VDKEventPipe(w, (GdkEvent*) motionEv , o); 
      delete motionEv; 
    } 
    else if(event->state ) // && (GDK_BUTTON1_MASK || GDK_BUTTON2_MASK || GDK_BUTTON3_MASK) 
	  && obj->EnableDrag ) 
    { 
      GdkEventMotion *motionEv = new GdkEventMotion; 
      *motionEv = *event; 
      motionEv->x = x; 
      motionEv->y = y; 
      motionEv->state = state; 
      motionEv->type = (GdkEventType) dragging_event; 
      obj->VDKObject::VDKEventPipe(w, (GdkEvent*) motionEv , o); 
      delete motionEv; 
    } 
  else 
    { 
      obj->dragFlag = false; 
      obj->VDKObject::VDKEventPipe(w, (GdkEvent*) event , o); 
    }  
  return  FALSE; //TRUE; 
} 
*/ 
 
/* 
   int
VDKCanvas::ButtonPressEvent(GtkWidget* w,  
				 GdkEventButton* event, void* o) 
{ 
  g_return_val_if_fail(o != NULL, FALSE); 
  g_return_val_if_fail(w != NULL, FALSE); 
  VDKCanvas* obj = reinterpret_cast<VDKCanvas*>(o);  
  if (obj->EnableDrag) obj->dragFlag = obj->startdragFlag = true; 
  obj->VDKObject::VDKEventPipe(w, (GdkEvent*) event , o); 
  return FALSE; // TRUE;
} 
*/
/* 
  
int
VDKCanvas::ButtonReleaseEvent(GtkWidget *w ,  
				   GdkEventButton* event, void* o) 
{ 
  g_return_val_if_fail(o != NULL, FALSE); 
  g_return_val_if_fail(w != NULL, FALSE); 
  VDKCanvas* obj = reinterpret_cast<VDKCanvas*>(o); 
  if(obj->dragFlag && ! obj->startdragFlag) 
    { 
      obj->dragFlag = false; 
      GdkEventButton *buttonEv = new GdkEventButton; 
      *buttonEv = *event; 
      buttonEv->type = (GdkEventType) drag_stop_event; 
      obj->VDKObject::VDKEventPipe(w, (GdkEvent*) buttonEv , o); 
      delete buttonEv; 
    } 
  obj->startdragFlag = false; 
  obj->VDKObject::VDKEventPipe(w, (GdkEvent*) event , o); 
  return FALSE; // TRUE;
} 
*/ 
/* 
 */ 
VDKCanvas::VDKCanvas(VDKForm* owner,int w, int h): 
  VDKObject(owner), 
  // Captured("Captured",this,false), 
  // EnableDrag("EnableDrag",this,true), 
  EnableClear("EnableClear",this,true) 
 
{ 
  setFg = false; 
  setBg = false; 
  setF = false; 
  canvasFont = NULL;
  pixmap = NULL; 
  // dragFlag = false; 
  // startdragFlag = false; 
  gc = NULL;
  widget = gtk_drawing_area_new(); 
   
  gtk_drawing_area_size(GTK_DRAWING_AREA(widget),w,h); 
   
  //  gtk_widget_add_events(widget,GDK_ALL_EVENTS_MASK); 
  gtk_widget_add_events(widget,
     GDK_EXPOSURE_MASK | 
     GDK_BUTTON_PRESS_MASK |  
     GDK_POINTER_MOTION_MASK | 
     GDK_BUTTON_RELEASE_MASK | 
			//     GDK_POINTER_MOTION_HINT_MASK |
     GDK_KEY_PRESS_MASK | 
     GDK_KEY_RELEASE_MASK |
     GDK_ENTER_NOTIFY_MASK |
     GDK_LEAVE_NOTIFY_MASK); 

  gtk_signal_connect (GTK_OBJECT (widget), "configure_event", 
		      GTK_SIGNAL_FUNC(VDKCanvas::ConfigureEvent),this); 
  /*
  gtk_signal_connect (GTK_OBJECT (widget), "configure_event", 
		      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this); 
  */ 
  gtk_signal_connect (GTK_OBJECT (widget), "expose_event", 
		      GTK_SIGNAL_FUNC(VDKCanvas::ExposeEvent),this);    
  /* 
  gtk_signal_connect (GTK_OBJECT (widget), "expose_event", 
  	      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this); 
 
  gtk_signal_connect (GTK_OBJECT (widget), "motion_notify_event", 
		      GTK_SIGNAL_FUNC(VDKCanvas::MotionNotifyEvent),this); 
   
 
  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event", 
		      GTK_SIGNAL_FUNC(VDKCanvas::ButtonPressEvent),this); 
  //  gtk_signal_connect (GTK_OBJECT (widget), "button_press_event", 
  //	      GTK_SIGNAL_FUNC(VDKObject::VDKEventPipe),this); 
 
  gtk_signal_connect (GTK_OBJECT (widget), "button_release_event", 
		      GTK_SIGNAL_FUNC(VDKCanvas::ButtonReleaseEvent),this); 
  */
  ConnectDefaultSignals(); 
} 
 
/* 
 */ 
VDKCanvas::~VDKCanvas() 
{ 
  if(gc)
    gdk_gc_destroy(gc);
} 
//=========================================================== 
extern void PixSize(int* width, int* height, char* filename); 
/* 
 */ 
void VDKCanvas::DrawPixmap(int x, int y, char ** data) 
{ 
DrawPixmap(x,y,new VDKRawPixmap(this,data)); 
} 
/* 
 */ 
void VDKCanvas::DrawPixmap(int x, int y, char *pixfile) 
{ 
DrawPixmap(x,y,new VDKRawPixmap(this,pixfile)); 
} 
/* 
 */ 
void VDKCanvas::DrawPixmap(int x, int y, VDKRawPixmap* pix) 
{ 
  if(pixmap) 
    if(pix) 
      pix->Paint(false,pixmap,x,y); 
} 
/* 
 */ 
 void VDKCanvas::DrawString(int x, int y, char* text) 
{ 
  GdkFont* font = NULL;
  if(pixmap) 
    {
      if(!canvasFont)
	{
	  GtkStyle *style = gtk_widget_get_style(widget);
	  font = style ? gtk_style_get_font(style) :  NULL;
	}
      else
	font = canvasFont;
      if(font)
	gdk_draw_string(pixmap, 
			font,
			gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
			x, 
			y, 
			text); 
      
    }
}  
/* 
 */ 
void VDKCanvas::DrawText(int x, int y, char* text, int n) 
{ 

  GdkFont* font = NULL;
  if(pixmap) 
    {
      if(!canvasFont)
	{
	  GtkStyle *style = gtk_widget_get_style(widget);
	  font = style ? gtk_style_get_font(style) :  NULL;
	}
      else
	font = canvasFont;
      if(font)
      gdk_draw_text(pixmap, 
		    font,
		    gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		    x, 
		    y, 
		    text, 
		    n);       
    }
} 
/* 
 */ 
void VDKCanvas::DrawPoint(int x, int y) 
{ 
if(pixmap) 
  gdk_draw_point(pixmap, 
		 gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		  x, 
		  y); 
} 
/* 
 */ 
void VDKCanvas::DrawLine(int x, int y, int x1, int y1)  
{ 
if(pixmap) 
  gdk_draw_line(pixmap, 
		 gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		  x,y,x1,y1); 
} 
/* 
 */ 
void VDKCanvas::DrawRect(gint filled, int x, int y, int w, int h) 
{ 
if(pixmap) 
  gdk_draw_rectangle(pixmap, 
		     gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		     filled, 
		     x,y,w,h); 
}  
/* 
 */ 
void VDKCanvas::DrawArc(gint filled, 
			       gint x, 
			       gint y, 
			       gint width, 
			       gint height, 
			       gint angle1, 
			       gint angle2) 
{ 
  if(pixmap) 
    gdk_draw_arc(pixmap, 
		 gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		 filled, 
		 x, 
		 y, 
		 width, 
		 height, 
		 angle1, 
		 angle2); 
} 
/* 
 */ 
void VDKCanvas::DrawPolygon(gint		filled, 
				   GdkPoint     *points, 
				   gint		npoints) 
{ 
  if(pixmap) 
    gdk_draw_polygon(pixmap, 
		     gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		     filled, 
		     points, 
		     npoints); 
} 
/* 
 */ 
void VDKCanvas::DrawPoints(GdkPoint     *points, 
				  gint		npoints) 
{ 
if(pixmap) 
    gdk_draw_points(pixmap, 
		    gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		    points, 
		    npoints); 
} 
/* 
 */ 
void VDKCanvas::DrawSegments(GdkSegment   *segs, 
				    gint	 nsegs) 
{ 
if(pixmap) 
    gdk_draw_segments(pixmap, 
		       gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		       segs, 
		       nsegs); 
} 
/* 
 */ 
void 
VDKCanvas::DrawLines(GdkPoint     *points, 
				 gint          npoints) 
{ 
if(pixmap) 
    gdk_draw_lines(pixmap, 
		   gc ? gc : widget->style->fg_gc[GTK_WIDGET_STATE(widget)], 
		   points, 
                   npoints); 
} 
 
/*
 */ 
void 
VDKCanvas::SetForeground(VDKRgb rgb, GtkStateType state)
{
  setFg = true;  
  if(Widget()->window)
    {
      GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
      GdkColormap *colormap = gdk_window_get_colormap (Widget()->window);
      color->red    = rgb.red << 8;
      color->green  = rgb.green << 8;
      color->blue   = rgb.blue << 8;
      if (!gdk_color_alloc (colormap, color))
	gdk_color_black (colormap, color);
      if(gc)
	gdk_gc_set_foreground(gc, color);
      else
	VDKObject::SetForeground(rgb, state);
        free(color);
    }
  else
    VDKObject::SetForeground(rgb, state);

} 


void 
VDKCanvas::SetBackground(VDKRgb rgb, GtkStateType state)
{

//    setBg = true;  
//    if(Widget()->window)
//    {
//    GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
//    GdkColormap *colormap = gdk_window_get_colormap (Widget()->window);
//    color->red    = rgb.red << 8;
//    color->green  = rgb.green << 8;
//    color->blue   = rgb.blue << 8;
//    if (!gdk_color_alloc (colormap, color))
//    gdk_color_black (colormap, color);
//    if(gc)
//    gdk_gc_set_background(gc, color);
//    else
//    VDKObject::SetBackground(rgb, state);
//    free(color);
//    }
//    else
    VDKObject::SetBackground(rgb, state);
} 


void 
VDKCanvas::SetFont(VDKFont* f) 
{ 
  setF = true;
  canvasFont = f->AsGdkFont();
  // VDKObject::SetFont(f); 
  /*
  GtkStyle *style = gtk_widget_get_style (widget); 
  g_return_if_fail (style != NULL);
  GdkFont* font = f->AsGdkFont();
  g_return_if_fail (font != NULL);
  gtk_style_set_font (style, font);
  */
}  
/*
this works only on gtk 1.2.5 or greater,
replace above version  when prev gtk releases
will be obsolete.
*/
/*
void 
VDKCanvas::SetBackground(VDKRgb rgb, GtkStateType state = GTK_STATE_NORMAL)
{
  VDKColor *color = new VDKColor(Owner() ? Owner() : this ,
				 rgb.red,rgb.green,rgb.blue);
  GtkStyle* style = widget->style;
  g_return_if_fail(style != NULL);
  style = gtk_style_copy(gtk_widget_get_style(widget));
  gtk_style_ref(style);
  style->bg[state] = *(color->Color());
  gtk_widget_set_style(widget,style);
} 
*/ 
 
 
 
 


