<?	// UUdecode a news article

/* Filename to tell the browser for download */
if( !$filename ) { $filename = "pic.gif"; }

if( !$server ) { $server = "news"; }
if( !$port ) { $port = "119"; }

/* Tables for UUDecoding. These are prepared outside the function, so they are
 * initialised once, and then used for every line that is decoded.
 */

/* prepare a decoding translation table */
for( $i = 0; $i < 256; $i++ ) { $UUxlat[$i] = -1; }

for( $i = ord(' '), $j = 0; $i < ord(' ') + 64; $i++, $j++) { $UUxlat[$i] = $j; }
for( $i = ord('`'), $j = 0; $i < ord('`') + 32; $i++, $j++) { $UUxlat[$i] = $j; }

/* add special cases */
$UUxlat[ord('`')] = $UUxlat[ord(' ')];
$UUxlat[ord('~')] = $UUxlat[ord('^')];

/* prepare a line length table */
$UUxlen[0] = 1;
for($i = 1, $j = 5; $i <= 60; $i += 3, $j += 4) { $UUxlen[$i] = $UUxlen[$i+1] = $UUxlen[$i+2] = $j; }

/* Main loop */

/* HTTP Headers */

header("Cache-Control: public");
header("Content-Type: application/download\n"); 
header("Content-Disposition: attachment; filename=\"$filename\""); 

/* Note: by setting Cache-Control: public, this overrides the no-cache option
 * for twig, and allows the images to be cached. This reduces the number of
 * times an article needs to be fetched from the news server (if possible),
 * this is especially useful for downloading an image after viewing it.
 */

/* 
 * Open a connection to the news server and get the required article, then
 * uudecode the image
 */

$nntpcon = fsockopen( $server, $port, $errno, $errstr );

if( $nntpcon != FALSE ) 
	{
	if( $user ) 
		{
		fwrite( $nntpcon, "authinfo user " . $user . "\r\n" );

		fwrite( $nntpcon, "authinfo pass " . $password . "\r\n" );

		// Get the server's response to the auth request
		TWIGGetServerResponse( $nntpcon, 10 ); 
		}

	fwrite( $nntpcon, "mode reader\r\n" );
	fwrite( $nntpcon, "group " . $group . "\r\n" );

	// Get the server's response to the group selection
	$groupresponse = TWIGGetServerResponse( $nntpcon, 10 ); 

	fwrite( $nntpcon, "body " . $ArticleID . "\r\n" );

	// Get the server's response to the body request
	$bodyresponse = TWIGGetServerResponse( $nntpcon, 10 ); 
	
	$temp = "";

	while( substr( $temp, 0, 1 ) != "." ) 
		{
		$temp = TWIGGetServerResponse( $nntpcon, 10 ) . "\n";
		if( eregi( "^end", $temp ) )
			{
			$uu = false;
			}

		if( $uu ) 
			{
			echo UUDecodeLine( $temp );
			}

		if( eregi( "^begin [0-9][0-9]", $temp ) ) 
			{
			$uu = true;
			}
		}

	fwrite( $nntpcon, "quit\r\n" );
	fclose( $nntpcon );
	}



/*
 * UUdecodeLine - Decodes one uuencoded line and returns the result as a
 * string.
 *
 * Requires that UUxlat and UUxlen be properly initialised
 */
Function UUDecodeLine( $line ) 
	{
	GLOBAL $UUxlat, $UUxlen;

	$s = 0;
	$count = 0;
	$table = $UUxlat;

	$i = $table[ord($line[$s++])];
	$j = $UUxlen[$i] - 1;

	while( $j > 0 ) 
		{
		$c = $table[ord($line[$s++])] << 2;
		$cc = $table[ord($line[$s++])];
		$c |= ($cc >> 4);

		if( $i-- > 0 ) 
			{
			$d[$count++] = chr( $c );
			}

		$cc <<= 4;
		$c = $table[ord($line[$s++])];
		$cc |= ($c >> 2);

		if( $i-- > 0 ) 
			{
			$d[$count++] = chr( $cc );
			}

		$c <<= 6;
		$c |= $table[ord($line[$s++])];

		if( $i-- > 0 ) 
			{
			$d[$count++] = chr( $c );
			}

		$j -= 4;
		}

	if( $d ) 
		{
		return join( '', $d );
		} 
	else 
		{
		return "";
		}
	}

?>

