<?php
// $Horde: turba/lib/base.php,v 1.20.2.4 2003/03/04 16:03:35 chuck Exp $

/*
 * Turba base inclusion file.
 *
 * This file brings in all of the dependencies that every Turba script
 * will need, and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Turba
@define('TURBA_BASE', dirname(__FILE__) . '/..');

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &new Browser();
if ($browser->hasQuirk('cache_ssl_downloads')
    && isset($_SERVER['HTTPS'])
    && ($_SERVER['HTTPS'] == 'on')) {
    session_cache_limiter('private, must-revalidate');
}

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('turba');
$conf = &$GLOBALS['conf'];
@define('TURBA_TEMPLATES', $registry->getParam('templates'));

// set error reporting according to config settings
error_reporting($conf['debug_level']);

// set max execution time according to config settings
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Secret.php';

// Turba base library
require_once TURBA_BASE . '/lib/Turba.php';

// Turba sources configuration
require TURBA_BASE . '/config/sources.php';
$GLOBALS['cfgSources'] = &$cfgSources;

// Help
require_once HORDE_BASE . '/lib/Help.php';

// Don't allow access unless there is a Horde login, or guests are
// allowed.
if (!(Auth::getAuth() || $registry->allowGuests())) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    echo "\n";
    exit;
}

?>
