[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools n 1.0.2]
[copyright {2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Create and manipulate doctools converter object}]
[require Tcl 8.2]
[require doctools [opt 1.0.2]]
[description]

This package provides objects which can be used to convert text
written in the doctools format as specified in [cmd dtformat(n)]
into any output format X, assuming that a formatting engine for X is
available and provides the interface specified in
[cmd dtformatter(n)].

[section API]

[list_begin definitions]

[call [cmd ::doctools::new] [arg objectName] [opt [arg "option value"]...]]

Creates a new doctools object with an associated global Tcl command
whose name is [arg objectName]. This command is explained in full
detail in the sections [sectref {OBJECT COMMAND}] and

[sectref {OBJECT METHODS}].

[nl]

The list of options and values coming after the name of the object is
used to set the initial configuration of the object.

[call [cmd ::doctools::help]]

This is a pure convenience command for applications which want to
provide their user with a reminder of the available formatting
commands and their meanings. It returns a string containing a standard
help for this purpose.


[call [cmd ::doctools::search] [arg path]]

Whenever the package has to map the name of a format to the file
containing the code for its formatting engine it will search the file
in a number of directories. Three such directories are declared by the
package itself.

[nl]

However the list is extensible by the user of the package and the
command above is the means to do so. When given a [arg path] to an
existing and readable directory it will prepend that directory to the
existing list. This means that the path added last is searched through
first.

[nl]

An error will be thrown if the [arg path] either does not excist, is
not a directory, or is not readable.

[list_end]

[section {OBJECT COMMAND}]

All commands created by [cmd ::doctools::new] have the following
general form and may be used to invoke various operations on the
object they are associated with.

[list_begin definitions]

[call [cmd objectName] [arg option] [opt [arg "arg arg ..."]]]

The [arg option] and its [arg arg]s determine the exact behavior of
the command. See section [sectref {OBJECT METHODS}] for more
explanations.

[list_end]

[section {OBJECT METHODS}]

[list_begin definitions]

[call [arg objectName] [method configure]]

When called without argument this method returns a list of all known
options and their current values.

[call [arg objectName] [method configure] [arg option]]

When called with a single argument this method behaves like
[method cget].

[call [arg objectName] [method configure] [arg "option value"]...]

When called with more than one argument the method reconfigures the
object using the [arg option]s and [arg value]s given to it.

[nl]

The legal configuration options are described in section
[sectref {OBJECT CONFIGURATION}].

[call [arg objectName] [method cget] [arg option]]

This method expects a legal configuration option as argument and
returns the current value of that option for the object the method was
invoked for.

[nl]

The legal configuration options are described in section
[sectref {OBJECT CONFIGURATION}].

[call [arg objectName] [method destroy]]

Destroys the object it is invoked for.

[call [arg objectName] [method format] [arg text]]

Takes the [arg text] and runs it through the configured formatting
engine. The resulting string is returned as the result of this
method. An error will be thrown if no [option -format] was configured
for the object.

[nl]

The method assumes that the [arg text] is in doctools format as
specified in [cmd dtformat(n)]. Errors will be thrown otherwise.


[call [arg objectName] [method search] [arg path]]

This method extends the per-object list of paths searched for
formatting engines. See also [cmd ::doctools::search] on how to extend
the global (per-package) list of paths.

[nl]

The path entered last is searched through first.

[call [arg objectName] [method warnings]]

Returns a list containing all the warnings generated by the engine
during the last invocation of method [method format].

[list_end]

[section {OBJECT CONFIGURATION}]

All doctools objects understand the following configuration options:

[list_begin definitions]

[lst_item "[option -file] [arg file]"]

The argument of this option is stored in the object and can be
retrieved by the formatting engine via the command [cmd dt_file] (see
[cmd dtformatter(n)]). Its default value is the empty string.

[nl]

It will be interpreted as the name of the file containing the text
currently processed by the engine.

[lst_item "[option -module] [arg text]"]

The argument of this option is stored in the object and can be
retrieved by the formatting engine via the command [cmd dt_module]
(see [cmd dtformatter(n)]). Its default value is the empty string.

[nl]

It will be interpreted as the name of the module the file containing
the text currently processed by the engine belongs to.

[lst_item "[option -format] [arg text]"]

The argument of this option specifies the format and thus the engine
to use when converting text via [method format]. Its default value is
the empty string. No formatting is possible if this
option is not set at least once.

[nl]

The package will immediately try to map the name of the format to a
file containing the implementation of the engine for that format. An
error will be thrown if this mapping fails and a previously configured
format is left untouched.

[nl]

Section [sectref {FORMAT MAPPING}] explains how
the package looks for engine implementations.

[lst_item "[option -deprecated] [arg boolean]"]

This option is a flag. If set the object will generate warnings when
formatting a text containing the deprecated markup command [cmd strong]
Its default value is [const FALSE]. In other words, no warnings will
be generated.

[list_end]

[section {FORMAT MAPPING}]

When trying to map a format name [term foo] to the file containing
the implementation of formatting engine for [term foo] the package
will perform the following algorithm:

[list_begin enum]
[enum]

If [term foo] is the name of an existing file this file is directly
taken as the implementation.

[enum]

If not, the list of per-object search paths is searched. For each
directory in the list the package checks if that directory contains a
file [file fmt.[term foo]]. If yes, that file is taken as the
implementation.

[nl]

This list of paths is initially empty and can be extended through the
object method [method search].

[enum]

If not, the list of global (package) paths is searched. For each
directory in the list the package checks if that directory contains a
file [file fmt.[term foo]]. If yes, that file is taken as the
implementation.

[nl]

This list of paths contains initially one path and can be extended
through the command [cmd ::doctools::search].

[nl]

The initial (standard) path is the sub directory [file mpformats] of
the directory the package itself is located in. In other words, if the
package implementation [file doctools.tcl] is installed in the
directory [file /usr/local/lib/tcllib/doctools] then it will by
default search the directory

[file /usr/local/lib/tcllib/doctools/mpformats] for format
implementations.

[enum]

The mapping fails.

[list_end]


[section {ENGINES}]

The package comes with the following predefined formatting engines

[list_begin definitions]
[lst_item html]

This engine generates HTML markup, for processing by web browsers and
the like.

[lst_item latex]

This engine generates output suitable for the [syscmd latex] text
processor coming out of the TeX world.

[lst_item list]

This engine retrieves version, section and title of the manpage from
the document. As such it can be used to generate a directory listing
for a set of manpages.

[lst_item nroff]

This engine generates nroff output, for processing by [syscmd nroff],
or [syscmd groff]. The result will be standard man pages as they are
known in the unix world.

[lst_item null]

This engine generates no outout at all. This can be used if one just
wants to validate some input.

[lst_item tmml]

This engine generates TMML markup as specified by Joe English. The Tcl
Manpage Markup Language is a derivate of XML.

[lst_item wiki]

This engine generates Wiki markup as understood by Jean Claude
Wippler's [syscmd wikit] application.

[list_end]

[see_also doctools_api doctools_fmt]
[keywords toc {table of contents} index documentation manpage TMML HTML nroff conversion markup]
[manpage_end]
