/*
 *  smpeg-xmms - (S)MPEG Plugin for XMMS
 *  Copyright (C) 2000-2001 4Front Technologies
 *  http://www.opensound.com
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include <gtk/gtk.h>
#include <config.h>

#include <xmms/configfile.h>
#include "smpeg-xmms.h"

static GtkWidget *configure_win = NULL;
static GtkWidget *vbox, *video_options_frame, *video_options_vbox;
static GtkWidget *video_options_smpeg_double, *video_options_smpeg_fullscreen,
	*video_options_smpeg_center, *video_options_smpeg_states,
	*video_options_smpeg_windowsize, *video_options_smpeg_ratio,
	*video_options_smpeg_wratio, *video_options_smpeg_window,
	*video_options_smpeg_filter, *video_options_smpeg_xmmsaudio,
	*video_options_smpeg_audioonly, *video_options_smpeg_samevideo;

static GtkWidget *bbox, *ok, *cancel;

static void configure_ok(GtkWidget * w, gpointer data)
{
	ConfigFile *cfg;

	smpeg_cfg.double_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_double));
	smpeg_cfg.fullscreen_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_fullscreen));
	smpeg_cfg.center_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_center));
	smpeg_cfg.states_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_states));
	smpeg_cfg.windowsize_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_windowsize));
	smpeg_cfg.ratio_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_ratio));
	smpeg_cfg.wratio_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_wratio));
	smpeg_cfg.window_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_window));
	smpeg_cfg.filter_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_filter));
	smpeg_cfg.xmmsaudio_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_xmmsaudio));
	smpeg_cfg.audioonly_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_audioonly));
	smpeg_cfg.samevideo_mode =
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
					     (video_options_smpeg_samevideo));
	cfg = xmms_cfg_open_default_file();
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_double",
			       smpeg_cfg.double_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_fullscreen",
			       smpeg_cfg.fullscreen_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_center",
			       smpeg_cfg.center_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_states",
			       smpeg_cfg.states_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_windowsize",
			       smpeg_cfg.windowsize_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_ratio",
			       smpeg_cfg.ratio_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_wratio",
			       smpeg_cfg.wratio_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_window",
			       smpeg_cfg.window_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_filter",
			       smpeg_cfg.filter_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_xmmsaudio",
			       smpeg_cfg.xmmsaudio_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_audioonly",
			       smpeg_cfg.audioonly_mode);
	xmms_cfg_write_boolean(cfg, "smpeg-xmms", "smpeg_samevideo",
			       smpeg_cfg.samevideo_mode);
	xmms_cfg_write_default_file(cfg);
	xmms_cfg_free(cfg);

	gtk_widget_destroy(configure_win);
}

void smpeg_configure(void)
{
	if (configure_win)
		return;

	smpeg_read_config();

	configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_set_border_width(GTK_CONTAINER(configure_win), 10);
	gtk_window_set_title(GTK_WINDOW(configure_win),
			     (PACKAGE " " VERSION " configuration"));
	gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE);
	gtk_signal_connect(GTK_OBJECT(configure_win), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			   &configure_win);

	vbox = gtk_vbox_new(FALSE, 5);

	video_options_frame = gtk_frame_new(("smpeg-xmms options:"));
	gtk_container_set_border_width(GTK_CONTAINER(video_options_frame), 5);

	video_options_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(video_options_vbox), 5);

	video_options_smpeg_double =
		gtk_check_button_new_with_label(("Start in doublesize mode"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_double),
				     smpeg_cfg.double_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_double, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_double);

	video_options_smpeg_fullscreen =
		gtk_check_button_new_with_label(("Start in fullscreen mode"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_fullscreen),
				     smpeg_cfg.fullscreen_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_fullscreen, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_fullscreen);

	video_options_smpeg_center =
		gtk_check_button_new_with_label(("Start with centered window"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_center),
				     smpeg_cfg.center_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_center, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_center);

	video_options_smpeg_states =
		gtk_check_button_new_with_label(("Save state between sessions"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_states),
				     smpeg_cfg.states_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_states, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_states);

	video_options_smpeg_windowsize =
		gtk_check_button_new_with_label(("Save windowsize between sessions"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_windowsize),
				     smpeg_cfg.windowsize_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_windowsize, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_windowsize);

	video_options_smpeg_window =
		gtk_check_button_new_with_label(("Close video window between sessions"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_window),
				     smpeg_cfg.window_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_window, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_window);

	video_options_smpeg_ratio =
		gtk_check_button_new_with_label(("Do NOT keep aspected ratio in fullscreen"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_ratio),
				     smpeg_cfg.ratio_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_ratio, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_ratio);

	video_options_smpeg_wratio =
		gtk_check_button_new_with_label(("Do NOT keep aspected ratio when resizing video window"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_wratio),
				     smpeg_cfg.wratio_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_wratio, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_wratio);

	video_options_smpeg_filter =
		gtk_check_button_new_with_label(("Use software bilinear filtering"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_filter),
				     smpeg_cfg.filter_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_filter, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_filter);

	video_options_smpeg_samevideo =
		gtk_check_button_new_with_label(("Use same resolution as X when using fullscreen"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_samevideo),
				     smpeg_cfg.samevideo_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_samevideo, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_samevideo);


	video_options_smpeg_xmmsaudio =
		gtk_check_button_new_with_label(("Use XMMS Audio system"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_xmmsaudio),
				     smpeg_cfg.xmmsaudio_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_xmmsaudio, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_xmmsaudio);

	video_options_smpeg_audioonly =
		gtk_check_button_new_with_label(("Audio only (no video)"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
				     (video_options_smpeg_audioonly),
				     smpeg_cfg.audioonly_mode);
	gtk_box_pack_start(GTK_BOX(video_options_vbox),
			   video_options_smpeg_audioonly, FALSE, FALSE, 0);
	gtk_widget_show(video_options_smpeg_audioonly);

	gtk_container_add(GTK_CONTAINER(video_options_frame),
			  video_options_vbox);
	gtk_widget_show(video_options_vbox);
	
	gtk_box_pack_start(GTK_BOX(vbox), video_options_frame, TRUE, TRUE, 0);
	gtk_widget_show(video_options_frame);

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

	ok = gtk_button_new_with_label(("Ok"));
	gtk_signal_connect(GTK_OBJECT(ok), "clicked",
			   GTK_SIGNAL_FUNC(configure_ok), NULL);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
	gtk_widget_show(ok);


	cancel = gtk_button_new_with_label(("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(configure_win));
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
	gtk_widget_show(cancel);
	gtk_widget_show(bbox);

	gtk_container_add(GTK_CONTAINER(configure_win), vbox);
	gtk_widget_show(vbox);
	gtk_widget_show(configure_win);
	gtk_widget_grab_default(ok);
}
