//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

#ifndef SIGC_PERL_SIGNAL_BASE_H
#define SIGC_PERL_SIGNAL_BASE_H

#include <assert.h>
#include <sigc++/signal.h>
#include <sigc++/object.h>

extern "C" {
#include "EXTERN.h"
#include "perl.h"
}

#include <sigcperl/data.h>
#include <sigcperl/slot.h>
#include <sigcperl/convert.h>

namespace SigCPerl {

class SignalBase : virtual public SigC::Object
{
 public:
  SignalBase() {}
  virtual ~SignalBase() {}

  virtual SigC::Connection connect(const Slot &slot) throw() = 0;
  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal) = 0;
  Slot slot() throw();

 private:
  SignalBase(const SignalBase&);
  SignalBase& operator=(const SignalBase&);
};

// FIXME give this configurabe marshaller
class SignalPerl : public SignalBase
{
 public:
  SignalPerl() {}

  virtual SigC::Connection connect(const Slot &slot) throw()
	{return m_signal.connect(slot.slot());}
  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
	{return m_signal.emit(data, flags);}

 private:
  SignalPerl(const SignalPerl&);
  SignalPerl& operator=(const SignalPerl&);

  SigC::Signal2<Data,const Data&,I32> m_signal;
};

// This class holds a reference to a "parent" SV,
// so that each signal wrapper can keep, e.g., the
// blessed instance of the class which contains the signal
// it has a reference to from being destroyed.
class ParentBox {
 public:
  ParentBox(SV*);
  ~ParentBox();
 private:
  ParentBox(const ParentBox&);
  SV *m_parent;
};

} // namespace SigCPerl

#endif // SIGC_PERL_SIGNAL_BASE_H
