#include "boolentry.h"

static void checkBoxToggled(GtkToggleButton* widget, BoolEntry* data)
{
        data->changed();
}

BoolEntry::BoolEntry(const string& varName, const Path& mod_, ModifierEntryListener& parent_, bool owner)
        : ModifierEntry(varName, mod_, parent_, owner)
{ 
        valueWidget = gtk_check_button_new_with_label(const_cast<gchar*> (varName.c_str()));
        gtk_signal_connect(GTK_OBJECT(valueWidget), "toggled", GTK_SIGNAL_FUNC(checkBoxToggled), this);
        reload();
        gtk_box_pack_start(GTK_BOX(hbox), valueWidget, false, false, 3);
        gtk_widget_show(valueWidget);
}

DataSet BoolEntry::getValue()
{
        bool newValue = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(valueWidget));
        return DataSet(newValue);
}

void BoolEntry::setValue(const DataSet& value)
{
        if (value.count() > 0)
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(valueWidget), value.getBool());
}
