// 
// $Id: qaregexprange.hpp,v 1.2 1999/07/19 02:36:55 amos Exp $
//
// Definition of QaRegExpRange class
//
// Jan Borsodi <amos@ez.no>
// Created on: <15-Jul-1999 13:42:58 amos>
//

#ifndef QAREGEXPRANGE_HPP
#define QAREGEXPRANGE_HPP

#include <qstring.h>

class QaRegExpRange
{
public:
    QaRegExpRange();
    QaRegExpRange( int soffs, int eoffs );
    ~QaRegExpRange();

    int start() const;
    int end() const;
    int length() const;
    void setStart( int s );
    void setEnd( int e );

    QString stringRange( const QString &s ) const;

    QaRegExpRange &operator +=( int i );
    QaRegExpRange &operator -=( int i );

private:
    int Start, End;
};


#endif // QAREGEXPRANGE_HPP
