#
# libplot.py
#
# Copyright (C) 2000 Mike Nolta <mrnolta@users.sourceforge.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

from _libplot import *

class LibplotError( Exception ):
	pass

class Plotter:
	def __init__( self, type="X", params=None,
			outfile=None, infile=None, errfile=None ):

		self.plparams = pl_newplparams()
		if params:
			for key,value in params.items():
				pl_setplparam( self.plparams, key, value )

		self.this = pl_newpl_r( type, infile, outfile, errfile, self.plparams )
		if self.this < 0:
			raise LibplotError( "could not create plotter" )

	def __del__( self ):
		pl_deletepl_r( self.this )
		pl_deleteplparams( self.plparams )

	def arc(self,xc,yc,x0,y0,x1,y1):
		return pl_arc_r(self.this,xc,yc,x0,y0,x1,y1)

	def box(self,x0,y0,x1,y1):
		return pl_box_r(self.this,x0,y0,x1,y1)

	def circle(self,x,y,r):
		return pl_circle_r(self.this,x,y,r)

	def closepl(self):
		return pl_closepl_r(self.this)

	def cont(self,x,y):
		return pl_cont_r(self.this,x,y)

	def erase(self):
		return pl_erase_r(self.this)

	def label(self,s):
		return pl_label_r(self.this,s)

	def line(self,x0,y0,x1,y1):
		return pl_line_r(self.this,x0,y0,x1,y1)

	def linemod(self,s):
		return pl_linemod_r(self.this,s)

	def move(self,x,y):
		return pl_move_r(self.this,x,y)

	def openpl(self):
		return pl_openpl_r(self.this)

	def point(self,x,y):
		return pl_point_r(self.this,x,y)

	def space(self,x0,y0,x1,y1):
		return pl_space_r(self.this,x0,y0,x1,y1)

	def alabel(self,x_justify,y_justify,s):
		return pl_alabel_r(self.this,x_justify,y_justify,s)

	def arcrel(self,dxc,dyc,dx0,dy0,dx1,dy1):
		return pl_arcrel_r(self.this,dxc,dyc,dx0,dy0,dx1,dy1)

	def bezier2(self,x0,y0,x1,y1,x2,y2):
		return pl_bezier2_r(self.this,x0,y0,x1,y1,x2,y2)

	def bezier2rel(self,dx0,dy0,dx1,dy1,dx2,dy2):
		return pl_bezier2rel_r(self.this,dx0,dy0,dx1,dy1,dx2,dy2)

	def bezier3(self,x0,y0,x1,y1,x2,y2,x3,y3):
		return pl_bezier3_r(self.this,x0,y0,x1,y1,x2,y2,x3,y3)

	def bezier3rel(self,dx0,dy0,dx1,dy1,dx2,dy2,dx3,dy3):
		return pl_bezier3rel_r(self.this,dx0,dy0,dx1,dy1,dx2,dy2,dx3,dy3)

	def bgcolor(self,red,green,blue):
		return pl_bgcolor_r(self.this,red,green,blue)

	def bgcolorname(self,name):
		return pl_bgcolorname_r(self.this,name)

	def boxrel(self,dx0,dy0,dx1,dy1):
		return pl_boxrel_r(self.this,dx0,dy0,dx1,dy1)

	def capmod(self,s):
		return pl_capmod_r(self.this,s)

	def circlerel(self,dx,dy,r):
		return pl_circlerel_r(self.this,dx,dy,r)

	def closepath(self):
		return pl_closepath_r(self.this)

	def color(self,red,green,blue):
		return pl_color_r(self.this,red,green,blue)

	def colorname(self,name):
		return pl_colorname_r(self.this,name)

	def contrel(self,x,y):
		return pl_contrel_r(self.this,x,y)

	def ellarc(self,xc,yc,x0,y0,x1,y1):
		return pl_ellarc_r(self.this,xc,yc,x0,y0,x1,y1)

	def ellarcrel(self,dxc,dyc,dx0,dy0,dx1,dy1):
		return pl_ellarcrel_r(self.this,dxc,dyc,dx0,dy0,dx1,dy1)

	def ellipse(self,x,y,rx,ry,angle):
		return pl_ellipse_r(self.this,x,y,rx,ry,angle)

	def ellipserel(self,dx,dy,rx,ry,angle):
		return pl_ellipserel_r(self.this,dx,dy,rx,ry,angle)

	def endpath(self):
		return pl_endpath_r(self.this)

	def endsubpath(self):
		return pl_endsubpath_r(self.this)

	def fillcolor(self,red,green,blue):
		return pl_fillcolor_r(self.this,red,green,blue)

	def fillcolorname(self,name):
		return pl_fillcolorname_r(self.this,name)

	def fillmod(self,s):
		return pl_fillmod_r(self.this,s)

	def filltype(self,level):
		return pl_filltype_r(self.this,level)

	def flushpl(self):
		return pl_flushpl_r(self.this)

	def fontname(self,s):
		return pl_fontname_r(self.this,s)

	def fontsize(self,size):
		return pl_fontsize_r(self.this,size)

	def havecap(self,s):
		return pl_havecap_r(self.this,s)

	def joinmod(self,s):
		return pl_joinmod_r(self.this,s)

	def labelwidth(self,s):
		return pl_labelwidth_r(self.this,s)

	def linedash(self,n,dashes,offset):
		return pl_linedash_r(self.this,n,dashes,offset)

	def linerel(self,dx0,dy0,dx1,dy1):
		return pl_linerel_r(self.this,dx0,dy0,dx1,dy1)

	def linewidth(self,size):
		return pl_linewidth_r(self.this,size)

	def marker(self,x,y,type,size):
		return pl_marker_r(self.this,x,y,type,size)

	def markerrel(self,dx,dy,type,size):
		return pl_markerrel_r(self.this,dx,dy,type,size)

	def moverel(self,x,y):
		return pl_moverel_r(self.this,x,y)

	def orientation(self,direction):
		return pl_orientation_r(self.this,direction)

	def pencolor(self,red,green,blue):
		return pl_pencolor_r(self.this,red,green,blue)

	def pencolorname(self,name):
		return pl_pencolorname_r(self.this,name)

	def pentype(self,level):
		return pl_pentype_r(self.this,level)

	def pointrel(self,dx,dy):
		return pl_pointrel_r(self.this,dx,dy)

	def restorestate(self):
		return pl_restorestate_r(self.this)

	def savestate(self):
		return pl_savestate_r(self.this)

	def space2(self,x0,y0,x1,y1,x2,y2):
		return pl_space2_r(self.this,x0,y0,x1,y1,x2,y2)

	def textangle(self,angle):
		return pl_textangle_r(self.this,angle)

	def ffontname(self,s):
		return pl_ffontname_r(self.this,s)

	def ffontsize(self,size):
		return pl_ffontsize_r(self.this,size)

	def flabelwidth(self,s):
		return pl_flabelwidth_r(self.this,s)

	def ftextangle(self,angle):
		return pl_ftextangle_r(self.this,angle)

	def farc(self,xc,yc,x0,y0,x1,y1):
		return pl_farc_r(self.this,xc,yc,x0,y0,x1,y1)

	def farcrel(self,dxc,dyc,dx0,dy0,dx1,dy1):
		return pl_farcrel_r(self.this,dxc,dyc,dx0,dy0,dx1,dy1)

	def fbezier2(self,x0,y0,x1,y1,x2,y2):
		return pl_fbezier2_r(self.this,x0,y0,x1,y1,x2,y2)

	def fbezier2rel(self,dx0,dy0,dx1,dy1,dx2,dy2):
		return pl_fbezier2rel_r(self.this,dx0,dy0,dx1,dy1,dx2,dy2)

	def fbezier3(self,x0,y0,x1,y1,x2,y2,x3,y3):
		return pl_fbezier3_r(self.this,x0,y0,x1,y1,x2,y2,x3,y3)

	def fbezier3rel(self,dx0,dy0,dx1,dy1,dx2,dy2,dx3,dy3):
		return pl_fbezier3rel_r(self.this,dx0,dy0,dx1,dy1,dx2,dy2,dx3,dy3)

	def fbox(self,x0,y0,x1,y1):
		return pl_fbox_r(self.this,x0,y0,x1,y1)

	def fboxrel(self,dx0,dy0,dx1,dy1):
		return pl_fboxrel_r(self.this,dx0,dy0,dx1,dy1)

	def fcircle(self,x,y,r):
		return pl_fcircle_r(self.this,x,y,r)

	def fcirclerel(self,dx,dy,r):
		return pl_fcirclerel_r(self.this,dx,dy,r)

	def fcont(self,x,y):
		return pl_fcont_r(self.this,x,y)

	def fcontrel(self,dx,dy):
		return pl_fcontrel_r(self.this,dx,dy)

	def fellarc(self,xc,yc,x0,y0,x1,y1):
		return pl_fellarc_r(self.this,xc,yc,x0,y0,x1,y1)

	def fellarcrel(self,dxc,dyc,dx0,dy0,dx1,dy1):
		return pl_fellarcrel_r(self.this,dxc,dyc,dx0,dy0,dx1,dy1)

	def fellipse(self,x,y,rx,ry,angle):
		return pl_fellipse_r(self.this,x,y,rx,ry,angle)

	def fellipserel(self,dx,dy,rx,ry,angle):
		return pl_fellipserel_r(self.this,dx,dy,rx,ry,angle)

	def flinedash(self,n,dashes,offset):
		return pl_flinedash_r(self.this,n,dashes,offset)

	def fline(self,x0,y0,x1,y1):
		return pl_fline_r(self.this,x0,y0,x1,y1)

	def flinerel(self,dx0,dy0,dx1,dy1):
		return pl_flinerel_r(self.this,dx0,dy0,dx1,dy1)

	def flinewidth(self,size):
		return pl_flinewidth_r(self.this,size)

	def fmarker(self,x,y,type,size):
		return pl_fmarker_r(self.this,x,y,type,size)

	def fmarkerrel(self,dx,dy,type,size):
		return pl_fmarkerrel_r(self.this,dx,dy,type,size)

	def fmove(self,x,y):
		return pl_fmove_r(self.this,x,y)

	def fmoverel(self,dx,dy):
		return pl_fmoverel_r(self.this,dx,dy)

	def fpoint(self,x,y):
		return pl_fpoint_r(self.this,x,y)

	def fpointrel(self,dx,dy):
		return pl_fpointrel_r(self.this,dx,dy)

	def fspace(self,x0,y0,x1,y1):
		return pl_fspace_r(self.this,x0,y0,x1,y1)

	def fspace2(self,x0,y0,x1,y1,x2,y2):
		return pl_fspace2_r(self.this,x0,y0,x1,y1,x2,y2)

	def fconcat(self,m0,m1,m2,m3,m4,m5):
		return pl_fconcat_r(self.this,m0,m1,m2,m3,m4,m5)

	def fmiterlimit(self,limit):
		return pl_fmiterlimit_r(self.this,limit)

	def frotate(self,theta):
		return pl_frotate_r(self.this,theta)

	def fscale(self,x,y):
		return pl_fscale_r(self.this,x,y)

	def fsetmatrix(self,m0,m1,m2,m3,m4,m5):
		return pl_fsetmatrix_r(self.this,m0,m1,m2,m3,m4,m5)

	def ftranslate(self,x,y):
		return pl_ftranslate_r(self.this,x,y)
