// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.
#include "vcache.h"

namespace visual {

Cache::Cache()
	: lastRefresh(0)
{
}

Cache::Cache( const Cache& other)
	: lastRefresh(other.lastRefresh)
{
}

Cache::~Cache() 
{
}

int Cache::lastChange() 
{
	return mtx.sync_count();
}

void Cache::updateCache() 
{
 	// If the primitive has changed since cache was last refreshed
	int change = mtx.sync_count();
	if (change != lastRefresh) {
		lastRefresh = change;
		refreshCache();
	}
}

} // !namespace visual
