#ifndef VISUAL_GLDEVICE_H
#define VISUAL_GLDEVICE_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "cvisual.h"
#include "platform.h"
#include "display.h"
#include GL_INCLUDE    // see platform.h

#include "kbobject.h"
#include "mouseobject.h"

namespace visual {

const float clickTolerance = 3.0F; // pixel tolerance

/*
 * Wraps around a platform-specific glContext.
 */
class GLDevice : public Device 
{
  public:
    int render_control();

    GLDevice();
    ~GLDevice();

    // Device interface:
    virtual bool show();
    virtual void hide();
    virtual void join();
    virtual void frame();
    virtual bool closed();
    virtual std::string info();
    virtual void onClose( bool quit) { quitOnClose = quit; };

    virtual tmatrix get_wct() { return last_wct; }

    virtual void setX( int);
    virtual void setY( int);
    virtual void setWidth( int);
    virtual void setHeight( int);
    virtual void setFullScreen( bool fs);
    virtual void setStereo( stereotype mode);
    virtual void setStereoDepth( float);
    virtual void setNewmouse( bool);
    virtual int getX();
    virtual int getY();
    virtual int getWidth();
    virtual int getHeight();
    virtual bool getFullScreen() const;
    virtual stereotype getStereo() const;
    virtual float getStereoDepth() const;
    virtual glContext& get_context() { return cx; }

  private:
    enum {HIDE, SHOW, DISPLAY, FRAME} mode;
    enum {INITIALIZE, NOBUTTONS, PRESS, DRAG, CLICK, DROP, ZOOM, SPIN} mouse_mode, last_mouse_mode;
	
	stereotype initstereo;
	float stereodepth;
	
	thread_safe<bool, mutex> active;

	double manual_scale;
	platform_glContext cx;
	int initx, inity, initw, inith, initfull;
	bool newmouse_enabled;
	bool quitOnClose;

	std::string vendor, version, renderer, extensions, error_message;

	unsigned oldButtons;
	clickObject lastEvent;
	tmatrix proj, iproj, manual;
	float clickDelta;

	thread_safe<tmatrix, mutex> last_wct;

	void getProjection( tmatrix& wct, vector& cam, int eyesign = 0);
	vector calcMousePos( vector);
	void mouseControl( vector pos, vector cam, vector ray, boost::shared_ptr<DisplayObject> pick, vector pickpos);
	void kbControl();

	void draw( int eyeOffset = 0, 
	           bool pick = true, 
	           bool anaglyph = false, 
	           bool coloranaglyph = false);
	// Render and picking code. eyeOffset: -1 left, 0 camera, 1 right
	//  If pick is true, also do mouse control
	// If anaglyph is true, we're doing redblue or redcyan or yellowblue stereo
	// If coloranaglyph is true, we're doing redcyan or yellowblue stereo
	void addCallback();
	static bool callback( GLDevice*);
};

} // !namespace visual

#endif // !VISUAL_GLDEVICE_H
