########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/XPath/MathFunctions.py,v 1.6 2005/02/09 11:10:54 mbrown Exp $
"""
4XPath-specific math extension functions

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import math

from Ft.Xml.XPath import Conversions, FT_EXT_NAMESPACE


def Sin(context, x):
    "math.sin"
    return math.sin(Conversions.NumberValue(x))

def Cos(context, x):
    "math.cos"
    return math.cos(Conversions.NumberValue(x))

def DegreesToRads(context, x):
    "Convert degrees to radians"
    return Conversions.NumberValue(x)/180*math.pi

def Fact(context, x):
    "Factorial"
    x = Conversions.NumberValue(x)
    if x > 1:
        return reduce(lambda x,y: x*y, xrange(1,x+1), 1)
    return 1


ExtNamespaces = {
    FT_EXT_NAMESPACE : 'f',
    }

ExtFunctions = {
    (FT_EXT_NAMESPACE, 'cos'): Cos,
    (FT_EXT_NAMESPACE, 'sin'): Sin,
    (FT_EXT_NAMESPACE, 'degrees-to-rads'): DegreesToRads,
    (FT_EXT_NAMESPACE, 'fact'): Fact,
    }

