########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Update/__init__.py,v 1.6 2004/08/20 21:11:04 mbrown Exp $
"""
Implementation of '4ss update' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command will replace the content of an existing \
resource in a 4Suite repository, reading in the new content from a \
file on the local filesystem, for example. A subcommand specifying \
which type of resource to update is required. See the help message for \
a subcommand for specific usage info."""

# command modules to register as subcommands
import Document
import Extension
import RawFile

g_subCommands = [
   Document,
   RawFile,
   Extension,
   ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('update',
                          "Update the content of a resource in a repository",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )
    return cmd

