  /*  main.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   *
   *  Thanks to James Greenhalgh <james@tsunami.disintegration.org> for
   *  finding that obnoxious make/tcsh bug.
   */

#include "powershell.h"

extern int size_x, size_y;

key_preferences keyprefs;

char * exec_me;
char * geom;

struct poptOption cmd_options[] = {
  {"execute", 'e', POPT_ARG_STRING, &exec_me, 0, N_("Start PowerShell with a different program")},
  {"geometry", 'g', POPT_ARG_STRING, &geom, 0, N_("Sets the window geometry")},
  {NULL, 0, 0, NULL, 0}
};

void configure_event (GtkWidget * widget, GdkEvent * event, gpointer callback_data);

GtkWidget * statusbar;
int window_shown = 0;

extern GnomeUIInfo menubar[5], * file_menu2;

int main (int argc, char *argv[])
{
  int i, c, cmdindex;
  int a;
  char buffer[60], **p;
  GtkWidget * hbox, *vbox;


  enum { RIGHT, LEFT } scrollpos = LEFT;

  gchar tmpstr[512];
  char * tmp;
  gchar *temparr[1][1];

  GtkBox * buttonbox;

  char command[512], args[512];
  char origcommand[512];

  char tempstr[256];	     

  char * title;

  int pid;

  GtkWidget * term;

  int xpos, ypos, width, height;

  int ros2;

  /* set up terminal environment */

  size_x = 80;
  size_y = 24;

  pid = getpid();

  bzero (&keyprefs, sizeof(keyprefs));

  /* set default keyboard shortcuts */

  keyprefs.cycle_backwards.modifiers = 1;
  keyprefs.cycle_backwards.key = GDK_ISO_Left_Tab;

  keyprefs.cycle_forwards.modifiers = 4;
  keyprefs.cycle_forwards.key = GDK_Tab;

  keyprefs.move_forwards.modifiers = 1;
  keyprefs.move_forwards.key = GDK_Right;

  keyprefs.move_backwards.modifiers = 1;
  keyprefs.move_backwards.key = GDK_Left;


  keyprefs.close.modifiers = 4;
  keyprefs.close.key = GDK_w;

  keyprefs.quit.modifiers = 4;
  keyprefs.quit.key = GDK_q;

  for (a=0;a<9;a++)
    {
      keyprefs.specific_term[a].modifiers = 4;
      keyprefs.specific_term[a].key = GDK_1 + a;
    }

  keyprefs.specific_term[9].modifiers = 4;
  keyprefs.specific_term[9].key = GDK_0;


  strcpy (Prefs.http_handler, "/usr/bin/lynx");
  strcpy (Prefs.ftp_handler, "/usr/bin/ncftp");
  strcpy (Prefs.mail_handler, "/usr/bin/pine");
  strcpy (Prefs.telnet_handler, "/usr/bin/telnet");

  ColorPrefs.initialized=0;
  Prefs.notebookpos = GTK_POS_TOP;
  Prefs.run_def_shell = 1;

  InitRCFile();
  
  strcpy (FONT, Prefs.font);
  
  
  if (Prefs.scrollbacklines)
    scrollbacklines = Prefs.scrollbacklines;
  else
    scrollbacklines = 100;

  env = environ;
  
  
  for (p = env; *p; p++);
  i = p - env;
  env_copy = (char **) g_malloc (sizeof (char *) * (i + 4));
  for (i = 0, p = env; *p; p++) {
    if (strncmp (*p, "TERM=", 5) == 0) {
      env_copy [i++] = "TERM=xterm";
    } else if ((strncmp (*p, "COLUMNS=", 8) == 0) ||
	       (strncmp (*p, "LINES=", 6) == 0)) {
      continue;
    } else {
      env_copy [i++] = *p;
    }
  }

  sprintf (tempstr, "POWERSHELL=%d", pid);
  
  env_copy [i++] = "COLORTERM=color-xterm";
  env_copy [i++] = tempstr;
  env_copy [i] = NULL;
  
  /*  gtk_init(&argc, &argv); */
 
  exec_me = NULL;
  
  gnome_init_with_popt_table ("powershell", POWERSHELL_VERSION, argc, argv, cmd_options,
			      0, NULL);  
  /* Create widgets and set options */

  window = gnome_app_new ("powershell", "PowerShell");


  /*  gtk_window_set_title (GTK_WINDOW (window), "PowerShell");
  gtk_window_set_wmclass (GTK_WINDOW (window), "powershell", "powershell");
  */
  
  vbox = gtk_vbox_new (FALSE, 0); 
  /*gtk_container_add (GTK_CONTAINER (window), vbox);*/
  gnome_app_set_contents (GNOME_APP(window), vbox);

  gtk_widget_realize(window);

  gtk_widget_show (vbox);

  statusbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_NEVER);
  gnome_app_set_statusbar(GNOME_APP(window), statusbar);

  InitMenus (window);

  gnome_app_install_menu_hints (GNOME_APP(window),menubar);
  gnome_app_install_menu_hints (GNOME_APP(window),file_menu2);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_set_spacing (GTK_BOX (hbox), 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

  gtk_widget_show (hbox);

  /* create notebook */
  
  notebook = gtk_notebook_new ();

  if (Prefs.notebookpos < 4)
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK(notebook), Prefs.notebookpos);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK(notebook), Prefs.notebookpos!=4);

  GTK_WIDGET_UNSET_FLAGS (notebook, GTK_CAN_FOCUS);

  gtk_notebook_set_scrollable (GTK_NOTEBOOK(notebook), TRUE);
  gtk_notebook_popup_enable (GTK_NOTEBOOK(notebook));

  gtk_container_add (GTK_CONTAINER(hbox), notebook);
  

  
  if (geom)
    {
      gnome_parse_geometry (geom, &xpos, &ypos, &width, &height);
      if ((width > 0) && (height > 0))
	{
	  size_x = width;
	  size_y = height;
	}
    }
  
  if (!exec_me) 
    {
      struct passwd *p;
      p = getpwuid(getuid());
      if (p != NULL) 
	{
	  exec_me = p->pw_shell;
	}
    }
  title = strstr (exec_me, "/");
  if (title == NULL)
    {
      title = exec_me; /* sven */
    } 
  else
    {
      ++title;
      while (strstr (title, "/"))
	{
	  title = strstr (title, "/") + 1;
	}
    }
  
  strcpy (origcommand, exec_me);
  

  bzero (command, 512);
  bzero (args, 512);
  
  tmp = strstr (origcommand, " ");
  if (!tmp)
    strcpy (command, origcommand);
  else
    {
      *tmp = '\0';
      strcpy (command, origcommand);
      *tmp = ' ';
      tmp++;
      strcpy (args, tmp);
    }
  

      
  gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (quit_proggie),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (window), "configure_event", GTK_SIGNAL_FUNC (configure_event),
		      NULL);
  
  gtk_signal_connect (GTK_OBJECT (notebook), "switch-page", 
		      GTK_SIGNAL_FUNC (NotebookHandler), NULL);

  gtk_signal_connect (GTK_OBJECT (notebook), "button-press-event",
		      GTK_SIGNAL_FUNC (notebook_click_event), NULL);
  
  /* show them all! */
  gtk_notebook_set_show_border (GTK_NOTEBOOK(notebook), FALSE);

  

  sprintf (tmpstr, "PowerShell - [%s]", origcommand);

  /*gtk_window_set_title (GTK_WINDOW(window), tmpstr);
    gtk_widget_realize (window);*/

  XSync(GDK_DISPLAY(), False);

  ros2 = 1;

  for (a=0;a<num_apps;a++)
    {
      if (app_entries[a].run_on_startup)
	ros2 = 0;
    }

  if (Prefs.run_def_shell || ros2)
    {
      if (!geom)
	{
	  term = new_term (GTK_WIDGET(notebook), command, args, title);
	}
      else
	{
	  term = new_term_x (GTK_WIDGET(notebook), command, args, title, size_x, size_y);
	}
    }

  /* check for anything set to run on startup and run it */
  for (a=0;a<num_apps;a++)
    {
      if (app_entries[a].run_on_startup)
	MenuHandler (NULL, (gpointer)(a+1));

    }
  
  term = get_nth_zvt (GTK_NOTEBOOK(notebook), 0);
  
  gtk_widget_show(notebook);
  gtk_widget_show_all (window);    

  window_shown = 1;

  set_color_scheme (ZVT_TERM(term), ColorPrefs);

  if (Prefs.hidemenubar)
    gtk_widget_hide (GNOME_APP(window)->menubar->parent);
  if (Prefs.hidestatusbar)
    gtk_widget_hide (GNOME_APP(window)->statusbar->parent);





  InitIPC (pid);

  /* main loop */
  gtk_main ();
  gtk_exit(0);
  return 0;
}



  
