--TEST--
maxdb_fetch_fields
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
$link = maxdb_connect("localhost", "MONA", "RED", "DEMODB");

/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

$query = "SELECT name, cno from hotel.customer ORDER BY cno";

if ($result = maxdb_query($link, $query)) {

   /* Get field information for all columns */
   $finfo = maxdb_fetch_fields($result);
 
   for ($i=0; $i < count($finfo); $i++) { 
       printf("Name:     %s\n", $finfo[$i]->name);
       printf("Table:    %s\n", $finfo[$i]->table);
       printf("max. Len: %d\n", $finfo[$i]->max_length);
       printf("Flags:    %d\n", $finfo[$i]->flags);
       printf("Type:     %d\n\n", $finfo[$i]->type);
   }    
   maxdb_free_result($result);
}

/* close connection */
maxdb_close($link);
?>
--EXPECTF--
Name:     NAME
Table: %s
max. Len: 10
Flags:    -1
Type:     2

Name:     CNO
Table: %s
max. Len: 4
Flags:    -1
Type:     0