<? $page = 3; include './header.inc' ?>

<u>Documentation</u>
<p>
Below is a brief blurb about each of the functions in the php_imlib
extension.  For examples of how these are used, see the <a
href="examples.php">examples page</a>.  There are also some PHP classes
included with php_imlib (Which also have examples posted on the examples
page).  These classfiles have been documented using the
<a href="http://www.phpdoc.de">PHPDoc</a> documentation system.  That
documentation can be found <a href="phpdoc/phpdoc_classtree.html">here</a>.
</p>

<table><tr><td valign="top">
<font size="-1">
<a href="#constants">Predefined Constants</a><br><br>
<a href="#imlib_add_color_to_color_range">imlib_add_color_to_color_range</a><br>
<a href="#imlib_blend_image_onto_image">imlib_blend_image_onto_image</a><br>
<a href="#imlib_clone_image">imlib_clone_image</a><br>
<a href="#imlib_create_color_range">imlib_create_color_range</a><br>
<a href="#imlib_create_cropped_image">imlib_create_cropped_image</a><br>
<a href="#imlib_create_cropped_scaled_image">imlib_create_cropped_scaled_image</a><br>
<a href="#imlib_create_image">imlib_create_image</a><br>
<a href="#imlib_create_rotated_image">imlib_create_rotated_image</a><br>
<a href="#imlib_create_scaled_image">imlib_create_scaled_image</a><br>
<a href="#imlib_dump_image">imlib_dump_image</a><br>
<a href="#imlib_free_color_range">imlib_free_color_range</a><br>
<a href="#imlib_free_font">imlib_free_font</a><br>
<a href="#imlib_free_image">imlib_free_image</a><br>
<a href="#imlib_get_text_size">imlib_get_text_size</a><br>
<a href="#imlib_image_blur">imlib_image_blur</a><br>
<a href="#imlib_image_draw_ellipse">imlib_image_draw_ellipse</a><br>
<a href="#imlib_image_draw_line">imlib_image_draw_line</a><br>
<a href="#imlib_image_draw_polygon">imlib_image_draw_polygon</a><br>
<a href="#imlib_image_draw_rectangle">imlib_image_draw_rectangle</a><br>
<a href="#imlib_image_fill_color_range_rectangle">imlib_image_fill_color_range_rectangle</a><br>
<a href="#imlib_image_fill_ellipse">imlib_image_fill_ellipse</a><br>
<a href="#imlib_image_fill_polygon">imlib_image_fill_polygon</a><br>
<a href="#imlib_image_fill_rectangle">imlib_image_fill_rectangle</a><br>
<a href="#imlib_image_flip_horizontal">imlib_image_flip_horizontal</a><br>
<a href="#imlib_image_flip_vertical">imlib_image_flip_vertical</a><br>
<a href="#imlib_image_flip_diagonal">imlib_image_flip_diagonal</a><br>
<a href="#imlib_image_format">imlib_image_format</a><br>
<a href="#imlib_image_get_filename">imlib_image_get_filename</a><br>
<a href="#imlib_image_get_height">imlib_image_get_height</a><br>
<a href="#imlib_image_get_width">imlib_image_get_width</a><br>
<a href="#imlib_image_has_alpha">imlib_image_has_alpha</a><br>
<a href="#imlib_image_modify_alpha">imlib_image_modify_alpha</a><br>
<a href="#imlib_image_set_format">imlib_image_set_format</a><br>
<a href="#imlib_image_sharpen">imlib_image_sharpen</a><br>
<a href="#imlib_image_tile_horizontal">imlib_image_tile_horizontal</a><br>
<a href="#imlib_image_tile_vertical">imlib_image_tile_vertical</a><br>
<a href="#imlib_image_tile">imlib_image_tile</a><br>
<a href="#imlib_list_fonts">imlib_list_fonts</a><br>
<a href="#imlib_load_font">imlib_load_font</a><br>
<a href="#imlib_load_image">imlib_load_image</a><br>
<a href="#imlib_polygon_add_point">imlib_polygon_add_point</a><br>
<a href="#imlib_polygon_contains_point">imlib_polygon_contains_point</a><br>
<a href="#imlib_polygon_free">imlib_polygon_free</a><br>
<a href="#imlib_polygon_get_bounds">imlib_polygon_get_bounds</a><br>
<a href="#imlib_polygon_new">imlib_polygon_new</a><br>
<a href="#imlib_save_image">imlib_save_image</a><br>
<a href="#imlib_text_draw">imlib_text_draw</a><br>
</font>
</td><td>

<table><tr><td class="d-cell">
<u>Getting and Setting Image Parameters</u><dl>

<a name="imlib_image_format">
<dt><code>string imlib_image_format(int img)</code></dt>
<dd>Returns the image format of an image</dd>
<br><br>

<a name="imlib_image_get_filename">
<dt><code>string imlib_image_get_filename(int img)</code></dt>
<dd>Returns the filename of an image</dd>
<br><br>

<a name="imlib_image_get_height">
<dt><code>int imlib_image_get_height(int img)</code></dt>
<dd>Returns the height of an image</dd>
<br><br>

<a name="imlib_image_get_width">
<dt><code>int imlib_image_get_width(int img)</code></dt>
<dd>Returns the width of an image</dd>
<br><br>

<a name="imlib_image_has_alpha">
<dt><code>bool imlib_image_has_alpha(int img)</code></dt>
<dd>Return a boolean for whether or not an image has an alpha channel</dd>
<br><br>

<a name="imlib_image_modify_alpha">
<dt><code>void imlib_image_modify_alpha(int img, int alpha)</code></dt>
<dd>Set the alpha channel of an image, or modify it if one was already present</dd>
<br><br>

<a name="imlib_image_set_format">
<dt><code>void imlib_image_set_format(int img, string format)</code></dt>
<dd>Sets the image format of an image.</dd>

</dl>
</td></tr></table>
<br>

<table><tr><td class="d-cell">
<u>Loading/Saving Functions</u><dl>

<a name="imlib_free_image">
<dt><code>void imlib_free_image(int img)</code></dt>
<dd>Free an image</dd>
<br><br>

<a name="imlib_load_image">
<dt><code>int imlib_load_image(string img[, int &err])</code></dt>
<dd>Load a file into an image, optionally fetch an error parameter</dd>
<br><br>

<a name="imlib_save_image">
<dt><code>bool imlib_save_image(int img, string name[, int &err[, int quality]])</code></dt>
<dd>Save an image to a file, at an optional quality level (1-100) for jpegs.  For pngs, the value will be converted to a compression level (0-9)</dd>

</dl>
</td></tr></table>
<br>

<table><tr><td class="d-cell">
<u>Creation Functions</u><dl>

<a name="imlib_clone_image">
<dt><code>int imlib_clone_image(int img)</code></dt>
<dd>Duplicate an image</dd>
<br><br>

<a name="imlib_create_color_range">
<dt><code>int imlib_create_color_range()</code></dt>
<dd>Create a new color range</dd>
<br><br>

<a name="imlib_create_cropped_image">
<dt><code>int imlib_create_cropped_image(int img, int srcx, int srcy, int srcw, int srch)</code></dt>
<dd>Create an image from a cropped region of another image</dd>
<br><br>

<a name="imlib_create_cropped_scaled_image">
<dt><code>int imlib_create_cropped_scaled_image(int img, int srcx, int srcy, int srcw, int srch, int dstw, int dsth)</code></dt>
<dd>Create a scaled image from a cropped region of another image</dd>
<br><br>

<a name="imlib_create_image">
<dt><code>int imlib_create_image(int w, int h)</code></dt>
<dd>Create a new image with the specified dimensions</dd>
<br><br>

<a name="imlib_create_rotated_image">
<dt><code>int imlib_create_rotated_image(int srcimg, int degrees[, int radians])</code></dt>
<dd>Create a rotated copy of an image.  If radians is specified, degrees will be ignored.</dd>
<br><br>

<a name="imlib_create_scaled_image">
<dt><code>int imlib_create_scaled_image(int img, int dstw, int dsth)</code></dt>
<dd>Create a scaled copy of an image.  If dstw or dsth is left blank, the aspect ratio of the source image will be preserved.</dd>
<br><br>

<a name="imlib_dump_image">
<dt><code>bool imlib_dump_image(int img[, int &err[, int quality]])</code></dt>
<dd>Output an image at an optional quality setting</dd>

</dl>
</td></tr></table>
<br>

<table><tr><td class="d-cell">
<u>Rendering Functions</u><dl>

<a name="imlib_blend_image_onto_image">
<dt><code>void imlib_blend_image_onto_image(int dstimg, int srcimg, int malpha, int srcx, int srcy, int srcw, int srch, int dstx, int dsty, int dstw, int dsth, char dither, char blend, char alias)</code></dt>
<dd>Blend a rectangular area from an image onto an area of another image, scaling as necessary</dd>

</dl>
</td></tr></table>
<br>

<table><tr><td class="d-cell">
<u>Image Modification Functions</u><dl>

<a name="imlib_image_blur">
<dt><code>void imlib_image_blur(int img, int radius)</code></dt>
<dd>Blur an image with a given blur radius</dd>
<br><br>

<a name="imlib_image_flip_horizontal">
<dt><code>void imlib_image_flip_horizontal(int img)</code></dt>
<dd>Flip an image horizontally</dd>
<br><br>

<a name="imlib_image_flip_vertical">
<dt><code>void imlib_image_flip_vertical(int img)</code></dt>
<dd>Flip an Imlib_Image vertically</dd>
<br><br>

<a name="imlib_image_flip_diagonal">
<dt><code>void imlib_image_flip_diagonal(int img)</code></dt>
<dd>Flip an image diagonally</dd>
<br><br>

<a name="imlib_image_sharpen">
<dt><code>void imlib_image_sharpen(int img, int radius)</code></dt>
<dd>Sharpen an image with a given sharpen radius</dd>
<br><br>

<a name="imlib_image_tile_horizontal">
<dt><code>void imlib_image_tile_horizontal(int img)</code></dt>
<dd>Tile an image horizontally</dd>
<br><br>

<a name="imlib_image_tile_vertical">
<dt><code>void imlib_image_tile_vertical(int img)</code></dt>
<dd>Tile an image vertically</dd>
<br><br>

<a name="imlib_image_tile">
<dt><code>void imlib_image_tile(int img)</code></dt>
<dd>Tile an image horizontally and diagonally</dd>

</dl>
</td></tr></table>
<br>

<table><tr><td class="d-cell">
<u>Drawing on Images</u><dl>

<a name="imlib_image_draw_ellipse">
<dt><code>bool imlib_image_draw_ellipse(int img, int xc, int yc, int w, int h, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Draw an ellipse of the specified size and color on an image</dd>
<br><br>

<a name="imlib_image_draw_line">
<dt><code>bool imlib_image_draw_line(int img, int x1, int y1, int x2, int y2, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Draw a line of the specified size and color on an image</dd>
<br><br>

<a name="imlib_image_draw_polygon">
<dt><code>bool imlib_image_draw_polygon(int img, int polygon, bool closed, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Draw the defined polygon on an image</dd>
<br><br>

<a name="imlib_image_draw_rectangle">
<dt><code>bool imlib_image_draw_rectangle(int img, int x, int y, int w, int h, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Draw a rectangle of the specified size and color on an image</dd>
<br><br>

<a name="imlib_image_fill_color_range_rectangle">
<dt><code>bool imlib_image_fill_color_range_rectangle(int im, int cr, int x, int y, int width, int height, int angle)</code></dt>
<dd>Fill a rectangle with a color range at a given angle on an image</dd>
<br><br>

<a name="imlib_image_fill_ellipse">
<dt><code>void imlib_image_fill_ellipse(int img, int xc, int yc, int w, int h, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Fill an ellipse of the specified size and color on an image</dd>
<br><br>

<a name="imlib_image_fill_polygon">
<dt><code>bool imlib_image_fill_polygon(int img, int polygon, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Draw and fill the defined polygon on an image</dd>
<br><br>

<a name="imlib_image_fill_rectangle">
<dt><code>void imlib_image_fill_rectange(int img, int x, int y, int w, int h, int r, int g, int b, int a[, array cliprect])</code></dt>
<dd>Fill a rectangle of the specified size and color on an image</dd>

</dl>
</td></tr></table>
<br> 

<table><tr><td class="d-cell">
<u>Fonts and Text Functions</u><dl>

<a name="imlib_free_font">
<dt><code>void imlib_free_font(int font)</code></dt>
<dd>Free a font</dd>
<br><br>

<a name="imlib_get_text_size">
<dt><code>void imlib_get_text_size(int font, string str, int &w, int &h, int direction)</code></dt>
<dd>Determines the width and height of a string if drawn with a given font in the specified direction</dd>
<br><br>

<a name="imlib_list_fonts">
<dt><code>array imlib_list_fonts()</code></dt>
<dd>Return an array of all the fonts available in the font path</dd>
<br><br>

<a name="imlib_load_font">
<dt><code>int imlib_load_font(string fontname)</code></dt>
<dd>Load a font</dd>
<br><br>

<a name="imlib_text_draw">
<dt><code>void imlib_text_draw(int img, int font, int x, int y, string str, int direction, int r, int g, int b, int a)</code></dt>
<dd>Draw a text string using a font onto an image</dd>

</dl>
</td></tr></table>
<br> 

<table><tr><td class="d-cell">
<u>Color Ranges</u><dl>

<a name="imlib_add_color_to_color_range">
<dt><code>void imlib_add_color_to_color_range(int cr, int x, int r, int g, int b, int a)</code></dt>
<dd>Add a color to a color range at a specified distance from the previous color in the range.  A distance of 0 centers it</dd>
<br><br>

<a name="imlib_free_color_range">
<dt><code>void imlib_free_color_range(int cr)</code></dt>
<dd>Free a color range</dd>

</dl>
</td></tr></table>
<br> 

<table><tr><td class="d-cell">
<u>Polygons</u><dl>

<a name="imlib_polygon_add_point">
<dt><code>void imlib_polygon_add_point(int polygon, int x, int y)</code></dt>
<dd>Add a point to a given polygon</dd>
<br><br>

<a name="imlib_polygon_contains_point">
<dt><code>bool imlib_polygon_contains_point(int polygon, int x, int y)</code></dt>
<dd>Check if a give point is inside a polygon</dd>
<br><br>

<a name="imlib_polygon_free">
<dt><code>void imlib_polygon_free(int polygon)</code></dt>
<dd>Free a polygon</dd>
<br><br>

<a name="imlib_polygon_get_bounds">
<dt><code>void imlib_polygon_get_bounds(int polygon, int &x1, int &y1, int &x2, int &y2)</code></dt>
<dd>Get the bounding coords of a polygon</dd>
<br><br>

<a name="imlib_polygon_new">
<dt><code>int imlib_polygon_new()</code></dt>
<dd>Create a new polygon</dd>

</dl>
</td></tr></table>

</td></tr>
</table>
