/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcomski 
 * file    : scannet.c 
 * date    : 2001-12-03
 * modify  : 2002-11-11 by elcomski
 */
/* ----------------------------------------------- */
#include <linux/config.h> 
#include <linux/modversions.h> /* to avoid unresolved symbol */
#include <linux/module.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/netdevice.h>   /* struct device,other headers */
#include <linux/proc_fs.h>



/*----------------------------------------- */
/* Constant definitions */
/*----------------------------------------- */
#define PENTANET_VENDOR_ID  		0x15c8
#define PENTANET_DEVICE_ID  		0x9050
#define PENTANET_SUBSYSTEM_VENDOR_ID 	0x15c8
#define PENTANET_SUBSYSTEM_ID 		0x9050



/*----------------------------------------- */
/* Structure definitions */
/*----------------------------------------- */
static struct proc_dir_entry *pentanet_proc;
static int pentanet_card_found = 0;

MODULE_LICENSE("GPL");

/*----------------------------------------- */
/* Function definitions */
/*----------------------------------------- */

/*
 * Func : proc_pentanet_dump
 * Context:
 */
static int proc_pentanet_dump( char *buf, char **start, off_t fpos, int length, int *eof , void *data )
{
	int len = 0;
	
	len += sprintf( (buf+len), "%d", pentanet_card_found );

	if( fpos >= len ){
		*start = buf;
		*eof = 1 ;
		return 0;
	}

	*start = buf + fpos;
	if(( len -= fpos) > length ){
		return length;
	}
	*eof = 1;
	return len;
}


/* 
 * Func : scannet_init_module  
 * Context :
 */
static int __init scannet_init_module( void )
{
	unsigned char pciBus, pciDeviceFunction;
	static int pciIndex = 0;
	
#ifdef CONFIG_PCI
	if(pcibios_present( )){
	    	struct pci_dev *pdev;
		int result;
	    	for (pciIndex = 0; pciIndex < 0xff; pciIndex++) 
		{
	      		result = pcibios_find_device( PENTANET_VENDOR_ID, PENTANET_DEVICE_ID, pciIndex, &pciBus, &pciDeviceFunction);
	       		if(result != PCIBIOS_SUCCESSFUL) break;

			pdev = pci_find_slot( pciBus, pciDeviceFunction);

			if( !PCI_FUNC(pdev->devfn) ){
				if(!pentanet_card_found){
					pentanet_card_found++;
					/* install the proc device */
					pentanet_proc = create_proc_read_entry( "pentanet", 0, NULL, proc_pentanet_dump, NULL );
				}else pentanet_card_found++;
			}
    		}
	}
	
    	if(pciIndex == 0) return -ENODEV;
#else
	return -ENODEV;
#endif
	return 0;
}
	

/* 
 * Func : scannet_cleanup_module  
 */
static void __exit scannet_cleanup_module( void )
{
	/* remove the proc device */
	if( pentanet_proc ){
		remove_proc_entry("pentanet", NULL);
	}
}

module_init( scannet_init_module );
module_exit( scannet_cleanup_module );
