/*****************************************************************************/
/*                                                                           */
/* nimdef.h - this file contains definitions for nim.c                       */
/*                                                                           */
/* 1998. 7. 15. H. D. Sung                                                   */
/*****************************************************************************/

#ifndef __NIMDRVDEF_H__
#define __NIMDRVDEF_H__

/* generic */
#define SUCC 0
#define FAIL -1
#define true 1
#define false 0
/* typedef short boolean; */
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long lword;

/* nim_control() command mnemonic */
#define NIM_LNBCNTL               4
#define NIM_BERT                  8
#define NIM_SPECTRUM             12

/* submode of command NIM_BERT */
#define TEST_VITERBIOUT 1
#define TEST_TRISTATE 2

/* submode of command NIM_SPECTRUM */
#define AC_CTRL                   1
#define DC_CTRL                   2

/* submode of command NIM_SIGQLTY */
#define COARSE                    1
#define FINE                      2

/* submode of command NIM_SPECTRUM */
#define SPECTRUM_INVERT                    1
#define SPECTRUM_NORMAL                    2
#define SPECTRUM_TOGGLE                    3
#define SPECTRUM_AUTOMATIC                 4

/* value for Viterbi rate HDM8513 */
typedef enum
{
  VFIXED_1_2,
  VFIXED_2_3,
  VFIXED_3_4,
  VFIXED_5_6,
  VFIXED_7_8,
  VFIXED_6_7,
  VAUTOMATIC
} EN_VITERBI_8513;

// Viterbi rate definition in EN 300 468 
#ifndef _EN_VITERBI_468
#define _EN_VITERBI_468
typedef enum
{
  FEC_AUTOMATIC,
  FEC_INNER_1_2,
  FEC_INNER_2_3,
  FEC_INNER_3_4,
  FEC_INNER_5_6,
  FEC_INNER_7_8
} EN_VITERBI_468;
#endif

// for lnb polarisation & band selection 
#ifndef _LNB_CTRL
#define _LNB_CTRL
typedef enum
{
  LNB_POL_VERTICAL,
  LNB_POL_HORIZONTAL,
  LNB_BAND_HIGH,
  LNB_BAND_LOW
} LNB_CTRL;
#endif

/* for satellite transponder information */
typedef struct
{
  byte bCenterFrqBCD[4];
  byte bSymbolViterbiBCD[4];
} TRANSPORT_INFO;

/* for tuner saw filter selection */
typedef enum
{
  TSAW_SINGLE, /* single SAW BW tuner */
  TSAW_DUAL_1, /* dual SAW BW lower one selected */
  TSAW_DUAL_2  /* dual SAW BW higher one selected */
} EN_TSAW_BW;

typedef enum
{
  NORMAL_SPECTRUM,
  INVERTED_SPECTRUM
} EN_SPECTRUM;

typedef enum
{
  QPSK_UNLOCKED,
  QPSK_LOCKED_FEC_UNLOCKED,
  ALL_LOCKED,
} qpsk_lock_t;

typedef enum
{
  TUNER_PLL_UNLOCKED,
  TUNER_PLL_LOCKED
} tuner_lock_t;

typedef struct
{
  word wProgrammableDivider;
  int iStepIncrement;
  tuner_lock_t enLock;
} tuning_tuner_status_t;

typedef struct
{
  long lSweepStartFrequency;
  long lSweepEndFrequency;
  EN_SPECTRUM enSpectrum;
  qpsk_lock_t enLock;
} tuning_qpsk_status_t;

typedef struct
{
	long lCurrentFrequency;
} tuning_nim_status_t;

typedef struct
{
  lword lwFrequency;
  EN_TSAW_BW enSawBW;
  tuning_tuner_status_t stStatus;
} tuner_t;

typedef struct
{
  lword lwSymbol;
  EN_VITERBI_468 enViterbi;
  tuning_qpsk_status_t stStatus;
} qpsk_t;

typedef struct
{
  long lLnbDriftFrequency; /* allowable max lnb drift frequency */
  tuner_t tuner_param;     /* parameters for tuner setting      */
  qpsk_t qpsk_param;       /* parameters for qpsk setting       */
	tuning_nim_status_t nim_status;
} tuning_t;

typedef enum
{
    INIT,
    UPDATE,
} tuner_mode_t;


#endif

/* EOF */
