/*****************************************************************************/
/*                                                                           */
/* misc.c - timing related functions for WIN95                               */
/*                                                                           */
/* 1999. 1. 15. H. D. Sung                                                   */
/*****************************************************************************/

///#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include "../../share/xptype.h"

#include "nimdef.h"
#include "misc.h"

/*****************************************************************************/
/* name: elapsed                                                             */
/*                                                                           */
/* description: returns true if time required elapsed                        */
/*                                                                           */
/* side effect:                                                              */
/*                                                                           */
/* date 1998. 10. 8.                                                         */
/* note: 1.                                                                  */
/*                                                                           */
/*****************************************************************************/
BOOL elapsed( struct timeval stamp_tv, long int limit )
{
	BOOL fReturn = FALSE;

	struct timeval current_tv;
	long int diff_usec, diff_msec ;

	// GetTickCount() returns elapsed msec. time since window started..
	// this return valud might be wrapped arround to zero after 49.7 days..
	///Time = GetTickCount();
  
	//printf("elapsed stamp_tv   : sec:%lu, usec:%lu\n",stamp_tv.tv_sec, stamp_tv.tv_usec ); 
	if( gettimeofday( &current_tv , NULL ) == 0){
		diff_usec =  (( current_tv.tv_sec - stamp_tv.tv_sec ) * 1000000) + ( current_tv.tv_usec - stamp_tv.tv_usec );
		diff_msec = diff_usec / 1000;
		//printf("elapsed current_tv : sec:%lu, usec:%lu\n",current_tv.tv_sec, current_tv.tv_usec ); 
		//printf("-----> limit:%lu : diff: %lu(%lu)\n",limit, diff_usec, diff_msec);
		if(  diff_msec > limit ) fReturn = TRUE;
		return fReturn;
	}

	return 0;
}

/*****************************************************************************/
/* name: stamp                                                               */
/*                                                                           */
/* description: stamp current time                                           */
/*                                                                           */
/* side effect:                                                              */
/*                                                                           */
/* date 1998. 10. 8.                                                         */
/* note: 1.                                                                  */
/*                                                                           */
/*****************************************************************************/
//void stamp( DWORD *dwStamp )
void stamp( struct timeval *now_tv )
{
	//*dwStamp = GetTickCount();
	if( gettimeofday( now_tv , NULL ) == 0 ){
		//printf("stamp : sec:%lu, usec:%lu\n",now_tv->tv_sec, now_tv->tv_usec ); 
	}
}


void mSleep( int ms )
{
	int i;
	for ( i = 0 ; i < ms ; i++ ){
		usleep( 1000 );
	}
}
/* EOF */
