/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.Header;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.GroupRequest;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;
import org.javagroups.util.RspList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GroupRequestPull
implements MessageListener,
MembershipListener,
Transport {
    static final String HDRNAME = "GroupRequestPullHeader";
    PullPushAdapter adapter;
    Channel ch;
    String props;
    GroupRequest group_req;
    Vector members;

    void start() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.connect("GroupRequestPull-Group");
        this.adapter = new PullPushAdapter(this.ch, this, this);
        this.loop();
        this.adapter.stop();
        this.ch.close();
    }

    void loop() throws Exception {
        boolean looping = true;
        while (looping) {
            System.out.println("Members are " + this.ch.getView().getMembers() + "\n<enter to send a new group request>");
            System.out.flush();
            int c = System.in.read();
            if (c == 113) {
                looping = false;
            }
            System.in.skip(System.in.available());
            this.sendGroupRequest();
        }
    }

    void sendGroupRequest() throws Exception {
        Message msg = new Message();
        msg.putHeader(HDRNAME, new MyHeader(1));
        this.group_req = new GroupRequest(msg, this, this.members, 2);
        this.group_req.execute();
        RspList lst = this.group_req.getResults();
        System.out.println("-- received " + lst.size() + " results:");
        int i = 0;
        while (i < lst.size()) {
            System.out.println(lst.elementAt(i));
            ++i;
        }
        System.out.println();
    }

    public void receive(Message msg) {
        MyHeader hdr = (MyHeader)msg.removeHeader(HDRNAME);
        if (hdr == null) {
            System.err.println("GroupRequestPull.receive(): header for GroupRequestPullHeader was null");
            return;
        }
        if (hdr.type == 2) {
            if (this.group_req != null) {
                this.group_req.receiveResponse(msg);
            }
        } else if (hdr.type == 1) {
            Message rsp = new Message(msg.getSrc(), null, null);
            rsp.putHeader(HDRNAME, new MyHeader(2));
            rsp.setObject((Serializable)((Object)("Hello from member " + this.ch.getLocalAddress())));
            try {
                this.adapter.send(rsp);
            }
            catch (Exception ex) {
                System.err.println("GroupRequestPull.receive(): failure sending response: " + ex);
            }
        } else {
            System.err.println("GroupRequestPull.receive(): header type of " + hdr.type + " not known");
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        System.out.println("** viewAccepted(): " + new_view);
        if (new_view != null && new_view.getMembers().size() > 0) {
            this.members.removeAllElements();
            this.members.addAll(new_view.getMembers());
        }
        if (this.group_req != null) {
            this.group_req.viewChange(new_view);
        }
    }

    public void suspect(Address suspected_mbr) {
        System.out.println("** suspect(): " + suspected_mbr);
        if (this.group_req != null) {
            this.group_req.suspect(suspected_mbr);
        }
    }

    public void block() {
    }

    public void send(Message msg) throws Exception {
        if (this.adapter == null) {
            System.err.println("GroupRequestPull.send(): adapter is null, cannot send message");
        } else {
            this.adapter.send(msg);
        }
    }

    public Object receive(long timeout) throws Exception {
        return null;
    }

    public static void main(String[] args) {
        String props = null;
        int i = 0;
        while (i < args.length) {
            if (!args[i].equals("-props")) {
                GroupRequestPull.help();
                return;
            }
            props = args[++i];
            ++i;
        }
        Trace.init();
        try {
            new GroupRequestPull(props).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("GroupRequestPull [-help] [-props <properties>]");
    }

    private final /* synthetic */ void this() {
        this.adapter = null;
        this.ch = null;
        this.props = null;
        this.group_req = null;
        this.members = new Vector();
    }

    GroupRequestPull(String props) {
        this.this();
        this.props = props;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class MyHeader
    extends Header {
        public static final int REQUEST = 1;
        public static final int RESPONSE = 2;
        int type;

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
        }

        public MyHeader() {
            this.this();
        }

        public MyHeader(int type) {
            this.this();
            this.type = type;
        }
    }
}

