#
# backport.inc
#
# $Id: backport.inc,v 1.6 2004/09/14 14:19:43 renaud Exp $
#
#
# When a security flaw is discovered, many OS vendors do not update the product
# to its latest version, but tend to backport the patches instead. This module
# does a translation between the "fixed" (according to the vendor) products, and
# the latest version number.
#
# Credits: This excellent idea comes is from Laurent FACQ (facq@u-bordeaux.fr) and was
# initially designed to handle Debian. The idea has then been extended to be broader
# than only Debian.
#
# Usage : 
#  new_banner = get_backport_banner(banner:orig_banner);
#
#
#

function get_backport_banner(banner)
{
 local_var i, j,k,l,backported_versions, real_versions, rx_backported_versions, rx_real_versions;

 i = 0;
 j = 0;
 k = 0;
 l = 0;

#
# Debian
#   
rx_backported_versions[k++] = '.*OpenSSH_3\\.4p1 Debian 1:3.4p1-1\\.woody\\.3';
rx_real_versions[l++]        = "SSH-2.0-OpenSSH_3.7.1p2 ConvertedDebian 1:3.4p1-1.woody.3";


rx_backported_versions[k++] = '.*OpenSSH_3\\.6\\.1p2 Debian 1:3\\.6\\.1p2-3\\.sarge\\.1';
rx_real_versions[l++]        = "SSH-2.0-OpenSSH_3.7.1p2 ConvertedDebian 1:3.6.1p2-3.sarge.1";

backported_versions[i++] = "Sendmail 8.12.3/8.12.3/Debian-6.6;";
real_versions[j++]	 = "Sendmail 8.12.10/8.12.10/ConvertedDebian;";

#
# MacOS X
# 

rx_backported_versions[k++] = 'OpenSSH_3\\.6\\.1p1\\+CAN-2003-0693';
rx_real_versions[l++]	 = "SSH-2.0-OpenSSH_3.7.1p2 ConvertedMacOSX+CAN-2003-0693";

rx_backported_versions[k++] = 'OpenSSH_3\\.6\\.1p1\\+CAN-2004-0175';
rx_real_versions[l++]	 = "SSH-2.0-OpenSSH_3.7.1p2 ConvertedMacOSX+CAN-2004-0175";
#
# AltLinux 
#
rx_backported_versions[k++] = 'OpenSSH_3\\.6\\.1p2-alt4';
rx_real_versions[l++]       = "SSH-2.0-OpenSSH_3.7.1p2-convertedAlt4";


# 
# FreeBSD
#
rx_backported_versions[k++] = "OpenSSH.*FreeBSD.*(20030916|200[4-9])";
rx_real_versions[l++]       = "OpenSSH_3.7.1p2 ConvertedFreeBSD-20030916";


#
# IBM's Apache
# 
backported_versions[i++]   = "IBM_HTTP_SERVER/1.3.19.4 Apache/1.3.20"; 
real_versions[j++]         = "Apache/1.3.28 (ConvertedIBM)";

backported_versions[i++]   = "IBM_HTTP_SERVER/1.3.19.6 Apache/1.3.20"; 
real_versions[j++]         = "Apache/1.3.29 (ConvertedIBM)";





for ( i = 0 ; backported_versions[i] ; i ++ )
 { 
 if ( tolower(backported_versions[i]) >< tolower(banner) ) 
	return str_replace(find:backported_versions[i], replace:real_versions[i], string:banner);
 }

 for ( i = 0; rx_backported_versions[i]; i ++ )
 {
  if ( egrep(pattern:rx_backported_versions[i], string:banner, icase:TRUE) ) 
   return ereg_replace(pattern:rx_backported_versions[i], 
		       replace:rx_real_versions[i],
		       string:banner, icase:TRUE);
 }


 return banner;
}
